/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.wan;

import com.hazelcast.config.Config;
import com.hazelcast.config.ConsistencyCheckStrategy;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.WanConsumerConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.config.WanSyncConfig;
import com.hazelcast.internal.config.MergePolicyValidator;
import com.hazelcast.jet.impl.util.ConcurrentMemoizingSupplier;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergePolicyProvider;
import com.hazelcast.wan.impl.DelegatingWanScheme;
import com.hazelcast.wan.impl.WanReplicationService;

public class MapWanContext {
    protected volatile SplitBrainMergePolicy wanMergePolicy;
    protected volatile ConcurrentMemoizingSupplier<DelegatingWanScheme> wanReplicationDelegateSupplier;
    private final String name;
    private final MapServiceContext mapServiceContext;
    private MapConfig mapConfig;
    private volatile boolean persistWanReplicatedData;

    public MapWanContext(MapContainer mapContainer) {
        this.mapConfig = mapContainer.getMapConfig();
        this.name = mapContainer.getName();
        this.mapServiceContext = mapContainer.getMapServiceContext();
    }

    public void setMapConfig(MapConfig mapConfig) {
        this.mapConfig = mapConfig;
    }

    public void start() {
        this.initWanReplication();
    }

    private void initWanReplication() {
        WanConsumerConfig wanConsumerConfig;
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        WanReplicationRef wanReplicationRef = this.mapConfig.getWanReplicationRef();
        if (wanReplicationRef == null) {
            this.wanReplicationDelegateSupplier = null;
            return;
        }
        String wanReplicationRefName = wanReplicationRef.getName();
        Config config = nodeEngine.getConfig();
        if (!Boolean.TRUE.equals(this.mapConfig.getMerkleTreeConfig().getEnabled()) && this.hasPublisherWithMerkleTreeSync(config, wanReplicationRefName)) {
            throw new InvalidConfigurationException("Map " + this.name + " has disabled merkle trees but the WAN replication scheme " + wanReplicationRefName + " has publishers that use merkle trees. Please enable merkle trees for the map.");
        }
        WanReplicationService wanReplicationService = nodeEngine.getWanReplicationService();
        this.wanReplicationDelegateSupplier = null;
        if (wanReplicationService.hasWanReplicationScheme(wanReplicationRefName)) {
            this.wanReplicationDelegateSupplier = new ConcurrentMemoizingSupplier<DelegatingWanScheme>(() -> wanReplicationService.getWanReplicationPublishers(wanReplicationRefName));
        }
        SplitBrainMergePolicyProvider mergePolicyProvider = nodeEngine.getSplitBrainMergePolicyProvider();
        this.wanMergePolicy = mergePolicyProvider.getMergePolicy(wanReplicationRef.getMergePolicyClassName());
        MergePolicyValidator.checkMapMergePolicy(this.mapConfig, wanReplicationRef.getMergePolicyClassName(), mergePolicyProvider);
        WanReplicationConfig wanReplicationConfig = config.getWanReplicationConfig(wanReplicationRefName);
        if (wanReplicationConfig != null && (wanConsumerConfig = wanReplicationConfig.getConsumerConfig()) != null) {
            this.persistWanReplicatedData = wanConsumerConfig.isPersistWanReplicatedData();
        }
    }

    private boolean hasPublisherWithMerkleTreeSync(Config config, String wanReplicationRefName) {
        WanReplicationConfig replicationConfig = config.getWanReplicationConfig(wanReplicationRefName);
        if (replicationConfig == null) {
            return false;
        }
        return replicationConfig.getBatchPublisherConfigs().stream().anyMatch(c -> {
            WanSyncConfig syncConfig = c.getSyncConfig();
            return syncConfig != null && ConsistencyCheckStrategy.MERKLE_TREES.equals((Object)syncConfig.getConsistencyCheckStrategy());
        });
    }

    public DelegatingWanScheme getWanReplicationDelegate() {
        if (this.wanReplicationDelegateSupplier == null) {
            return null;
        }
        return this.wanReplicationDelegateSupplier.get();
    }

    public SplitBrainMergePolicy getWanMergePolicy() {
        return this.wanMergePolicy;
    }

    public boolean isWanReplicationEnabled() {
        return this.wanReplicationDelegateSupplier != null && this.wanMergePolicy != null;
    }

    public boolean isWanRepublishingEnabled() {
        return this.isWanReplicationEnabled() && this.mapConfig.getWanReplicationRef().isRepublishingEnabled();
    }

    public boolean isPersistWanReplicatedData() {
        return this.persistWanReplicatedData;
    }
}

