/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.WanAcknowledgeType;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.internal.cluster.ClusterStateListener;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.partition.ChunkSupplier;
import com.hazelcast.internal.partition.ChunkedMigrationAwareService;
import com.hazelcast.internal.partition.IPartitionLostEvent;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.partition.OffloadedReplicationPreparation;
import com.hazelcast.internal.partition.PartitionAwareService;
import com.hazelcast.internal.partition.PartitionMigrationEvent;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.services.ClientAwareService;
import com.hazelcast.internal.services.DistributedObjectNamespace;
import com.hazelcast.internal.services.LockInterceptorService;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.services.NotifiableEventListener;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.services.PostJoinAwareService;
import com.hazelcast.internal.services.RemoteService;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.services.SplitBrainHandlerService;
import com.hazelcast.internal.services.SplitBrainProtectionAwareService;
import com.hazelcast.internal.services.StatisticsAwareService;
import com.hazelcast.internal.services.TenantContextAwareService;
import com.hazelcast.internal.services.TransactionalService;
import com.hazelcast.internal.services.WanSupportingService;
import com.hazelcast.internal.util.MutableLong;
import com.hazelcast.map.LocalMapStats;
import com.hazelcast.map.impl.EventListenerFilter;
import com.hazelcast.map.impl.ExecutorStats;
import com.hazelcast.map.impl.ListenerAdapter;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.MapSplitBrainProtectionAwareService;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nearcache.NearCacheStats;
import com.hazelcast.query.LocalIndexStats;
import com.hazelcast.spi.impl.CountingMigrationAwareService;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.eventservice.EventFilter;
import com.hazelcast.spi.impl.eventservice.EventPublishingService;
import com.hazelcast.spi.impl.eventservice.EventRegistration;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.transaction.TransactionalObject;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.wan.impl.InternalWanEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;

public class MapService
implements ManagedService,
ChunkedMigrationAwareService,
TransactionalService,
RemoteService,
EventPublishingService<Object, ListenerAdapter>,
PostJoinAwareService,
SplitBrainHandlerService,
WanSupportingService,
StatisticsAwareService<LocalMapStats>,
PartitionAwareService,
ClientAwareService,
SplitBrainProtectionAwareService,
NotifiableEventListener,
ClusterStateListener,
LockInterceptorService<Data>,
DynamicMetricsProvider,
TenantContextAwareService,
OffloadedReplicationPreparation {
    public static final String SERVICE_NAME = "hz:impl:mapService";
    protected ManagedService managedService;
    protected CountingMigrationAwareService migrationAwareService;
    protected TransactionalService transactionalService;
    protected RemoteService remoteService;
    protected EventPublishingService eventPublishingService;
    protected PostJoinAwareService postJoinAwareService;
    protected SplitBrainHandlerService splitBrainHandlerService;
    protected WanSupportingService wanSupportingService;
    protected StatisticsAwareService statisticsAwareService;
    protected PartitionAwareService partitionAwareService;
    protected ClientAwareService clientAwareService;
    protected MapSplitBrainProtectionAwareService splitBrainProtectionAwareService;
    protected MapServiceContext mapServiceContext;

    @Override
    public void dispatchEvent(Object event, ListenerAdapter listener) {
        this.eventPublishingService.dispatchEvent(event, listener);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.managedService.init(nodeEngine, properties);
        boolean dsMetricsEnabled = nodeEngine.getProperties().getBoolean(ClusterProperty.METRICS_DATASTRUCTURES);
        if (dsMetricsEnabled) {
            ((NodeEngineImpl)nodeEngine).getMetricsRegistry().registerDynamicMetricsProvider(this);
        }
    }

    @Override
    public void reset() {
        this.managedService.reset();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.managedService.shutdown(terminate);
    }

    @Override
    public Collection<ServiceNamespace> getAllServiceNamespaces(PartitionReplicationEvent event) {
        return this.migrationAwareService.getAllServiceNamespaces(event);
    }

    @Override
    public boolean isKnownServiceNamespace(ServiceNamespace namespace) {
        return this.migrationAwareService.isKnownServiceNamespace(namespace);
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        return this.migrationAwareService.prepareReplicationOperation(event);
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        return this.migrationAwareService.prepareReplicationOperation(event, namespaces);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
        this.migrationAwareService.beforeMigration(event);
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        this.migrationAwareService.commitMigration(event);
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        this.migrationAwareService.rollbackMigration(event);
    }

    @Override
    public Operation getPostJoinOperation() {
        return this.postJoinAwareService.getPostJoinOperation();
    }

    @Override
    public DistributedObject createDistributedObject(String objectName, UUID source, boolean local) {
        return this.remoteService.createDistributedObject(objectName, source, local);
    }

    @Override
    public void destroyDistributedObject(String objectName, boolean local) {
        this.remoteService.destroyDistributedObject(objectName, local);
        this.splitBrainProtectionAwareService.onDestroy(objectName);
    }

    @Override
    public void onReplicationEvent(InternalWanEvent event, WanAcknowledgeType acknowledgeType) {
        this.wanSupportingService.onReplicationEvent(event, acknowledgeType);
    }

    @Override
    public CompletionStage<Void> onSyncBatch(Collection<InternalWanEvent> batch, WanAcknowledgeType acknowledgeType) {
        return this.wanSupportingService.onSyncBatch(batch, acknowledgeType);
    }

    @Override
    public void onWanConfigChange() {
        this.wanSupportingService.onWanConfigChange();
    }

    @Override
    public void onPartitionLost(IPartitionLostEvent partitionLostEvent) {
        this.partitionAwareService.onPartitionLost(partitionLostEvent);
    }

    @Override
    public Runnable prepareMergeRunnable() {
        return this.splitBrainHandlerService.prepareMergeRunnable();
    }

    @Override
    public <T extends TransactionalObject> T createTransactionalObject(String name, Transaction transaction) {
        return this.transactionalService.createTransactionalObject(name, transaction);
    }

    @Override
    public void rollbackTransaction(UUID transactionId) {
        this.transactionalService.rollbackTransaction(transactionId);
    }

    @Override
    public Map<String, LocalMapStats> getStats() {
        return this.statisticsAwareService.getStats();
    }

    @Override
    public String getSplitBrainProtectionName(String name) {
        return this.splitBrainProtectionAwareService.getSplitBrainProtectionName(name);
    }

    public MapServiceContext getMapServiceContext() {
        return this.mapServiceContext;
    }

    @Override
    public void clientDisconnected(UUID clientUuid) {
        this.clientAwareService.clientDisconnected(clientUuid);
    }

    public void onRegister(Object service, String serviceName, String mapName, EventRegistration registration) {
        EventFilter filter = registration.getFilter();
        if (!(filter instanceof EventListenerFilter) || !filter.eval(EntryEventType.INVALIDATION.getType())) {
            return;
        }
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        mapContainer.increaseInvalidationListenerCount();
    }

    public void onDeregister(Object service, String serviceName, String mapName, EventRegistration registration) {
        EventFilter filter = registration.getFilter();
        if (!(filter instanceof EventListenerFilter) || !filter.eval(EntryEventType.INVALIDATION.getType())) {
            return;
        }
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        mapContainer.decreaseInvalidationListenerCount();
    }

    public int getMigrationStamp() {
        return this.migrationAwareService.getMigrationStamp();
    }

    public boolean validateMigrationStamp(int stamp) {
        return this.migrationAwareService.validateMigrationStamp(stamp);
    }

    @Override
    public void onClusterStateChange(ClusterState newState) {
        this.mapServiceContext.onClusterStateChange(newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBeforeLock(String distributedObjectName, Data key) {
        IPartitionService partitionService = this.mapServiceContext.getNodeEngine().getPartitionService();
        int partitionId = partitionService.getPartitionId(key);
        RecordStore recordStore = this.mapServiceContext.getRecordStore(partitionId, distributedObjectName);
        if (recordStore.isTieredStorageEnabled()) {
            return;
        }
        boolean owner = partitionService.isPartitionOwner(partitionId);
        recordStore.beforeOperation();
        try {
            recordStore.getRecordOrNull(key, !owner);
        }
        finally {
            recordStore.afterOperation();
        }
    }

    public static ObjectNamespace getObjectNamespace(String mapName) {
        return new DistributedObjectNamespace(SERVICE_NAME, mapName);
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        Map<String, LocalMapStats> stats = this.getStats();
        if (stats == null) {
            return;
        }
        for (Map.Entry<String, LocalMapStats> entry : stats.entrySet()) {
            String mapName = entry.getKey();
            LocalMapStats localInstanceStats = entry.getValue();
            MetricDescriptor dsDescriptor = descriptor.copy().withPrefix("map").withDiscriminator("name", mapName);
            context.collect(dsDescriptor, localInstanceStats);
            Map<String, LocalIndexStats> indexStats = localInstanceStats.getIndexStats();
            for (Map.Entry<String, LocalIndexStats> indexEntry : indexStats.entrySet()) {
                MetricDescriptor indexDescriptor = descriptor.copy().withPrefix("map.index").withDiscriminator("name", mapName).withTag("index", indexEntry.getKey());
                context.collect(indexDescriptor, indexEntry.getValue());
            }
            NearCacheStats nearCacheStats = localInstanceStats.getNearCacheStats();
            if (nearCacheStats == null) continue;
            MetricDescriptor nearCacheDescriptor = descriptor.copy().withPrefix("map.nearcache").withDiscriminator("name", mapName);
            context.collect(nearCacheDescriptor, nearCacheStats);
        }
        ExecutorStats executorStats = this.mapServiceContext.getOffloadedEntryProcessorExecutorStats();
        executorStats.getStatsMap().forEach((name, offloadedExecutorStats) -> {
            MetricDescriptor nearCacheDescriptor = descriptor.copy().withPrefix("map.entry.processor.offloadable.executor").withDiscriminator("name", (String)name);
            context.collect(nearCacheDescriptor, offloadedExecutorStats);
        });
        this.setMapStoreOffloadedOperationMetrics(descriptor, context);
    }

    private void setMapStoreOffloadedOperationMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        PartitionContainer[] partitionContainers = this.mapServiceContext.getPartitionContainers();
        HashMap<String, MutableLong> offloaded = new HashMap<String, MutableLong>();
        for (PartitionContainer partitionContainer : partitionContainers) {
            Collection<RecordStore> allRecordStores = partitionContainer.getAllRecordStores();
            for (RecordStore recordStore : allRecordStores) {
                if (!recordStore.getMapContainer().getMapConfig().isStatisticsEnabled()) continue;
                MutableLong count = offloaded.computeIfAbsent(recordStore.getName(), s -> new MutableLong());
                count.addAndGet(recordStore.getMapStoreOffloadedOperationsCount());
            }
        }
        for (Map.Entry entry : offloaded.entrySet()) {
            String mapName = (String)entry.getKey();
            MutableLong count = (MutableLong)entry.getValue();
            MetricDescriptor descriptorOffloaded = descriptor.copy().withMetric("waitingToBeProcessedCount").withPrefix("map.store.offloaded.operations").withDiscriminator("name", mapName);
            context.collect(descriptorOffloaded, count.value);
        }
    }

    @Override
    public boolean shouldOffload() {
        return this.migrationAwareService.shouldOffload();
    }

    @Override
    public ChunkSupplier newChunkSupplier(PartitionReplicationEvent event, Collection<ServiceNamespace> namespace) {
        return this.migrationAwareService.newChunkSupplier(event, namespace);
    }

    public static String lookupNamespace(@Nonnull NodeEngine engine, @Nonnull String mapName) {
        if (engine.getNamespaceService().isEnabled()) {
            MapService mapService = (MapService)engine.getService(SERVICE_NAME);
            MapContainer container = mapService.getMapServiceContext().getExistingMapContainer(mapName);
            if (container != null) {
                return container.getMapConfig().getUserCodeNamespace();
            }
            MapConfig mapConfig = engine.getConfig().getMapConfigOrNull(mapName);
            if (mapConfig != null) {
                return mapConfig.getUserCodeNamespace();
            }
        }
        return null;
    }

    public static boolean isNamespaceReferencedWithHotRestart(@Nonnull NodeEngine engine, @Nonnull String namespace) {
        return engine.getConfig().getMapConfigs().values().stream().filter(cacheConfig -> cacheConfig.getDataPersistenceConfig().isEnabled()).map(MapConfig::getUserCodeNamespace).anyMatch(namespace::equals);
    }
}

