/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class PhoneHomeParameterCreator {
    private final StringBuilder builder;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private boolean hasParameterBefore;

    public PhoneHomeParameterCreator() {
        this.builder = new StringBuilder();
    }

    Map<String, String> getParameters() {
        return this.parameters;
    }

    public void addParam(String key, String value) {
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Parameter " + key + " is already added");
        }
        if (this.hasParameterBefore) {
            this.builder.append("&");
        } else {
            this.hasParameterBefore = true;
        }
        this.builder.append(key).append("=").append(URLEncoder.encode(value, StandardCharsets.UTF_8));
        this.parameters.put(key, value);
    }

    String build() {
        return this.builder.toString();
    }
}

