/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.function;

import com.hazelcast.function.FunctionsImpl;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.security.impl.function.SecuredFunction;
import java.io.Serializable;
import java.util.function.Function;

@FunctionalInterface
public interface FunctionEx<T, R>
extends Function<T, R>,
Serializable,
SecuredFunction {
    public R applyEx(T var1) throws Exception;

    @Override
    default public R apply(T t) {
        try {
            return this.applyEx(t);
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    public static <T> FunctionEx<T, T> identity() {
        return Util.Identity.INSTANCE;
    }

    public static <V, R> FunctionEx<V, R> unchecked(FunctionEx<V, R> function) {
        return function::apply;
    }

    @Override
    default public <V> FunctionEx<V, R> compose(FunctionEx<? super V, ? extends T> before) {
        return new FunctionsImpl.ComposedFunctionEx(before, this);
    }

    @Override
    default public <V> FunctionEx<T, V> andThen(FunctionEx<? super R, ? extends V> after) {
        return new FunctionsImpl.ComposedFunctionEx(this, after);
    }
}

