/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.impl.dto;

import com.hazelcast.cp.internal.raft.impl.RaftDataSerializerHook;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.cp.internal.raft.impl.log.LogEntry;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;

public class AppendRequest
implements IdentifiedDataSerializable {
    private RaftEndpoint leader;
    private int term;
    private int prevLogTerm;
    private long prevLogIndex;
    private long leaderCommitIndex;
    private LogEntry[] entries;
    private long queryRound;
    private long flowControlSequenceNumber;

    public AppendRequest() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public AppendRequest(RaftEndpoint leader, int term, int prevLogTerm, long prevLogIndex, long leaderCommitIndex, LogEntry[] entries, long queryRound, long flowControlSequenceNumber) {
        this.leader = leader;
        this.term = term;
        this.prevLogTerm = prevLogTerm;
        this.prevLogIndex = prevLogIndex;
        this.leaderCommitIndex = leaderCommitIndex;
        this.entries = entries;
        this.queryRound = queryRound;
        this.flowControlSequenceNumber = flowControlSequenceNumber;
    }

    public RaftEndpoint leader() {
        return this.leader;
    }

    public int term() {
        return this.term;
    }

    public int prevLogTerm() {
        return this.prevLogTerm;
    }

    public long prevLogIndex() {
        return this.prevLogIndex;
    }

    public long leaderCommitIndex() {
        return this.leaderCommitIndex;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public LogEntry[] entries() {
        return this.entries;
    }

    public int entryCount() {
        return this.entries.length;
    }

    public long queryRound() {
        return this.queryRound;
    }

    public long flowControlSequenceNumber() {
        return this.flowControlSequenceNumber;
    }

    @Override
    public int getFactoryId() {
        return RaftDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.term);
        out.writeObject(this.leader);
        out.writeInt(this.prevLogTerm);
        out.writeLong(this.prevLogIndex);
        out.writeLong(this.leaderCommitIndex);
        out.writeInt(this.entries.length);
        for (LogEntry entry : this.entries) {
            out.writeObject(entry);
        }
        out.writeLong(this.queryRound);
        out.writeLong(this.flowControlSequenceNumber);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.term = in.readInt();
        this.leader = (RaftEndpoint)in.readObject();
        this.prevLogTerm = in.readInt();
        this.prevLogIndex = in.readLong();
        this.leaderCommitIndex = in.readLong();
        int len = in.readInt();
        this.entries = new LogEntry[len];
        for (int i = 0; i < len; ++i) {
            this.entries[i] = (LogEntry)in.readObject();
        }
        this.queryRound = in.readLong();
        try {
            this.flowControlSequenceNumber = in.readLong();
        }
        catch (EOFException e) {
            this.flowControlSequenceNumber = -1L;
        }
    }

    public String toString() {
        return "AppendRequest{leader=" + this.leader + ", term=" + this.term + ", prevLogTerm=" + this.prevLogTerm + ", prevLogIndex=" + this.prevLogIndex + ", leaderCommitIndex=" + this.leaderCommitIndex + ", queryRound=" + this.queryRound + ", flowControlSequenceNumber=" + this.flowControlSequenceNumber + ", entries=" + Arrays.toString(this.entries) + "}";
    }
}

