/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.client;

import com.hazelcast.client.impl.ClientEndpoint;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CPSubsystemAddGroupAvailabilityListenerCodec;
import com.hazelcast.client.impl.protocol.task.AbstractAsyncMessageTask;
import com.hazelcast.cp.event.CPGroupAvailabilityEvent;
import com.hazelcast.cp.event.CPGroupAvailabilityListener;
import com.hazelcast.cp.event.impl.CPGroupAvailabilityEventImpl;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.spi.impl.eventservice.EventRegistration;
import com.hazelcast.spi.impl.eventservice.EventService;
import java.security.Permission;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class AddCPGroupAvailabilityListenerMessageTask
extends AbstractAsyncMessageTask<Boolean, UUID> {
    private static final String TOPIC = "availability";

    public AddCPGroupAvailabilityListenerMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected CompletableFuture<UUID> processInternal() {
        EventService eventService = this.clientEngine.getEventService();
        ClientCPGroupAvailabilityListener listener = new ClientCPGroupAvailabilityListener(this.endpoint);
        return eventService.registerListenerAsync(this.getServiceName(), TOPIC, listener).thenApplyAsync(EventRegistration::getId, ConcurrencyUtil.CALLER_RUNS);
    }

    @Override
    protected Object processResponseBeforeSending(UUID registrationId) {
        this.endpoint.addListenerDestroyAction(this.getServiceName(), TOPIC, registrationId);
        return registrationId;
    }

    @Override
    protected Boolean decodeClientMessage(ClientMessage clientMessage) {
        return CPSubsystemAddGroupAvailabilityListenerCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return CPSubsystemAddGroupAvailabilityListenerCodec.encodeResponse((UUID)response);
    }

    @Override
    public String getServiceName() {
        return "hz:core:raft";
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "addCPGroupAvailabilityListener";
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    private class ClientCPGroupAvailabilityListener
    implements CPGroupAvailabilityListener {
        private final ClientEndpoint endpoint;

        ClientCPGroupAvailabilityListener(ClientEndpoint endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public void availabilityDecreased(CPGroupAvailabilityEvent event) {
            if (!this.endpoint.isAlive()) {
                return;
            }
            boolean isShutdown = ((CPGroupAvailabilityEventImpl)event).isShutdown();
            ClientMessage message = CPSubsystemAddGroupAvailabilityListenerCodec.encodeGroupAvailabilityEventEvent((RaftGroupId)event.getGroupId(), event.getGroupMembers(), event.getUnavailableMembers(), isShutdown);
            AddCPGroupAvailabilityListenerMessageTask.this.sendClientMessage(message);
        }

        @Override
        public void majorityLost(CPGroupAvailabilityEvent event) {
            if (!this.endpoint.isAlive()) {
                return;
            }
            boolean isShutdown = ((CPGroupAvailabilityEventImpl)event).isShutdown();
            ClientMessage message = CPSubsystemAddGroupAvailabilityListenerCodec.encodeGroupAvailabilityEventEvent((RaftGroupId)event.getGroupId(), event.getGroupMembers(), event.getUnavailableMembers(), isShutdown);
            AddCPGroupAvailabilityListenerMessageTask.this.sendClientMessage(message);
        }
    }
}

