/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.management;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MCAddWanBatchPublisherConfigCodec;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.config.ConsistencyCheckStrategy;
import com.hazelcast.config.WanAcknowledgeType;
import com.hazelcast.config.WanBatchPublisherConfig;
import com.hazelcast.config.WanQueueFullBehavior;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanSyncConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.security.permission.ManagementPermission;
import com.hazelcast.wan.impl.AddWanConfigResult;
import java.security.Permission;

public class AddWanBatchPublisherConfigMessageTask
extends AbstractCallableMessageTask<MCAddWanBatchPublisherConfigCodec.RequestParameters> {
    private static final Permission REQUIRED_PERMISSION = new ManagementPermission("wan.addBatchPublisherConfig");

    public AddWanBatchPublisherConfigMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() throws Exception {
        WanReplicationConfig wanConfig = new WanReplicationConfig();
        wanConfig.setName(((MCAddWanBatchPublisherConfigCodec.RequestParameters)this.parameters).name);
        WanBatchPublisherConfig publisherConfig = new WanBatchPublisherConfig();
        publisherConfig.setPublisherId(((MCAddWanBatchPublisherConfigCodec.RequestParameters)this.parameters).publisherId);
        publisherConfig.setClusterName(((MCAddWanBatchPublisherConfigCodec.RequestParameters)this.parameters).targetCluster);
        publisherConfig.setTargetEndpoints(((MCAddWanBatchPublisherConfigCodec.RequestParameters)this.parameters).endpoints);
        publisherConfig.setQueueCapacity(((MCAddWanBatchPublisherConfigCodec.RequestParameters)this.parameters).queueCapacity);
        publisherConfig.setBatchSize(((MCAddWanBatchPublisherConfigCodec.RequestParameters)this.parameters).batchSize);
        publisherConfig.setBatchMaxDelayMillis(((MCAddWanBatchPublisherConfigCodec.RequestParameters)this.parameters).batchMaxDelayMillis);
        publisherConfig.setResponseTimeoutMillis(((MCAddWanBatchPublisherConfigCodec.RequestParameters)this.parameters).responseTimeoutMillis);
        WanAcknowledgeType ackType = WanAcknowledgeType.getById(((MCAddWanBatchPublisherConfigCodec.RequestParameters)this.parameters).ackType);
        publisherConfig.setAcknowledgeType(ackType != null ? ackType : WanBatchPublisherConfig.DEFAULT_ACKNOWLEDGE_TYPE);
        WanQueueFullBehavior queueFullBehavior = WanQueueFullBehavior.getByType(((MCAddWanBatchPublisherConfigCodec.RequestParameters)this.parameters).queueFullBehavior);
        publisherConfig.setQueueFullBehavior(queueFullBehavior != null ? queueFullBehavior : WanBatchPublisherConfig.DEFAULT_QUEUE_FULL_BEHAVIOUR);
        if (((MCAddWanBatchPublisherConfigCodec.RequestParameters)this.parameters).isConsistencyCheckStrategyExists) {
            WanSyncConfig syncConfig = new WanSyncConfig();
            syncConfig.setConsistencyCheckStrategy(ConsistencyCheckStrategy.getById(((MCAddWanBatchPublisherConfigCodec.RequestParameters)this.parameters).consistencyCheckStrategy));
            publisherConfig.setSyncConfig(syncConfig);
        }
        wanConfig.addBatchReplicationPublisherConfig(publisherConfig);
        return this.nodeEngine.getWanReplicationService().addWanReplicationConfig(wanConfig);
    }

    @Override
    protected MCAddWanBatchPublisherConfigCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MCAddWanBatchPublisherConfigCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        AddWanConfigResult result = (AddWanConfigResult)response;
        return MCAddWanBatchPublisherConfigCodec.encodeResponse(result.getAddedPublisherIds(), result.getIgnoredPublisherIds());
    }

    @Override
    public String getServiceName() {
        return "hz:core:wanReplicationService";
    }

    @Override
    public Permission getRequiredPermission() {
        return REQUIRED_PERMISSION;
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "addWanBatchPublisherConfig";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((MCAddWanBatchPublisherConfigCodec.RequestParameters)this.parameters).name, ((MCAddWanBatchPublisherConfigCodec.RequestParameters)this.parameters).targetCluster, ((MCAddWanBatchPublisherConfigCodec.RequestParameters)this.parameters).publisherId, ((MCAddWanBatchPublisherConfigCodec.RequestParameters)this.parameters).endpoints, ((MCAddWanBatchPublisherConfigCodec.RequestParameters)this.parameters).queueCapacity, ((MCAddWanBatchPublisherConfigCodec.RequestParameters)this.parameters).batchSize, ((MCAddWanBatchPublisherConfigCodec.RequestParameters)this.parameters).batchMaxDelayMillis, ((MCAddWanBatchPublisherConfigCodec.RequestParameters)this.parameters).responseTimeoutMillis, ((MCAddWanBatchPublisherConfigCodec.RequestParameters)this.parameters).ackType, ((MCAddWanBatchPublisherConfigCodec.RequestParameters)this.parameters).queueFullBehavior};
    }

    @Override
    public boolean isManagementTask() {
        return true;
    }
}

