/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.dynamicconfig;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractMessageTask;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.ListenerConfigHolder;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.security.permission.ConfigPermission;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public abstract class AbstractUpdateConfigMessageTask<P>
extends AbstractMessageTask<P>
implements BiConsumer<Object, Throwable> {
    private static final ConfigPermission CONFIG_PERMISSION = new ConfigPermission();

    protected AbstractUpdateConfigMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    public String getServiceName() {
        return "hz:configurationService";
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public Permission getRequiredPermission() {
        return CONFIG_PERMISSION;
    }

    @Override
    public Object[] getParameters() {
        return new Object[0];
    }

    @Override
    public void accept(Object response, Throwable throwable) {
        if (throwable == null) {
            this.sendResponse(response);
        } else {
            this.handleProcessingFailure(throwable);
        }
    }

    protected MergePolicyConfig mergePolicyConfig(String mergePolicy, int batchSize) {
        return new MergePolicyConfig(mergePolicy, batchSize);
    }

    protected List<? extends ListenerConfig> adaptListenerConfigs(List<ListenerConfigHolder> listenerConfigHolders, String namespace) {
        if (listenerConfigHolders == null || listenerConfigHolders.isEmpty()) {
            return null;
        }
        return listenerConfigHolders.stream().map(listenerConfigHolder -> listenerConfigHolder.asListenerConfig(this.serializationService, namespace)).collect(Collectors.toCollection(ArrayList::new));
    }

    protected abstract IdentifiedDataSerializable getConfig();
}

