/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.instance.BuildInfo;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.logging.AbstractLogger;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LogEvent;
import com.hazelcast.logging.LogListener;
import com.hazelcast.logging.Logger;
import com.hazelcast.logging.LoggerFactory;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.logging.impl.InternalLoggerFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import javax.annotation.Nonnull;

public class ClientLoggingService
implements LoggingService {
    private final ConcurrentMap<String, ILogger> mapLoggers = new ConcurrentHashMap<String, ILogger>(100);
    private final ConstructorFunction<String, ILogger> loggerConstructor = x$0 -> new DefaultLogger((String)x$0);
    private final LoggerFactory loggerFactory;
    private final BuildInfo buildInfo;
    private final String instanceName;
    private final boolean detailsEnabled;
    private final boolean shouldShutdownLoggingOnHazelcastShutdown;
    private volatile String versionMessage;

    public ClientLoggingService(String clusterName, String loggingType, BuildInfo buildInfo, String instanceName, boolean detailsEnabled, boolean shutdownLoggingEnabled) {
        this.loggerFactory = Logger.newLoggerFactory(loggingType);
        this.buildInfo = buildInfo;
        this.instanceName = instanceName;
        this.detailsEnabled = detailsEnabled;
        this.shouldShutdownLoggingOnHazelcastShutdown = shutdownLoggingEnabled;
        this.updateClusterName(clusterName);
    }

    public void updateClusterName(String clusterName) {
        this.versionMessage = this.instanceName + " [" + clusterName + "] [" + this.buildInfo.getVersion() + "] ";
    }

    @Override
    public void addLogListener(@Nonnull Level level, @Nonnull LogListener logListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeLogListener(@Nonnull LogListener logListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public ILogger getLogger(@Nonnull String name) {
        Preconditions.checkNotNull(name, "name must not be null");
        return ConcurrencyUtil.getOrPutIfAbsent(this.mapLoggers, name, this.loggerConstructor);
    }

    @Override
    @Nonnull
    public ILogger getLogger(@Nonnull Class clazz) {
        Preconditions.checkNotNull(clazz, "class must not be null");
        return ConcurrencyUtil.getOrPutIfAbsent(this.mapLoggers, clazz.getName(), this.loggerConstructor);
    }

    @Override
    public void shutdown() {
        if (this.shouldShutdownLoggingOnHazelcastShutdown && this.loggerFactory instanceof InternalLoggerFactory) {
            ((InternalLoggerFactory)((Object)this.loggerFactory)).shutdown();
        }
    }

    private class DefaultLogger
    extends AbstractLogger {
        final String name;
        final ILogger logger;

        DefaultLogger(String name) {
            this.name = name;
            this.logger = ClientLoggingService.this.loggerFactory.getLogger(name);
        }

        @Override
        public void log(Level level, String message) {
            this.log(level, message, null);
        }

        @Override
        public void log(Level level, String message, Throwable thrown) {
            if (this.logger.isLoggable(level)) {
                String logMessage = ClientLoggingService.this.detailsEnabled ? ClientLoggingService.this.versionMessage + message : message;
                this.logger.log(level, logMessage, thrown);
            }
        }

        @Override
        public void log(LogEvent logEvent) {
        }

        @Override
        public Level getLevel() {
            return this.logger.getLevel();
        }

        @Override
        public boolean isLoggable(Level level) {
            return this.logger.isLoggable(level);
        }
    }
}

