/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.HazelcastCacheManager;
import com.hazelcast.cache.impl.CacheClearResponse;
import com.hazelcast.cache.impl.CacheOperationProvider;
import com.hazelcast.cache.impl.CacheProxyLoadAllTask;
import com.hazelcast.cache.impl.CacheProxySyncListenerCompleter;
import com.hazelcast.cache.impl.CacheProxyUtil;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.CacheSyncListenerCompleter;
import com.hazelcast.cache.impl.HazelcastServerCacheManager;
import com.hazelcast.cache.impl.ICacheInternal;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cache.impl.event.CachePartitionLostEventFilter;
import com.hazelcast.cache.impl.event.CachePartitionLostListener;
import com.hazelcast.cache.impl.event.InternalCachePartitionLostListenerAdapter;
import com.hazelcast.cache.impl.operation.CacheListenerRegistrationOperation;
import com.hazelcast.cache.impl.operation.MutableOperation;
import com.hazelcast.cluster.Member;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.CachePartitionLostListenerConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.FutureUtil;
import com.hazelcast.internal.util.SetUtil;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.internal.util.executor.CompletableFutureTask;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.AbstractDistributedObject;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.tenantcontrol.DestroyEventContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;

abstract class CacheProxySupport<K, V>
extends AbstractDistributedObject<ICacheService>
implements ICacheInternal<K, V>,
CacheSyncListenerCompleter {
    private static final int TIMEOUT = 10;
    protected final ILogger logger;
    protected CacheConfig<K, V> cacheConfig;
    protected final String name;
    protected final String nameWithPrefix;
    protected final ICacheService cacheService;
    protected final SerializationService serializationService;
    protected final CacheOperationProvider operationProvider;
    protected final IPartitionService partitionService;
    private final CopyOnWriteArrayList<Future> loadAllTasks = new CopyOnWriteArrayList();
    private final AtomicReference<HazelcastServerCacheManager> cacheManagerRef = new AtomicReference();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final AtomicBoolean isDestroyed = new AtomicBoolean(false);
    private final CacheProxySyncListenerCompleter listenerCompleter = new CacheProxySyncListenerCompleter(this);

    CacheProxySupport(CacheConfig<K, V> cacheConfig, NodeEngine nodeEngine, ICacheService cacheService) {
        super(nodeEngine, cacheService);
        this.name = cacheConfig.getName();
        this.nameWithPrefix = cacheConfig.getNameWithPrefix();
        this.cacheConfig = cacheConfig;
        this.logger = nodeEngine.getLogger(this.getClass());
        this.partitionService = nodeEngine.getPartitionService();
        this.cacheService = cacheService;
        this.serializationService = nodeEngine.getSerializationService();
        this.operationProvider = cacheService.getCacheOperationProvider(this.nameWithPrefix, cacheConfig.getInMemoryFormat());
        List<CachePartitionLostListenerConfig> configs = cacheConfig.getPartitionLostListenerConfigs();
        for (CachePartitionLostListenerConfig listenerConfig : configs) {
            CachePartitionLostListener listener = (CachePartitionLostListener)this.initializeListener(listenerConfig);
            if (listener == null) continue;
            CachePartitionLostEventFilter filter = new CachePartitionLostEventFilter();
            InternalCachePartitionLostListenerAdapter listenerAdapter = new InternalCachePartitionLostListenerAdapter(listener);
            ((ICacheService)this.getService()).getNodeEngine().getEventService().registerListener("hz:impl:cacheService", this.name, filter, listenerAdapter);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected String getDistributedObjectName() {
        return this.nameWithPrefix;
    }

    @Override
    public String getPrefixedName() {
        return this.nameWithPrefix;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public void open() {
        if (this.isDestroyed.get()) {
            throw new IllegalStateException("Cache is already destroyed! Cannot be reopened");
        }
        this.isClosed.compareAndSet(true, false);
    }

    public void close() {
        this.close0(false);
    }

    @Override
    @Nonnull
    public DestroyEventContext getDestroyContextForTenant() {
        return () -> {
            this.cacheConfig = ((CacheService)this.cacheService).reSerializeCacheConfig(this.cacheConfig);
        };
    }

    @Override
    protected boolean preDestroy() {
        this.close0(true);
        if (!this.isDestroyed.compareAndSet(false, true)) {
            return false;
        }
        this.isClosed.set(true);
        return true;
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public boolean isDestroyed() {
        return this.isDestroyed.get();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheProxySupport that = (CacheProxySupport)o;
        return !(this.nameWithPrefix != null ? !this.nameWithPrefix.equals(that.nameWithPrefix) : that.nameWithPrefix != null);
    }

    @Override
    public int hashCode() {
        return this.nameWithPrefix != null ? this.nameWithPrefix.hashCode() : 0;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "{name=" + this.name + ", nameWithPrefix=" + this.nameWithPrefix + "}";
    }

    public CacheManager getCacheManager() {
        return this.cacheManagerRef.get();
    }

    @Override
    public void setCacheManager(HazelcastCacheManager cacheManager) {
        assert (cacheManager instanceof HazelcastServerCacheManager);
        if (this.cacheManagerRef.get() == cacheManager) {
            return;
        }
        if (!this.cacheManagerRef.compareAndSet(null, (HazelcastServerCacheManager)cacheManager)) {
            if (this.cacheManagerRef.get() == cacheManager) {
                return;
            }
            throw new IllegalStateException("Cannot overwrite a Cache's CacheManager.");
        }
    }

    @Override
    public void resetCacheManager() {
        this.cacheManagerRef.set(null);
    }

    @Override
    protected void postDestroy() {
        CacheManager cacheManager = this.cacheManagerRef.get();
        if (cacheManager != null) {
            cacheManager.destroyCache(this.getName());
        }
        this.resetCacheManager();
    }

    @Override
    public void countDownCompletionLatch(int countDownLatchId) {
        this.listenerCompleter.countDownCompletionLatch(countDownLatchId);
    }

    protected void ensureOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("Cache operations can not be performed. The cache closed");
        }
    }

    protected void createAndSubmitLoadAllTask(Set<Data> keysData, boolean replaceExistingValues, CompletionListener completionListener) {
        try {
            CacheProxyLoadAllTask loadAllTask = new CacheProxyLoadAllTask(this.getNodeEngine(), this.operationProvider, keysData, replaceExistingValues, completionListener, this.getServiceName());
            ExecutionService executionService = this.getNodeEngine().getExecutionService();
            CompletableFutureTask future = (CompletableFutureTask)executionService.submit("loadAll-" + this.nameWithPrefix, loadAllTask);
            this.loadAllTasks.add(future);
            future.whenCompleteAsync((response, t) -> {
                this.loadAllTasks.remove(future);
                if (t != null) {
                    this.logger.warning("Problem in loadAll task", (Throwable)t);
                }
            }, ConcurrencyUtil.CALLER_RUNS);
        }
        catch (Exception e) {
            if (completionListener != null) {
                completionListener.onException(e);
            }
            throw new CacheException((Throwable)e);
        }
    }

    protected <T> T injectDependencies(Object obj) {
        ManagedContext managedContext = this.serializationService.getManagedContext();
        return (T)managedContext.initialize(obj);
    }

    protected <T> InvocationFuture<T> invoke(Operation op, Data keyData, boolean completionOperation) {
        int partitionId = this.getPartitionId(keyData);
        return this.invoke(op, partitionId, completionOperation);
    }

    protected <T> InvocationFuture<T> removeAsyncInternal(K key, V oldValue, boolean hasOldValue, boolean isGet, boolean withCompletionEvent) {
        this.ensureOpen();
        if (hasOldValue) {
            CacheProxyUtil.validateNotNull(key, oldValue);
            CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key, oldValue);
        } else {
            CacheProxyUtil.validateNotNull(key);
            CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key);
        }
        Object keyData = this.serializationService.toData(key);
        Object valueData = this.serializationService.toData(oldValue);
        Operation operation = isGet ? this.operationProvider.createGetAndRemoveOperation((Data)keyData, -1) : this.operationProvider.createRemoveOperation((Data)keyData, (Data)valueData, -1);
        return this.invoke(operation, (Data)keyData, withCompletionEvent);
    }

    protected <T> InvocationFuture<T> replaceAsyncInternal(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy, boolean hasOldValue, boolean isGet, boolean withCompletionEvent) {
        this.ensureOpen();
        if (hasOldValue) {
            CacheProxyUtil.validateNotNull(key, oldValue, newValue);
            CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key, oldValue, newValue);
        } else {
            CacheProxyUtil.validateNotNull(key, newValue);
            CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key, newValue);
        }
        Object keyData = this.serializationService.toData(key);
        Object oldValueData = this.serializationService.toData(oldValue);
        Object newValueData = this.serializationService.toData(newValue);
        Operation operation = isGet ? this.operationProvider.createGetAndReplaceOperation((Data)keyData, (Data)newValueData, expiryPolicy, -1) : this.operationProvider.createReplaceOperation((Data)keyData, (Data)oldValueData, (Data)newValueData, expiryPolicy, -1);
        return this.invoke(operation, (Data)keyData, withCompletionEvent);
    }

    protected <T> InvocationFuture<T> putAsyncInternal(K key, V value, ExpiryPolicy expiryPolicy, boolean isGet, boolean withCompletionEvent) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key, value);
        CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key, value);
        Object keyData = this.serializationService.toData(key);
        Object valueData = this.serializationService.toData(value);
        Operation op = this.operationProvider.createPutOperation((Data)keyData, (Data)valueData, expiryPolicy, isGet, -1);
        return this.invoke(op, (Data)keyData, withCompletionEvent);
    }

    protected InvocationFuture<Boolean> putIfAbsentAsyncInternal(K key, V value, ExpiryPolicy expiryPolicy, boolean withCompletionEvent) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key, value);
        CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key, value);
        Object keyData = this.serializationService.toData(key);
        Object valueData = this.serializationService.toData(value);
        Operation operation = this.operationProvider.createPutIfAbsentOperation((Data)keyData, (Data)valueData, expiryPolicy, -1);
        return this.invoke(operation, (Data)keyData, withCompletionEvent);
    }

    protected void clearInternal() {
        try {
            OperationService operationService = this.getNodeEngine().getOperationService();
            OperationFactory operationFactory = this.operationProvider.createClearOperationFactory();
            Map<Integer, Object> results = operationService.invokeOnAllPartitions(this.getServiceName(), operationFactory);
            for (Object result : results.values()) {
                Object response;
                if (result == null || !(result instanceof CacheClearResponse) || !((response = ((CacheClearResponse)result).getResponse()) instanceof Throwable)) continue;
                throw (Throwable)response;
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(t, CacheException.class);
        }
    }

    protected void removeAllInternal(Set<? extends K> keys) {
        Set<Data> keysData = null;
        if (keys != null) {
            keysData = SetUtil.createHashSet(keys.size());
            for (K key : keys) {
                CacheProxyUtil.validateNotNull(key);
                keysData.add((Data)this.serializationService.toData(key));
            }
        }
        int partitionCount = this.getNodeEngine().getPartitionService().getPartitionCount();
        Integer completionId = this.listenerCompleter.registerCompletionLatch(partitionCount);
        OperationService operationService = this.getNodeEngine().getOperationService();
        OperationFactory operationFactory = this.operationProvider.createRemoveAllOperationFactory(keysData, completionId);
        try {
            Map<Integer, Object> results = operationService.invokeOnAllPartitions(this.getServiceName(), operationFactory);
            int completionCount = 0;
            for (Object result : results.values()) {
                if (result == null || !(result instanceof CacheClearResponse)) continue;
                Object response = ((CacheClearResponse)result).getResponse();
                if (response instanceof Boolean) {
                    ++completionCount;
                }
                if (!(response instanceof Throwable)) continue;
                throw (Throwable)response;
            }
            this.listenerCompleter.waitCompletionLatch(completionId, partitionCount - completionCount);
        }
        catch (Throwable t) {
            this.listenerCompleter.deregisterCompletionLatch(completionId);
            throw ExceptionUtil.rethrowAllowedTypeFirst(t, CacheException.class);
        }
    }

    protected void addListenerLocally(UUID regId, CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.listenerCompleter.putListenerIfAbsent(cacheEntryListenerConfiguration, regId);
    }

    protected void removeListenerLocally(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.listenerCompleter.removeListener(cacheEntryListenerConfiguration);
    }

    protected UUID getListenerIdLocal(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        return this.listenerCompleter.getListenerId(cacheEntryListenerConfiguration);
    }

    protected <T> T invokeInternal(Data keyData, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        Integer completionId = this.listenerCompleter.registerCompletionLatch(1);
        Operation op = this.operationProvider.createEntryProcessorOperation(keyData, completionId, entryProcessor, arguments);
        try {
            OperationService operationService = this.getNodeEngine().getOperationService();
            int partitionId = this.getPartitionId(keyData);
            InvocationFuture future = operationService.invokeOnPartition(this.getServiceName(), op, partitionId);
            Object safely = future.joinInternal();
            this.listenerCompleter.waitCompletionLatch(completionId);
            return (T)safely;
        }
        catch (CacheException ce) {
            this.listenerCompleter.deregisterCompletionLatch(completionId);
            throw ce;
        }
        catch (Exception e) {
            this.listenerCompleter.deregisterCompletionLatch(completionId);
            throw new EntryProcessorException((Throwable)e);
        }
    }

    protected void updateCacheListenerConfigOnOtherNodes(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration, boolean isRegister) {
        OperationService operationService = this.getNodeEngine().getOperationService();
        Set<Member> members = this.getNodeEngine().getClusterService().getMembers();
        for (Member member : members) {
            if (member.localMember()) continue;
            CacheListenerRegistrationOperation op = new CacheListenerRegistrationOperation(this.getDistributedObjectName(), cacheEntryListenerConfiguration, isRegister);
            operationService.invokeOnTarget("hz:impl:cacheService", op, member.getAddress());
        }
    }

    protected List<Data>[] groupDataToPartitions(Collection<? extends K> keys, int partitionCount) {
        ArrayList[] keysPerPartition = new ArrayList[partitionCount];
        for (K key : keys) {
            CacheProxyUtil.validateNotNull(key);
            Object dataKey = this.serializationService.toData(key);
            int partitionId = this.partitionService.getPartitionId((Data)dataKey);
            ArrayList partition = keysPerPartition[partitionId];
            if (partition == null) {
                keysPerPartition[partitionId] = partition = new ArrayList();
            }
            partition.add(dataKey);
        }
        return keysPerPartition;
    }

    protected void putToAllPartitionsAndWaitForCompletion(List<Map.Entry<Data, Data>>[] entriesPerPartition, ExpiryPolicy expiryPolicy) throws Exception {
        ArrayList futures = new ArrayList(entriesPerPartition.length);
        for (int partitionId = 0; partitionId < entriesPerPartition.length; ++partitionId) {
            List<Map.Entry<Data, Data>> entries = entriesPerPartition[partitionId];
            if (entries == null) continue;
            Operation operation = this.operationProvider.createPutAllOperation(entries, expiryPolicy, partitionId);
            InvocationFuture future = this.invoke(operation, partitionId, true);
            futures.add(future);
        }
        Throwable error = null;
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Throwable t) {
                this.logger.finest("Error occurred while putting entries as batch!", t);
                if (error != null) continue;
                error = t;
            }
        }
        if (error != null) {
            throw ExceptionUtil.rethrow(error);
        }
    }

    protected void setTTLAllPartitionsAndWaitForCompletion(List<Data>[] keysPerPartition, Data expiryPolicy) {
        ArrayList futures = new ArrayList(keysPerPartition.length);
        for (int partitionId = 0; partitionId < keysPerPartition.length; ++partitionId) {
            List<Data> keys = keysPerPartition[partitionId];
            if (keys == null) continue;
            Operation operation = this.operationProvider.createSetExpiryPolicyOperation(keys, expiryPolicy);
            futures.add(this.invoke(operation, partitionId, true));
        }
        List<Throwable> throwables = FutureUtil.waitUntilAllResponded(futures);
        if (!throwables.isEmpty()) {
            throw ExceptionUtil.rethrow(throwables.get(0));
        }
    }

    protected PartitionIdSet getPartitionsForKeys(Set<Data> keys) {
        IPartitionService partitionService = this.getNodeEngine().getPartitionService();
        int partitions = partitionService.getPartitionCount();
        PartitionIdSet partitionIds = new PartitionIdSet(partitions);
        Iterator<Data> iterator = keys.iterator();
        int addedPartitions = 0;
        while (iterator.hasNext() && addedPartitions < partitions) {
            Data key = iterator.next();
            if (!partitionIds.add(partitionService.getPartitionId(key))) continue;
            ++addedPartitions;
        }
        return partitionIds;
    }

    private void deregisterAllCacheEntryListener(Collection<UUID> listenerRegistrations) {
        ICacheService service = (ICacheService)this.getService();
        for (UUID regId : listenerRegistrations) {
            service.deregisterListener(this.nameWithPrefix, regId);
        }
    }

    private <T extends EventListener> T initializeListener(ListenerConfig listenerConfig) {
        EventListener listener = null;
        if (listenerConfig.getImplementation() != null) {
            listener = listenerConfig.getImplementation();
        } else if (listenerConfig.getClassName() != null) {
            try {
                ClassLoader loader = NamespaceUtil.getClassLoaderForNamespace(this.getNodeEngine(), this.cacheConfig.getUserCodeNamespace());
                listener = (EventListener)ClassLoaderUtil.newInstance(loader, listenerConfig.getClassName());
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        listener = (EventListener)this.injectDependencies(listener);
        return (T)listener;
    }

    private void close0(boolean destroy) {
        if (!this.isClosed.compareAndSet(false, true)) {
            return;
        }
        Exception caughtException = null;
        for (Future f : this.loadAllTasks) {
            try {
                f.get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                if (caughtException == null) {
                    caughtException = e;
                }
                this.getNodeEngine().getLogger(this.getClass()).warning("Problem while waiting for loadAll tasks to complete", e);
            }
        }
        this.loadAllTasks.clear();
        this.closeListeners();
        if (!destroy) {
            this.resetCacheManager();
        }
        if (caughtException != null) {
            throw new CacheException("Problem while waiting for loadAll tasks to complete", (Throwable)caughtException);
        }
    }

    private void closeListeners() {
        this.deregisterAllCacheEntryListener(this.listenerCompleter.getListenersIds(true));
        this.deregisterAllCacheEntryListener(this.listenerCompleter.getListenersIds(false));
        this.listenerCompleter.clearListeners();
    }

    private <T> InvocationFuture<T> invoke(Operation op, int partitionId, boolean completionOperation) {
        Integer completionId = null;
        if (completionOperation) {
            completionId = this.listenerCompleter.registerCompletionLatch(1);
            if (op instanceof MutableOperation) {
                ((MutableOperation)((Object)op)).setCompletionId(completionId);
            }
        }
        try {
            InvocationFuture future = this.getNodeEngine().getOperationService().invokeOnPartition(this.getServiceName(), op, partitionId);
            if (completionOperation) {
                this.listenerCompleter.waitCompletionLatch(completionId);
            }
            InvocationFuture invocationFuture = future;
            return invocationFuture;
        }
        catch (Throwable e) {
            if (e instanceof IllegalStateException) {
                this.close();
            }
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
        finally {
            if (completionOperation) {
                this.listenerCompleter.deregisterCompletionLatch(completionId);
            }
        }
    }
}

