/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.client;

import com.hazelcast.client.config.ClientSqlResubmissionMode;
import com.hazelcast.client.impl.ClientDelegatingFuture;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.ClientConnection;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.SqlCloseCodec;
import com.hazelcast.client.impl.protocol.codec.SqlExecuteCodec;
import com.hazelcast.client.impl.protocol.codec.SqlFetchCodec;
import com.hazelcast.client.impl.protocol.codec.SqlMappingDdlCodec;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.properties.ClientProperty;
import com.hazelcast.cluster.Member;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.impl.util.LoggingUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.CoreQueryUtils;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.client.ReadOptimizedLruCache;
import com.hazelcast.sql.impl.client.SqlClientResult;
import com.hazelcast.sql.impl.client.SqlError;
import com.hazelcast.sql.impl.client.SqlResubmissionResult;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class SqlClientService
implements SqlService {
    private static final int MAX_FAST_INVOCATION_COUNT = 5;
    public final ReadOptimizedLruCache<String, Integer> partitionArgumentIndexCache;
    private final HazelcastClientInstanceImpl client;
    private final ILogger logger;
    private final boolean skipUpdateStatistics;
    private final long resubmissionTimeoutNano;
    private final long resubmissionRetryPauseMillis;
    private final boolean isSmartRouting;

    public SqlClientService(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.logger = client.getLoggingService().getLogger(this.getClass());
        this.skipUpdateStatistics = this.skipUpdateStatistics();
        long resubmissionTimeoutMillis = client.getProperties().getPositiveMillisOrDefault(ClientProperty.INVOCATION_TIMEOUT_SECONDS);
        this.resubmissionTimeoutNano = TimeUnit.MILLISECONDS.toNanos(resubmissionTimeoutMillis);
        this.resubmissionRetryPauseMillis = client.getProperties().getPositiveMillisOrDefault(ClientProperty.INVOCATION_RETRY_PAUSE_MILLIS);
        this.isSmartRouting = !client.getConnectionManager().isUnisocketClient();
        int partitionArgCacheSize = client.getProperties().getInteger(ClientProperty.PARTITION_ARGUMENT_CACHE_SIZE);
        int partitionArgCacheThreshold = partitionArgCacheSize + Math.min(partitionArgCacheSize / 10, 50);
        this.partitionArgumentIndexCache = new ReadOptimizedLruCache(partitionArgCacheSize, partitionArgCacheThreshold);
    }

    @Override
    @Nonnull
    public SqlResult execute(@Nonnull SqlStatement statement) {
        Integer argIndex = statement.getPartitionArgumentIndex() != -1 ? Integer.valueOf(statement.getPartitionArgumentIndex()) : this.partitionArgumentIndexCache.getOrDefault(statement.getSql(), -1);
        Integer partitionId = this.extractPartitionId(statement, argIndex);
        ClientConnection connection = partitionId != null ? this.getQueryConnection(partitionId) : this.getQueryConnection();
        QueryId id = QueryId.create(connection.getRemoteUuid());
        List<Object> params = statement.getParameters();
        ArrayList<Data> params0 = new ArrayList<Data>(params.size());
        for (Object param : params) {
            params0.add(this.serializeParameter(param));
        }
        Function<QueryId, ClientMessage> requestMessageSupplier = queryId -> SqlExecuteCodec.encodeRequest(statement.getSql(), params0, statement.getTimeoutMillis(), statement.getCursorBufferSize(), statement.getSchema(), statement.getExpectedResultType().getId(), queryId, this.skipUpdateStatistics);
        ClientMessage requestMessage = requestMessageSupplier.apply(id);
        SqlClientResult res = new SqlClientResult(this, connection, id, statement.getCursorBufferSize(), requestMessageSupplier, statement);
        try {
            ClientMessage message = this.invoke(requestMessage, connection);
            this.handleExecuteResponse(statement, argIndex, res, message);
            return res;
        }
        catch (Exception e) {
            RuntimeException error = this.rethrow(e, connection);
            SqlResubmissionResult resubmissionResult = this.resubmitIfPossible(res, error);
            if (resubmissionResult == null) {
                throw error;
            }
            res.onResubmissionResponse(resubmissionResult);
            return res;
        }
    }

    SqlResubmissionResult resubmitIfPossible(SqlClientResult result, RuntimeException error) {
        if (!this.shouldResubmit(error) || !this.shouldResubmit(result)) {
            return null;
        }
        SqlResubmissionResult resubmissionResult = this.resubmitIfPossible0(result, error);
        if (resubmissionResult.getSqlError() != null) {
            SqlError sqlError = resubmissionResult.getSqlError();
            throw new HazelcastSqlException(sqlError.getOriginatingMemberId(), sqlError.getCode(), sqlError.getMessage(), null, sqlError.getSuggestion());
        }
        return resubmissionResult;
    }

    private SqlResubmissionResult resubmitIfPossible0(SqlClientResult result, RuntimeException error) {
        long resubmissionStartTime = System.nanoTime();
        int invokeCount = 0;
        SqlResubmissionResult resubmissionResult = null;
        do {
            block8: {
                ClientConnection connection = null;
                try {
                    connection = this.getQueryConnection();
                    QueryId queryId = QueryId.create(connection.getRemoteUuid());
                    LoggingUtil.logFinest(this.logger, "Resubmitting query: %s with new query id %s", result.getQueryId(), queryId);
                    result.setQueryId(queryId);
                    ClientMessage message = this.invoke(result.getSqlExecuteMessage(queryId), connection);
                    resubmissionResult = this.createResubmissionResult(message, connection);
                    if (resubmissionResult.getSqlError() == null) {
                        LoggingUtil.logFinest(this.logger, "Resubmitting query: %s ended without error", result.getQueryId());
                    } else {
                        LoggingUtil.logFinest(this.logger, "Resubmitting query: %s ended with error", result.getQueryId());
                    }
                    if (resubmissionResult.getSqlError() == null || !this.shouldResubmit(resubmissionResult.getSqlError())) {
                        return resubmissionResult;
                    }
                }
                catch (Exception e) {
                    RuntimeException rethrown;
                    LoggingUtil.logFinest(this.logger, "Resubmitting query: %s ended with exception", result.getQueryId());
                    RuntimeException runtimeException = rethrown = connection == null ? (RuntimeException)e : this.rethrow(e, connection);
                    if (this.shouldResubmit(rethrown)) break block8;
                    throw rethrown;
                }
            }
            if (invokeCount++ < 5) continue;
            long delayMillis = Math.min(1L << Math.min(62, invokeCount - 5), this.resubmissionRetryPauseMillis);
            try {
                Thread.sleep(delayMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return this.returnNonNullOrThrow(resubmissionResult, error, true);
            }
        } while (System.nanoTime() - resubmissionStartTime <= this.resubmissionTimeoutNano);
        this.logger.finest("Resubmitting query timed out");
        return this.returnNonNullOrThrow(resubmissionResult, error, false);
    }

    private SqlResubmissionResult returnNonNullOrThrow(SqlResubmissionResult result, RuntimeException originalError, boolean wasInterrupted) {
        if (result == null) {
            if (wasInterrupted) {
                throw new HazelcastException("Query resubmission was interrupted", originalError);
            }
            throw new OperationTimeoutException("Query resubmission timed out", originalError);
        }
        return result;
    }

    private boolean shouldResubmit(Exception error) {
        return error instanceof HazelcastSqlException && this.shouldResubmit(((HazelcastSqlException)error).getCode());
    }

    private boolean shouldResubmit(SqlError error) {
        return this.shouldResubmit(error.getCode());
    }

    private boolean shouldResubmit(int errorCode) {
        return errorCode == 1001 || errorCode == 1005 || errorCode == 1011 || errorCode == 1012;
    }

    private boolean shouldResubmit(SqlClientResult result) {
        ClientSqlResubmissionMode resubmissionMode = this.client.getClientConfig().getSqlConfig().getResubmissionMode();
        switch (resubmissionMode) {
            case NEVER: {
                return false;
            }
            case RETRY_SELECTS: {
                return result.isSelectQuery() && !result.isReturnedAnyResult();
            }
            case RETRY_SELECTS_ALLOW_DUPLICATES: {
                return result.isSelectQuery();
            }
            case RETRY_ALL: {
                return true;
            }
        }
        throw new IllegalStateException("Unknown resubmission mode: " + (Object)((Object)resubmissionMode));
    }

    private boolean skipUpdateStatistics() {
        String connectionType = this.client.getConnectionManager().getConnectionType();
        return connectionType.equals("MCJVM");
    }

    private SqlResubmissionResult createResubmissionResult(ClientMessage message, ClientConnection connection) {
        SqlExecuteCodec.ResponseParameters response = SqlExecuteCodec.decodeResponse(message);
        SqlError sqlError = response.error;
        if (sqlError != null) {
            return new SqlResubmissionResult(sqlError);
        }
        SqlRowMetadata rowMetadata = response.rowMetadata != null ? new SqlRowMetadata(response.rowMetadata) : null;
        return new SqlResubmissionResult(connection, rowMetadata, response.rowPage, response.updateCount);
    }

    private void handleExecuteResponse(SqlStatement statement, int originalPartitionArgumentIndex, SqlClientResult res, ClientMessage message) {
        SqlExecuteCodec.ResponseParameters response = SqlExecuteCodec.decodeResponse(message);
        SqlError sqlError = response.error;
        if (sqlError != null) {
            throw new HazelcastSqlException(sqlError.getOriginatingMemberId(), sqlError.getCode(), sqlError.getMessage(), null, sqlError.getSuggestion());
        }
        if (this.isSmartRouting && response.partitionArgumentIndex != originalPartitionArgumentIndex) {
            if (response.partitionArgumentIndex != -1) {
                this.partitionArgumentIndexCache.put(statement.getSql(), response.partitionArgumentIndex);
                statement.setPartitionArgumentIndex(response.partitionArgumentIndex);
            } else {
                this.partitionArgumentIndexCache.remove(statement.getSql());
            }
        }
        res.onExecuteResponse(response.rowMetadata != null ? new SqlRowMetadata(response.rowMetadata) : null, response.rowPage, response.updateCount, response.isIsInfiniteRowsExists ? Boolean.valueOf(response.isInfiniteRows) : null);
    }

    public void fetchAsync(ClientConnection connection, QueryId queryId, int cursorBufferSize, SqlClientResult res) {
        ClientMessage requestMessage = SqlFetchCodec.encodeRequest(queryId, cursorBufferSize);
        ClientInvocationFuture future = this.invokeAsync(requestMessage, connection);
        future.whenCompleteAsync(ExceptionUtil.withTryCatch(this.logger, (message, error) -> this.handleFetchResponse(connection, res, (ClientMessage)message, (Throwable)error)), ConcurrencyUtil.CALLER_RUNS);
    }

    private void handleFetchResponse(ClientConnection connection, SqlClientResult res, ClientMessage message, Throwable error) {
        if (error != null) {
            res.onFetchFinished(null, this.rethrow(error, connection));
            return;
        }
        SqlFetchCodec.ResponseParameters responseParameters = SqlFetchCodec.decodeResponse(message);
        HazelcastSqlException responseError = SqlClientService.handleResponseError(responseParameters.error);
        if (responseError != null) {
            res.onFetchFinished(null, responseError);
            return;
        }
        assert (responseParameters.rowPage != null);
        res.onFetchFinished(responseParameters.rowPage, null);
    }

    void close(ClientConnection connection, QueryId queryId) {
        try {
            ClientMessage requestMessage = SqlCloseCodec.encodeRequest(queryId);
            this.invoke(requestMessage, connection);
        }
        catch (Exception e) {
            throw this.rethrow(e, connection);
        }
    }

    public ClientConnection getQueryConnection() {
        try {
            ClientConnection connection = this.client.getConnectionManager().getConnectionForSql();
            if (connection == null) {
                throw this.rethrow(QueryException.error(1001, "Client is not connected"));
            }
            return connection;
        }
        catch (Exception e) {
            throw this.rethrow(e);
        }
    }

    public ClientConnection getQueryConnection(int partitionId) {
        try {
            UUID nodeId = this.client.getClientPartitionService().getPartitionOwner(partitionId);
            if (nodeId == null) {
                return this.getQueryConnection();
            }
            ClientConnection connection = this.client.getConnectionManager().getConnection(nodeId);
            if (connection == null) {
                return this.getQueryConnection();
            }
            return connection;
        }
        catch (Exception e) {
            throw this.rethrow(e);
        }
    }

    public ClientMessage invokeOnConnection(ClientConnection connection, ClientMessage request) {
        try {
            return this.invoke(request, connection);
        }
        catch (Exception e) {
            throw this.rethrow(e);
        }
    }

    private Data serializeParameter(Object parameter) {
        try {
            return this.getSerializationService().toData(parameter);
        }
        catch (Exception e) {
            throw this.rethrow(QueryException.error("Failed to serialize query parameter " + parameter + ": " + e.getMessage()));
        }
    }

    public UUID getClientId() {
        return this.client.getLocalEndpoint().getUuid();
    }

    InternalSerializationService getSerializationService() {
        return this.client.getSerializationService();
    }

    private ClientInvocationFuture invokeAsync(ClientMessage request, ClientConnection connection) {
        ClientInvocation invocation = new ClientInvocation(this.client, request, null, connection);
        return invocation.invoke();
    }

    private ClientMessage invoke(ClientMessage request, ClientConnection connection) throws Exception {
        ClientInvocationFuture fut = this.invokeAsync(request, connection);
        return (ClientMessage)fut.get();
    }

    private Integer extractPartitionId(SqlStatement statement, int argIndex) {
        if (!this.isSmartRouting) {
            return null;
        }
        if (statement.getParameters().size() == 0) {
            return null;
        }
        if (argIndex >= statement.getParameters().size() || argIndex < 0) {
            return null;
        }
        Object key = statement.getParameters().get(argIndex);
        if (key == null) {
            return null;
        }
        return this.client.getClientPartitionService().getPartitionId(key);
    }

    private static HazelcastSqlException handleResponseError(SqlError error) {
        if (error != null) {
            return new HazelcastSqlException(error.getOriginatingMemberId(), error.getCode(), error.getMessage(), null, error.getSuggestion());
        }
        return null;
    }

    private RuntimeException rethrow(Throwable cause, ClientConnection connection) {
        if (!connection.isAlive()) {
            return CoreQueryUtils.toPublicException(QueryException.memberConnection(connection.getRemoteAddress()), this.getClientId());
        }
        return this.rethrow(cause);
    }

    RuntimeException rethrow(Throwable cause) {
        if (cause.getCause() instanceof AccessControlException) {
            return (AccessControlException)cause.getCause();
        }
        return CoreQueryUtils.toPublicException(cause, this.getClientId());
    }

    @Nonnull
    public CompletableFuture<String> mappingDdl(Member member, String mapName) {
        Preconditions.checkNotNull(mapName);
        ClientInvocation invocation = new ClientInvocation(this.client, SqlMappingDdlCodec.encodeRequest(mapName), null, member.getUuid());
        return new ClientDelegatingFuture<String>(invocation.invoke(), this.client.getSerializationService(), SqlMappingDdlCodec::decodeResponse);
    }
}

