/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal;

import com.hazelcast.cp.CPGroup;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.internal.RaftServiceDataSerializerHook;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class CPGroupSummary
implements CPGroup,
IdentifiedDataSerializable {
    private CPGroupId id;
    private CPGroup.CPGroupStatus status;
    private Set<RaftEndpoint> initialMembers;
    private Set<CPMember> members;

    public CPGroupSummary() {
    }

    public CPGroupSummary(CPGroupId id, CPGroup.CPGroupStatus status, Collection<RaftEndpoint> initialMembers, Collection<CPMember> members) {
        this.id = id;
        this.status = status;
        this.initialMembers = Collections.unmodifiableSet(new LinkedHashSet<RaftEndpoint>(initialMembers));
        this.members = Collections.unmodifiableSet(new LinkedHashSet<CPMember>(members));
    }

    @Override
    public CPGroupId id() {
        return this.id;
    }

    @Override
    public CPGroup.CPGroupStatus status() {
        return this.status;
    }

    public Collection<RaftEndpoint> initialMembers() {
        return this.initialMembers;
    }

    @Override
    public Collection<CPMember> members() {
        return this.members;
    }

    @Override
    public int getFactoryId() {
        return RaftServiceDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 47;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.id);
        out.writeInt(this.initialMembers.size());
        for (RaftEndpoint raftEndpoint : this.initialMembers) {
            out.writeObject(raftEndpoint);
        }
        out.writeInt(this.members.size());
        for (CPMember cPMember : this.members) {
            out.writeObject(cPMember);
        }
        out.writeString(this.status.toString());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.id = (CPGroupId)in.readObject();
        int initialMemberCount = in.readInt();
        LinkedHashSet<RaftEndpoint> initialMembers = new LinkedHashSet<RaftEndpoint>();
        for (int i = 0; i < initialMemberCount; ++i) {
            RaftEndpoint member = (RaftEndpoint)in.readObject();
            initialMembers.add(member);
        }
        this.initialMembers = Collections.unmodifiableSet(initialMembers);
        int memberCount = in.readInt();
        this.members = new LinkedHashSet<CPMember>(memberCount);
        for (int i = 0; i < memberCount; ++i) {
            CPMember member = (CPMember)in.readObject();
            this.members.add(member);
        }
        this.members = Collections.unmodifiableSet(this.members);
        this.status = CPGroup.CPGroupStatus.valueOf(in.readString());
    }

    public String toString() {
        return "CPGroup{id=" + this.id + ", status=" + (Object)((Object)this.status) + ", initialMembers=" + this.initialMembers + ", members=" + this.members + '}';
    }
}

