/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.impl.AbstractCacheIterator;
import com.hazelcast.cache.impl.ICacheInternal;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheIterateCodec;
import com.hazelcast.client.impl.protocol.codec.CacheIterateEntriesCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.ExceptionUtil;
import java.util.Iterator;
import java.util.List;
import javax.cache.Cache;

public class ClientCacheIterator<K, V>
extends AbstractCacheIterator<K, V>
implements Iterator<Cache.Entry<K, V>> {
    private ICacheInternal<K, V> cacheProxy;
    private ClientContext context;

    public ClientCacheIterator(ICacheInternal<K, V> cacheProxy, ClientContext context, boolean prefetchValues) {
        this(cacheProxy, context, 100, prefetchValues);
    }

    public ClientCacheIterator(ICacheInternal<K, V> cacheProxy, ClientContext context, int fetchSize, boolean prefetchValues) {
        super(cacheProxy, context.getPartitionService().getPartitionCount(), fetchSize, prefetchValues);
        this.cacheProxy = cacheProxy;
        this.context = context;
        this.advance();
    }

    public ClientCacheIterator(ICacheInternal<K, V> cacheProxy, ClientContext context, int fetchSize, int partitionId, boolean prefetchValues) {
        super(cacheProxy, context.getPartitionService().getPartitionCount(), fetchSize, prefetchValues);
        this.cacheProxy = cacheProxy;
        this.context = context;
        this.partitionIndex = partitionId;
        this.advance();
    }

    @Override
    protected List fetch() {
        HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.context.getHazelcastInstance();
        String name = this.cacheProxy.getPrefixedName();
        if (this.prefetchValues) {
            ClientMessage request = CacheIterateEntriesCodec.encodeRequest(name, IterationPointer.encodePointers(this.pointers), this.fetchSize);
            try {
                ClientInvocation clientInvocation = new ClientInvocation(client, request, (Object)name, this.partitionIndex);
                ClientInvocationFuture future = clientInvocation.invoke();
                CacheIterateEntriesCodec.ResponseParameters responseParameters = CacheIterateEntriesCodec.decodeResponse((ClientMessage)future.get());
                IterationPointer[] pointers = IterationPointer.decodePointers(responseParameters.iterationPointers);
                this.setIterationPointers(responseParameters.entries, pointers);
                return responseParameters.entries;
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        ClientMessage request = CacheIterateCodec.encodeRequest(name, IterationPointer.encodePointers(this.pointers), this.fetchSize);
        try {
            ClientInvocation clientInvocation = new ClientInvocation(client, request, (Object)name, this.partitionIndex);
            ClientInvocationFuture future = clientInvocation.invoke();
            CacheIterateCodec.ResponseParameters responseParameters = CacheIterateCodec.decodeResponse((ClientMessage)future.get());
            IterationPointer[] pointers = IterationPointer.decodePointers(responseParameters.iterationPointers);
            this.setIterationPointers(responseParameters.keys, pointers);
            return responseParameters.keys;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    protected Data toData(Object obj) {
        return this.context.getSerializationService().toData(obj);
    }

    @Override
    protected <T> T toObject(Object data) {
        return this.context.getSerializationService().toObject(data);
    }
}

