/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.IndexConfig;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapMergeRunnable;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.recordstore.DefaultRecordStore;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.spi.impl.merge.AbstractSplitBrainHandlerService;
import com.hazelcast.spi.merge.DiscardMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

class MapSplitBrainHandlerService
extends AbstractSplitBrainHandlerService<RecordStore> {
    private final MapServiceContext mapServiceContext;

    MapSplitBrainHandlerService(MapServiceContext mapServiceContext) {
        super(mapServiceContext.getNodeEngine());
        this.mapServiceContext = mapServiceContext;
    }

    @Override
    protected Runnable newMergeRunnable(Collection<RecordStore> mergingStores) {
        return new MapMergeRunnable(mergingStores, this, this.mapServiceContext);
    }

    @Override
    protected Iterator<RecordStore> storeIterator(int partitionId) {
        PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(partitionId);
        Collection<RecordStore> recordStores = partitionContainer.getAllRecordStores();
        return recordStores.iterator();
    }

    @Override
    protected void onStoreCollection(RecordStore recordStore) {
        ThreadUtil.assertRunningOnPartitionThread();
        DefaultRecordStore defaultRecordStore = (DefaultRecordStore)recordStore;
        defaultRecordStore.getMapDataStore().reset();
        defaultRecordStore.getIndexingObserver().onDestroy(false, true);
        PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(recordStore.getPartitionId());
        MapContainer mapContainer = recordStore.getMapContainer();
        if (partitionContainer.destroyMapContainer(mapContainer) && mapContainer.shouldUseGlobalIndex()) {
            this.addIndexConfigToNewMapContainer(mapContainer.name, -1, mapContainer.getIndexes());
        }
        if (!mapContainer.shouldUseGlobalIndex()) {
            Indexes indexes = (Indexes)partitionContainer.getIndexes().remove(mapContainer.name);
            this.addIndexConfigToNewMapContainer(mapContainer.name, recordStore.getPartitionId(), indexes);
        }
    }

    private void addIndexConfigToNewMapContainer(String mapName, int partitionId, Indexes indexes) {
        if (indexes == null) {
            return;
        }
        LinkedList<IndexConfig> indexConfigs = new LinkedList<IndexConfig>();
        InternalIndex[] internalIndexes = indexes.getIndexes();
        for (int i = 0; i < internalIndexes.length; ++i) {
            indexConfigs.add(internalIndexes[i].getConfig());
        }
        MapContainer newMapContainer = this.mapServiceContext.getMapContainer(mapName);
        for (IndexConfig indexConfig : indexConfigs) {
            newMapContainer.getIndexes(partitionId).addOrGetIndex(indexConfig);
        }
    }

    @Override
    protected void destroyStore(RecordStore store) {
        ThreadUtil.assertRunningOnPartitionThread();
        ((DefaultRecordStore)store).destroyStorageAfterClear(false, true);
    }

    @Override
    protected boolean hasEntries(RecordStore store) {
        ThreadUtil.assertRunningOnPartitionThread();
        return !store.isEmpty();
    }

    @Override
    protected boolean hasMergeablePolicy(RecordStore store) {
        String policy = store.getMapContainer().getMapConfig().getMergePolicyConfig().getPolicy();
        SplitBrainMergePolicy mergePolicy = this.mapServiceContext.getNodeEngine().getSplitBrainMergePolicyProvider().getMergePolicy(policy);
        return !(mergePolicy instanceof DiscardMergePolicy);
    }
}

