/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.PartitioningStrategyConfig;
import com.hazelcast.internal.eviction.ExpirationManager;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.ContextMutexFactory;
import com.hazelcast.internal.util.InvocationUtil;
import com.hazelcast.internal.util.LocalRetryableExecution;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.SetUtil;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.internal.util.comparators.ValueComparator;
import com.hazelcast.internal.util.comparators.ValueComparatorUtil;
import com.hazelcast.internal.util.executor.ManagedExecutorService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.impl.EventListenerCounter;
import com.hazelcast.map.impl.EventListenerFilter;
import com.hazelcast.map.impl.ExecutorStats;
import com.hazelcast.map.impl.InterceptorRegistry;
import com.hazelcast.map.impl.InternalMapPartitionLostListenerAdapter;
import com.hazelcast.map.impl.ListenerAdapter;
import com.hazelcast.map.impl.ListenerAdapters;
import com.hazelcast.map.impl.LocalMapStatsProvider;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapKeyLoader;
import com.hazelcast.map.impl.MapListenerFlagOperator;
import com.hazelcast.map.impl.MapPartitionLostEventFilter;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.MapStoreWrapper;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.PartitioningStrategyFactory;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.event.MapEventPublisherImpl;
import com.hazelcast.map.impl.eviction.MapClearExpiredRecordsTask;
import com.hazelcast.map.impl.journal.MapEventJournal;
import com.hazelcast.map.impl.journal.RingbufferMapEventJournalImpl;
import com.hazelcast.map.impl.mapstore.MapDataStore;
import com.hazelcast.map.impl.mapstore.writebehind.NodeWideUsedCapacityCounter;
import com.hazelcast.map.impl.nearcache.MapNearCacheManager;
import com.hazelcast.map.impl.operation.MapOperationProvider;
import com.hazelcast.map.impl.operation.MapOperationProviders;
import com.hazelcast.map.impl.operation.MapPartitionDestroyOperation;
import com.hazelcast.map.impl.query.AccumulationExecutor;
import com.hazelcast.map.impl.query.AggregationResult;
import com.hazelcast.map.impl.query.AggregationResultProcessor;
import com.hazelcast.map.impl.query.CallerRunsAccumulationExecutor;
import com.hazelcast.map.impl.query.CallerRunsPartitionScanExecutor;
import com.hazelcast.map.impl.query.ParallelAccumulationExecutor;
import com.hazelcast.map.impl.query.ParallelPartitionScanExecutor;
import com.hazelcast.map.impl.query.PartitionScanExecutor;
import com.hazelcast.map.impl.query.PartitionScanRunner;
import com.hazelcast.map.impl.query.QueryEngine;
import com.hazelcast.map.impl.query.QueryEngineImpl;
import com.hazelcast.map.impl.query.QueryResult;
import com.hazelcast.map.impl.query.QueryResultProcessor;
import com.hazelcast.map.impl.query.QueryRunner;
import com.hazelcast.map.impl.query.ResultProcessorRegistry;
import com.hazelcast.map.impl.querycache.NodeQueryCacheContext;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.map.impl.recordstore.DefaultRecordStore;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.listener.MapPartitionLostListener;
import com.hazelcast.partition.PartitioningStrategy;
import com.hazelcast.query.impl.DefaultIndexProvider;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.IndexProvider;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.query.impl.predicates.QueryOptimizer;
import com.hazelcast.query.impl.predicates.QueryOptimizerFactory;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.eventservice.EventFilter;
import com.hazelcast.spi.impl.eventservice.EventRegistration;
import com.hazelcast.spi.impl.eventservice.EventService;
import com.hazelcast.spi.properties.ClusterProperty;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;

class MapServiceContextImpl
implements MapServiceContext {
    private static final long DESTROY_TIMEOUT_SECONDS = 30L;
    protected final ILogger logger;
    private final NodeEngine nodeEngine;
    private final QueryEngine queryEngine;
    private final EventService eventService;
    private final QueryRunner mapQueryRunner;
    private final MapEventJournal eventJournal;
    private final QueryOptimizer queryOptimizer;
    private final MapEventPublisher mapEventPublisher;
    private final QueryCacheContext queryCacheContext;
    private final ExpirationManager expirationManager;
    private final PartitionScanRunner partitionScanRunner;
    private final MapNearCacheManager mapNearCacheManager;
    private final MapOperationProviders operationProviders;
    private final PartitionContainer[] partitionContainers;
    private final LocalMapStatsProvider localMapStatsProvider;
    private final ResultProcessorRegistry resultProcessorRegistry;
    private final InternalSerializationService serializationService;
    private final MapClearExpiredRecordsTask clearExpiredRecordsTask;
    private final PartitioningStrategyFactory partitioningStrategyFactory;
    private final NodeWideUsedCapacityCounter nodeWideUsedCapacityCounter;
    private final ConstructorFunction<String, MapContainer> mapConstructor;
    private final IndexProvider indexProvider = new DefaultIndexProvider();
    private final ContextMutexFactory contextMutexFactory = new ContextMutexFactory();
    private final ConcurrentMap<String, MapContainer> mapContainers = new ConcurrentHashMap<String, MapContainer>();
    private final ExecutorStats offloadedExecutorStats = new ExecutorStats();
    private final EventListenerCounter eventListenerCounter = new EventListenerCounter();
    private final AtomicReference<PartitionIdSet> cachedOwnedPartitions = new AtomicReference();
    private final Semaphore nodeWideLoadedKeyLimiter;
    private MapService mapService;

    MapServiceContextImpl(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.serializationService = (InternalSerializationService)nodeEngine.getSerializationService();
        this.mapConstructor = this.createMapConstructor();
        this.queryCacheContext = new NodeQueryCacheContext(this);
        this.partitionContainers = this.createPartitionContainers();
        this.clearExpiredRecordsTask = new MapClearExpiredRecordsTask(this.partitionContainers, nodeEngine);
        this.expirationManager = new ExpirationManager(this.clearExpiredRecordsTask, nodeEngine);
        this.mapNearCacheManager = this.createMapNearCacheManager();
        this.localMapStatsProvider = this.createLocalMapStatsProvider();
        this.mapEventPublisher = this.createMapEventPublisherSupport();
        this.eventJournal = this.createEventJournal();
        this.queryOptimizer = QueryOptimizerFactory.newOptimizer(nodeEngine.getProperties());
        this.resultProcessorRegistry = this.createResultProcessorRegistry(this.serializationService);
        this.partitionScanRunner = this.createPartitionScanRunner();
        this.queryEngine = this.createMapQueryEngine();
        this.mapQueryRunner = this.createMapQueryRunner(nodeEngine, this.queryOptimizer, this.resultProcessorRegistry, this.partitionScanRunner);
        this.eventService = nodeEngine.getEventService();
        this.operationProviders = this.createOperationProviders();
        this.partitioningStrategyFactory = new PartitioningStrategyFactory(nodeEngine.getConfigClassLoader());
        this.nodeWideUsedCapacityCounter = new NodeWideUsedCapacityCounter(nodeEngine.getProperties());
        this.nodeWideLoadedKeyLimiter = new Semaphore(Preconditions.checkPositive("hazelcast.map.loaded.key.limit.per.node", nodeEngine.getProperties().getInteger(MapKeyLoader.LOADED_KEY_LIMITER_PER_NODE)));
        this.logger = nodeEngine.getLogger(this.getClass());
    }

    @Override
    public ExecutorStats getOffloadedEntryProcessorExecutorStats() {
        return this.offloadedExecutorStats;
    }

    private ConstructorFunction<String, MapContainer> createMapConstructor() {
        return mapName -> {
            MapContainer mapContainer = this.createMapContainer((String)mapName);
            mapContainer.init();
            return mapContainer;
        };
    }

    MapContainer createMapContainer(String mapName) {
        MapServiceContext mapServiceContext = this.getService().getMapServiceContext();
        return new MapContainer(mapName, this.nodeEngine.getConfig(), mapServiceContext);
    }

    MapNearCacheManager createMapNearCacheManager() {
        return new MapNearCacheManager(this);
    }

    MapOperationProviders createOperationProviders() {
        return new MapOperationProviders();
    }

    MapEventPublisherImpl createMapEventPublisherSupport() {
        return new MapEventPublisherImpl(this);
    }

    private MapEventJournal createEventJournal() {
        return new RingbufferMapEventJournalImpl(this.getNodeEngine(), this);
    }

    protected LocalMapStatsProvider createLocalMapStatsProvider() {
        return new LocalMapStatsProvider(this);
    }

    private QueryEngineImpl createMapQueryEngine() {
        return new QueryEngineImpl(this);
    }

    private PartitionScanRunner createPartitionScanRunner() {
        return new PartitionScanRunner(this);
    }

    protected QueryRunner createMapQueryRunner(NodeEngine nodeEngine, QueryOptimizer queryOptimizer, ResultProcessorRegistry resultProcessorRegistry, PartitionScanRunner partitionScanRunner) {
        PartitionScanExecutor partitionScanExecutor;
        boolean parallelEvaluation = nodeEngine.getProperties().getBoolean(ClusterProperty.QUERY_PREDICATE_PARALLEL_EVALUATION);
        if (parallelEvaluation) {
            int opTimeoutInMillis = nodeEngine.getProperties().getInteger(ClusterProperty.OPERATION_CALL_TIMEOUT_MILLIS);
            ManagedExecutorService queryExecutorService = nodeEngine.getExecutionService().getExecutor("hz:query");
            partitionScanExecutor = new ParallelPartitionScanExecutor(partitionScanRunner, queryExecutorService, opTimeoutInMillis);
        } else {
            partitionScanExecutor = new CallerRunsPartitionScanExecutor(partitionScanRunner);
        }
        return new QueryRunner(this, queryOptimizer, partitionScanExecutor, resultProcessorRegistry);
    }

    private ResultProcessorRegistry createResultProcessorRegistry(SerializationService ss) {
        ResultProcessorRegistry registry = new ResultProcessorRegistry();
        registry.registerProcessor(QueryResult.class, this.createQueryResultProcessor(ss));
        registry.registerProcessor(AggregationResult.class, this.createAggregationResultProcessor(ss));
        return registry;
    }

    private QueryResultProcessor createQueryResultProcessor(SerializationService ss) {
        return new QueryResultProcessor(ss);
    }

    private AggregationResultProcessor createAggregationResultProcessor(SerializationService ss) {
        AccumulationExecutor accumulationExecutor;
        boolean parallelAccumulation = this.nodeEngine.getProperties().getBoolean(ClusterProperty.AGGREGATION_ACCUMULATION_PARALLEL_EVALUATION);
        int opTimeoutInMillis = this.nodeEngine.getProperties().getInteger(ClusterProperty.OPERATION_CALL_TIMEOUT_MILLIS);
        if (parallelAccumulation) {
            ManagedExecutorService queryExecutorService = this.nodeEngine.getExecutionService().getExecutor("hz:query");
            accumulationExecutor = new ParallelAccumulationExecutor(queryExecutorService, ss, opTimeoutInMillis);
        } else {
            accumulationExecutor = new CallerRunsAccumulationExecutor(ss);
        }
        return new AggregationResultProcessor(accumulationExecutor, this.serializationService);
    }

    private PartitionContainer[] createPartitionContainers() {
        int partitionCount = this.nodeEngine.getPartitionService().getPartitionCount();
        return new PartitionContainer[partitionCount];
    }

    @Override
    public MapContainer getMapContainer(String mapName) {
        return ConcurrencyUtil.getOrPutSynchronized(this.mapContainers, mapName, this.contextMutexFactory, this.mapConstructor);
    }

    @Override
    public MapContainer getExistingMapContainer(String mapName) {
        return (MapContainer)this.mapContainers.get(mapName);
    }

    @Override
    public Map<String, MapContainer> getMapContainers() {
        return this.mapContainers;
    }

    @Override
    public PartitionContainer getPartitionContainer(int partitionId) {
        assert (partitionId != -1) : "Cannot be called with GENERIC_PARTITION_ID";
        return this.partitionContainers[partitionId];
    }

    @Override
    public void initPartitionsContainers() {
        int partitionCount = this.nodeEngine.getPartitionService().getPartitionCount();
        for (int i = 0; i < partitionCount; ++i) {
            this.partitionContainers[i] = this.createPartitionContainer(this.getService(), i);
        }
    }

    protected PartitionContainer createPartitionContainer(MapService service, int partitionId) {
        return new PartitionContainer(service, partitionId);
    }

    protected void removeAllRecordStoresOfAllMaps(boolean onShutdown, boolean onRecordStoreDestroy) {
        for (PartitionContainer partitionContainer : this.partitionContainers) {
            if (partitionContainer == null) continue;
            this.removeRecordStoresFromPartitionMatchingWith(recordStore -> true, partitionContainer.getPartitionId(), onShutdown, onRecordStoreDestroy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRecordStoresFromPartitionMatchingWith(Predicate<RecordStore> predicate, int partitionId, boolean onShutdown, boolean onRecordStoreDestroy) {
        PartitionContainer container = this.partitionContainers[partitionId];
        if (container == null) {
            return;
        }
        Iterator partitionIterator = container.getMaps().values().iterator();
        while (partitionIterator.hasNext()) {
            RecordStore partition = (RecordStore)partitionIterator.next();
            if (!predicate.test(partition)) continue;
            partition.beforeOperation();
            try {
                partition.clearPartition(onShutdown, onRecordStoreDestroy);
            }
            finally {
                partition.afterOperation();
            }
            partitionIterator.remove();
        }
    }

    @Override
    public void removeWbqCountersFromMatchingPartitionsWith(Predicate<RecordStore> predicate, int partitionId) {
        PartitionContainer container = this.partitionContainers[partitionId];
        if (container == null) {
            return;
        }
        for (RecordStore partition : container.getMaps().values()) {
            if (!predicate.test(partition)) continue;
            partition.getMapDataStore().getTxnReservedCapacityCounter().releaseAllReservations();
        }
    }

    @Override
    public MapService getService() {
        return this.mapService;
    }

    @Override
    public void setService(MapService mapService) {
        this.mapService = mapService;
    }

    @Override
    public void destroyMapStores() {
        for (MapContainer mapContainer : this.mapContainers.values()) {
            MapStoreWrapper store = mapContainer.getMapStoreContext().getMapStoreWrapper();
            if (store == null) continue;
            store.destroy();
        }
    }

    @Override
    public void flushMaps() {
        for (MapContainer mapContainer : this.mapContainers.values()) {
            mapContainer.getMapStoreContext().stop();
        }
        for (PartitionContainer partitionContainer : this.partitionContainers) {
            for (String mapName : this.mapContainers.keySet()) {
                RecordStore recordStore = partitionContainer.getExistingRecordStore(mapName);
                if (recordStore == null) continue;
                MapDataStore<Data, Object> mapDataStore = recordStore.getMapDataStore();
                mapDataStore.hardFlush();
            }
        }
    }

    @Override
    public void destroyMap(String mapName) {
        this.mapNearCacheManager.destroyNearCache(mapName);
        this.nodeEngine.getEventService().deregisterAllListeners("hz:impl:mapService", mapName);
        MapContainer mapContainer = (MapContainer)this.mapContainers.get(mapName);
        if (mapContainer == null) {
            return;
        }
        this.nodeEngine.getWanReplicationService().removeWanEventCounters("hz:impl:mapService", mapName);
        mapContainer.getMapStoreContext().stop();
        this.destroyPartitionsAndMapContainer(mapContainer);
        this.localMapStatsProvider.destroyLocalMapStatsImpl(mapContainer.getName());
        this.getEventListenerCounter().removeCounter(mapName, mapContainer.getInvalidationListenerCounter());
    }

    private void destroyPartitionsAndMapContainer(MapContainer mapContainer) {
        ArrayList<LocalRetryableExecution> executions = new ArrayList<LocalRetryableExecution>();
        for (PartitionContainer container : this.partitionContainers) {
            MapPartitionDestroyOperation op = new MapPartitionDestroyOperation(container, mapContainer);
            executions.add(InvocationUtil.executeLocallyWithRetry(this.nodeEngine, op));
        }
        for (LocalRetryableExecution execution : executions) {
            try {
                if (execution.awaitCompletion(30L, TimeUnit.SECONDS)) continue;
                this.logger.warning("Map partition was not destroyed in expected time, possible leak");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.nodeEngine.getLogger(this.getClass()).warning(e);
            }
        }
    }

    @Override
    public void reset() {
        this.removeAllRecordStoresOfAllMaps(false, false);
        this.mapNearCacheManager.reset();
        this.offloadedExecutorStats.clear();
    }

    @Override
    public void shutdown() {
        this.removeAllRecordStoresOfAllMaps(true, false);
        this.mapNearCacheManager.shutdown();
        this.mapContainers.clear();
        this.expirationManager.onShutdown();
        this.offloadedExecutorStats.clear();
    }

    @Override
    public RecordStore getRecordStore(int partitionId, String mapName) {
        return this.getPartitionContainer(partitionId).getRecordStore(mapName);
    }

    @Override
    public RecordStore getRecordStore(int partitionId, String mapName, boolean skipLoadingOnCreate) {
        return this.getPartitionContainer(partitionId).getRecordStore(mapName, skipLoadingOnCreate);
    }

    @Override
    public RecordStore getExistingRecordStore(int partitionId, String mapName) {
        return this.getPartitionContainer(partitionId).getExistingRecordStore(mapName);
    }

    @Override
    public PartitionIdSet getCachedOwnedPartitions() {
        PartitionIdSet ownedSet = this.cachedOwnedPartitions.get();
        if (ownedSet == null) {
            this.refreshCachedOwnedPartitions();
            ownedSet = this.cachedOwnedPartitions.get();
        }
        return ownedSet;
    }

    private PartitionIdSet getOwnedMemberPartitions() {
        IPartitionService partitionService = this.nodeEngine.getPartitionService();
        List<Integer> partitions = partitionService.getMemberPartitions(this.nodeEngine.getThisAddress());
        return SetUtil.immutablePartitionIdSet(partitionService.getPartitionCount(), partitions);
    }

    @Override
    public void refreshCachedOwnedPartitions() {
        PartitionIdSet newSet;
        PartitionIdSet expectedSet;
        while (!this.cachedOwnedPartitions.compareAndSet(expectedSet = this.cachedOwnedPartitions.get(), newSet = this.getOwnedMemberPartitions())) {
        }
    }

    @Override
    public ExpirationManager getExpirationManager() {
        return this.expirationManager;
    }

    @Override
    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    @Override
    public MapEventPublisher getMapEventPublisher() {
        return this.mapEventPublisher;
    }

    @Override
    public MapEventJournal getEventJournal() {
        return this.eventJournal;
    }

    @Override
    public QueryEngine getQueryEngine(String mapName) {
        return this.queryEngine;
    }

    @Override
    public QueryRunner getMapQueryRunner(String name) {
        return this.mapQueryRunner;
    }

    @Override
    public QueryOptimizer getQueryOptimizer() {
        return this.queryOptimizer;
    }

    @Override
    public LocalMapStatsProvider getLocalMapStatsProvider() {
        return this.localMapStatsProvider;
    }

    @Override
    public Object toObject(Object data) {
        return this.serializationService.toObject(data);
    }

    @Override
    public Data toData(Object object, PartitioningStrategy partitionStrategy) {
        return this.serializationService.toData(object, partitionStrategy);
    }

    @Override
    public Data toData(Object object) {
        return this.serializationService.toData(object, DataType.HEAP);
    }

    @Override
    public Data toDataWithSchema(Object object) {
        return this.serializationService.toDataWithSchema(object);
    }

    @Override
    public MapClearExpiredRecordsTask getClearExpiredRecordsTask() {
        return this.clearExpiredRecordsTask;
    }

    @Override
    public Object interceptGet(InterceptorRegistry interceptorRegistry, Object currentValue) {
        List<MapInterceptor> interceptors = interceptorRegistry.getInterceptors();
        if (interceptors.isEmpty()) {
            return currentValue;
        }
        Object result = this.toObject(currentValue);
        for (MapInterceptor interceptor : interceptors) {
            Object temp = interceptor.interceptGet(result);
            if (temp == null) continue;
            result = temp;
        }
        return result == null ? currentValue : result;
    }

    @Override
    public void interceptAfterGet(InterceptorRegistry interceptorRegistry, Object value) {
        List<MapInterceptor> interceptors = interceptorRegistry.getInterceptors();
        if (interceptors.isEmpty()) {
            return;
        }
        value = this.toObject(value);
        for (MapInterceptor interceptor : interceptors) {
            interceptor.afterGet(value);
        }
    }

    @Override
    public Object interceptPut(InterceptorRegistry interceptorRegistry, Object oldValue, Object newValue) {
        List<MapInterceptor> interceptors = interceptorRegistry.getInterceptors();
        if (interceptors.isEmpty()) {
            return newValue;
        }
        Object result = this.toObject(newValue);
        oldValue = this.toObject(oldValue);
        for (MapInterceptor interceptor : interceptors) {
            Object temp = interceptor.interceptPut(oldValue, result);
            if (temp == null) continue;
            result = temp;
        }
        return result;
    }

    @Override
    public void interceptAfterPut(InterceptorRegistry interceptorRegistry, Object newValue) {
        List<MapInterceptor> interceptors = interceptorRegistry.getInterceptors();
        if (interceptors.isEmpty()) {
            return;
        }
        newValue = this.toObject(newValue);
        for (MapInterceptor interceptor : interceptors) {
            interceptor.afterPut(newValue);
        }
    }

    @Override
    public Object interceptRemove(InterceptorRegistry interceptorRegistry, Object value) {
        List<MapInterceptor> interceptors = interceptorRegistry.getInterceptors();
        if (interceptors.isEmpty()) {
            return value;
        }
        Object result = this.toObject(value);
        for (MapInterceptor interceptor : interceptors) {
            Object temp = interceptor.interceptRemove(result);
            if (temp == null) continue;
            result = temp;
        }
        return result;
    }

    @Override
    public void interceptAfterRemove(InterceptorRegistry interceptorRegistry, Object value) {
        List<MapInterceptor> interceptors = interceptorRegistry.getInterceptors();
        if (interceptors.isEmpty()) {
            return;
        }
        value = this.toObject(value);
        for (MapInterceptor interceptor : interceptors) {
            interceptor.afterRemove(value);
        }
    }

    @Override
    public void addInterceptor(String id, String mapName, MapInterceptor interceptor) {
        MapContainer mapContainer = this.getMapContainer(mapName);
        mapContainer.getInterceptorRegistry().register(id, interceptor);
    }

    @Override
    public boolean removeInterceptor(String mapName, String id) {
        MapContainer mapContainer = this.getMapContainer(mapName);
        return mapContainer.getInterceptorRegistry().deregister(id);
    }

    @Override
    public String generateInterceptorId(String mapName, MapInterceptor interceptor) {
        return interceptor.getClass().getName() + interceptor.hashCode();
    }

    @Override
    public UUID addLocalEventListener(Object listener, EventFilter eventFilter, String mapName) {
        EventRegistration registration = this.addListenerInternal(listener, eventFilter, mapName, true);
        return registration.getId();
    }

    @Override
    public UUID addLocalPartitionLostListener(MapPartitionLostListener listener, String mapName) {
        InternalMapPartitionLostListenerAdapter listenerAdapter = new InternalMapPartitionLostListenerAdapter(listener);
        MapPartitionLostEventFilter filter = new MapPartitionLostEventFilter();
        EventRegistration registration = this.eventService.registerLocalListener("hz:impl:mapService", mapName, filter, listenerAdapter);
        return registration.getId();
    }

    @Override
    public UUID addEventListener(Object listener, EventFilter eventFilter, String mapName) {
        EventRegistration registration = this.addListenerInternal(listener, eventFilter, mapName, false);
        return registration.getId();
    }

    @Override
    public CompletableFuture<UUID> addEventListenerAsync(Object mapListener, EventFilter eventFilter, String mapName) {
        return this.addListenerInternalAsync(mapListener, eventFilter, mapName);
    }

    @Override
    public UUID addPartitionLostListener(MapPartitionLostListener listener, String mapName) {
        InternalMapPartitionLostListenerAdapter listenerAdapter = new InternalMapPartitionLostListenerAdapter(listener);
        MapPartitionLostEventFilter filter = new MapPartitionLostEventFilter();
        EventRegistration registration = this.eventService.registerListener("hz:impl:mapService", mapName, filter, listenerAdapter);
        return registration.getId();
    }

    @Override
    public CompletableFuture<UUID> addPartitionLostListenerAsync(MapPartitionLostListener listener, String mapName) {
        InternalMapPartitionLostListenerAdapter listenerAdapter = new InternalMapPartitionLostListenerAdapter(listener);
        MapPartitionLostEventFilter filter = new MapPartitionLostEventFilter();
        return this.eventService.registerListenerAsync("hz:impl:mapService", mapName, filter, listenerAdapter).thenApplyAsync(EventRegistration::getId, ConcurrencyUtil.CALLER_RUNS);
    }

    private EventRegistration addListenerInternal(Object listener, EventFilter filter, String mapName, boolean local) {
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter(listener);
        filter = this.adoptEventFilter(filter, listenerAdaptor);
        if (local) {
            return this.eventService.registerLocalListener("hz:impl:mapService", mapName, filter, listenerAdaptor);
        }
        return this.eventService.registerListener("hz:impl:mapService", mapName, filter, listenerAdaptor);
    }

    private CompletableFuture<UUID> addListenerInternalAsync(Object listener, EventFilter filter, String mapName) {
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter(listener);
        filter = this.adoptEventFilter(filter, listenerAdaptor);
        return this.eventService.registerListenerAsync("hz:impl:mapService", mapName, filter, listenerAdaptor).thenApplyAsync(EventRegistration::getId, ConcurrencyUtil.CALLER_RUNS);
    }

    private EventFilter adoptEventFilter(EventFilter filter, ListenerAdapter listenerAdaptor) {
        if (!(filter instanceof EventListenerFilter)) {
            int enabledListeners = MapListenerFlagOperator.setAndGetListenerFlags(listenerAdaptor);
            filter = new EventListenerFilter(enabledListeners, filter);
        }
        return filter;
    }

    @Override
    public boolean removeEventListener(String mapName, UUID registrationId) {
        return this.eventService.deregisterListener("hz:impl:mapService", mapName, registrationId);
    }

    @Override
    public CompletableFuture<Boolean> removeEventListenerAsync(String mapName, UUID registrationId) {
        return this.eventService.deregisterListenerAsync("hz:impl:mapService", mapName, registrationId);
    }

    @Override
    public boolean removePartitionLostListener(String mapName, UUID registrationId) {
        return this.eventService.deregisterListener("hz:impl:mapService", mapName, registrationId);
    }

    @Override
    public CompletableFuture<Boolean> removePartitionLostListenerAsync(String mapName, UUID registrationId) {
        return this.eventService.deregisterListenerAsync("hz:impl:mapService", mapName, registrationId);
    }

    @Override
    public MapOperationProvider getMapOperationProvider(String mapName) {
        return this.operationProviders.getOperationProvider(mapName);
    }

    @Override
    public IndexProvider getIndexProvider(MapConfig mapConfig) {
        return this.indexProvider;
    }

    @Override
    public Extractors getExtractors(String mapName) {
        MapContainer mapContainer = this.getMapContainer(mapName);
        return mapContainer.getExtractors();
    }

    @Override
    public RecordStore createRecordStore(MapContainer mapContainer, int partitionId, MapKeyLoader keyLoader) {
        assert (partitionId != -1) : "Cannot be called with GENERIC_PARTITION_ID";
        ILogger logger = this.nodeEngine.getLogger(DefaultRecordStore.class);
        return new DefaultRecordStore(mapContainer, partitionId, keyLoader, logger);
    }

    @Override
    public boolean removeMapContainer(MapContainer mapContainer) {
        return this.mapContainers.remove(mapContainer.getName(), mapContainer);
    }

    @Override
    public PartitioningStrategy getPartitioningStrategy(String mapName, PartitioningStrategyConfig config) {
        return this.partitioningStrategyFactory.getPartitioningStrategy(mapName, config);
    }

    @Override
    public void removePartitioningStrategyFromCache(String mapName) {
        this.partitioningStrategyFactory.removePartitioningStrategyFromCache(mapName);
    }

    @Override
    public PartitionContainer[] getPartitionContainers() {
        return this.partitionContainers;
    }

    @Override
    public void onClusterStateChange(ClusterState newState) {
        this.expirationManager.onClusterStateChange(newState);
    }

    @Override
    public ResultProcessorRegistry getResultProcessorRegistry() {
        return this.resultProcessorRegistry;
    }

    @Override
    public MapNearCacheManager getMapNearCacheManager() {
        return this.mapNearCacheManager;
    }

    @Override
    public UUID addListenerAdapter(ListenerAdapter listenerAdaptor, EventFilter eventFilter, String mapName) {
        EventRegistration registration = this.getNodeEngine().getEventService().registerListener("hz:impl:mapService", mapName, eventFilter, listenerAdaptor);
        return registration.getId();
    }

    @Override
    public CompletableFuture<UUID> addListenerAdapterAsync(ListenerAdapter listenerAdaptor, EventFilter eventFilter, String mapName) {
        return this.getNodeEngine().getEventService().registerListenerAsync("hz:impl:mapService", mapName, eventFilter, listenerAdaptor).thenApplyAsync(EventRegistration::getId, ConcurrencyUtil.CALLER_RUNS);
    }

    @Override
    public UUID addLocalListenerAdapter(ListenerAdapter adapter, String mapName) {
        EventService eventService = this.getNodeEngine().getEventService();
        EventRegistration registration = eventService.registerLocalListener("hz:impl:mapService", mapName, adapter);
        return registration.getId();
    }

    @Override
    public QueryCacheContext getQueryCacheContext() {
        return this.queryCacheContext;
    }

    @Override
    public IndexCopyBehavior getIndexCopyBehavior() {
        return this.nodeEngine.getProperties().getEnum(ClusterProperty.INDEX_COPY_BEHAVIOR, IndexCopyBehavior.class);
    }

    @Override
    public boolean globalIndexEnabled() {
        return true;
    }

    @Override
    public ValueComparator getValueComparatorOf(InMemoryFormat inMemoryFormat) {
        return ValueComparatorUtil.getValueComparatorOf(inMemoryFormat);
    }

    @Override
    public Semaphore getNodeWideLoadedKeyLimiter() {
        return this.nodeWideLoadedKeyLimiter;
    }

    @Override
    public NodeWideUsedCapacityCounter getNodeWideUsedCapacityCounter() {
        return this.nodeWideUsedCapacityCounter;
    }

    PartitioningStrategyFactory getPartitioningStrategyFactory() {
        return this.partitioningStrategyFactory;
    }

    @Override
    public EventListenerCounter getEventListenerCounter() {
        return this.eventListenerCounter;
    }
}

