/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.core.EntryView;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.SimpleEntryView;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadata;
import com.hazelcast.map.impl.wan.WanMapEntryView;

public final class EntryViews {
    private EntryViews() {
    }

    public static <K, V> EntryView<K, V> createSimpleEntryView() {
        return new SimpleEntryView();
    }

    public static <K, V> EntryView<K, V> createSimpleEntryView(K key, V value, Record<V> record, ExpiryMetadata expiryMetadata) {
        return new SimpleEntryView<K, V>(key, value).withCost(record.getCost()).withVersion(record.getVersion()).withHits(record.getHits()).withLastAccessTime(record.getLastAccessTime()).withLastUpdateTime(EntryViews.calculateLastUpdateTime(record, expiryMetadata)).withCreationTime(record.getCreationTime()).withLastStoredTime(record.getLastStoredTime()).withTtl(expiryMetadata.getTtl()).withMaxIdle(expiryMetadata.getMaxIdle()).withExpirationTime(expiryMetadata.getExpirationTime());
    }

    public static <K, V> WanMapEntryView<K, V> createWanEntryView(Data key, Data value, Record<V> record, ExpiryMetadata expiryMetadata, SerializationService serializationService) {
        return new WanMapEntryView(key, value, serializationService).withCost(record.getCost()).withVersion(record.getVersion()).withHits(record.getHits()).withLastAccessTime(record.getLastAccessTime()).withLastUpdateTime(EntryViews.calculateLastUpdateTime(record, expiryMetadata)).withCreationTime(record.getCreationTime()).withLastStoredTime(record.getLastStoredTime()).withTtl(expiryMetadata.getTtl()).withMaxIdle(expiryMetadata.getMaxIdle()).withExpirationTime(expiryMetadata.getExpirationTime());
    }

    private static <V> long calculateLastUpdateTime(Record<V> record, ExpiryMetadata expiryMetadata) {
        if (expiryMetadata != ExpiryMetadata.NULL) {
            return expiryMetadata.getLastUpdateTime();
        }
        return record.getLastUpdateTime();
    }
}

