/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact.schema;

import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.serialization.impl.compact.schema.MemberSchemaService;
import com.hazelcast.internal.serialization.impl.compact.schema.SchemaDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;

public class FetchSchemaOperation
extends Operation
implements IdentifiedDataSerializable {
    private long schemaId;
    private Schema response;

    public FetchSchemaOperation() {
    }

    public FetchSchemaOperation(long schemaId) {
        this.schemaId = schemaId;
    }

    @Override
    public void run() {
        MemberSchemaService schemaService = (MemberSchemaService)this.getService();
        this.response = schemaService.getLocal(this.schemaId);
    }

    @Override
    public Schema getResponse() {
        return this.response;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeLong(this.schemaId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.schemaId = in.readLong();
    }

    @Override
    public String getServiceName() {
        return "schema-service";
    }

    @Override
    public int getFactoryId() {
        return SchemaDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 3;
    }
}

