/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy;

import com.hazelcast.client.impl.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MembershipListener;
import com.hazelcast.hotrestart.HotRestartService;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.persistence.PersistenceService;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.version.Version;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClientClusterProxy
implements Cluster {
    private final ClientClusterServiceImpl clusterService;

    public ClientClusterProxy(ClientClusterServiceImpl clusterService) {
        this.clusterService = clusterService;
    }

    @Override
    @Nonnull
    public UUID addMembershipListener(@Nonnull MembershipListener listener) {
        return this.clusterService.addMembershipListener(listener);
    }

    @Override
    public boolean removeMembershipListener(@Nonnull UUID registrationId) {
        return this.clusterService.removeMembershipListener(registrationId);
    }

    @Override
    @Nonnull
    public Set<Member> getMembers() {
        Collection<Member> members = this.clusterService.getMemberList();
        return new LinkedHashSet<Member>(members);
    }

    @Override
    @Nonnull
    public Member getLocalMember() {
        throw new UnsupportedOperationException("Client has no local member!");
    }

    @Override
    public long getClusterTime() {
        return Clock.currentTimeMillis();
    }

    @Override
    @Nonnull
    public ClusterState getClusterState() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void changeClusterState(@Nonnull ClusterState newState) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Version getClusterVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public HotRestartService getHotRestartService() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public PersistenceService getPersistenceService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void changeClusterState(@Nonnull ClusterState newState, @Nonnull TransactionOptions transactionOptions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdown(@Nullable TransactionOptions transactionOptions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void changeClusterVersion(@Nonnull Version version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void changeClusterVersion(@Nonnull Version version, @Nonnull TransactionOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void promoteLocalLiteMember() {
        throw new UnsupportedOperationException();
    }
}

