/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws;

import com.hazelcast.aws.AwsClient;
import com.hazelcast.aws.AwsCredentials;
import com.hazelcast.aws.AwsCredentialsProvider;
import com.hazelcast.aws.AwsEc2Api;
import com.hazelcast.aws.AwsEcsApi;
import com.hazelcast.aws.AwsMetadataApi;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class AwsEcsClient
implements AwsClient {
    private static final ILogger LOGGER = Logger.getLogger(AwsClient.class);
    private final AwsEcsApi awsEcsApi;
    private final AwsEc2Api awsEc2Api;
    private final AwsMetadataApi awsMetadataApi;
    private final AwsCredentialsProvider awsCredentialsProvider;
    private final String cluster;
    private boolean isNoPublicIpAlreadyLogged;

    AwsEcsClient(String cluster, AwsEcsApi awsEcsApi, AwsEc2Api awsEc2Api, AwsMetadataApi awsMetadataApi, AwsCredentialsProvider awsCredentialsProvider) {
        this.cluster = cluster;
        this.awsEcsApi = awsEcsApi;
        this.awsEc2Api = awsEc2Api;
        this.awsMetadataApi = awsMetadataApi;
        this.awsCredentialsProvider = awsCredentialsProvider;
    }

    @Override
    public Map<String, String> getAddresses() {
        AwsCredentials credentials = this.awsCredentialsProvider.credentials();
        LOGGER.fine(String.format("Listing tasks from cluster: '%s'", this.cluster));
        List<String> taskArns = this.awsEcsApi.listTasks(this.cluster, credentials);
        LOGGER.fine(String.format("AWS ECS ListTasks found the following tasks: %s", taskArns));
        if (!taskArns.isEmpty()) {
            List<AwsEcsApi.Task> tasks = this.awsEcsApi.describeTasks(this.cluster, taskArns, credentials);
            List<String> taskAddresses = tasks.stream().map(AwsEcsApi.Task::getPrivateAddress).collect(Collectors.toList());
            LOGGER.fine(String.format("AWS ECS DescribeTasks found the following addresses: %s", taskAddresses));
            return this.fetchPublicAddresses(taskAddresses, credentials);
        }
        return Collections.emptyMap();
    }

    private Map<String, String> fetchPublicAddresses(List<String> privateAddresses, AwsCredentials credentials) {
        try {
            return this.awsEc2Api.describeNetworkInterfaces(privateAddresses, credentials);
        }
        catch (Exception e) {
            LOGGER.finest(e);
            if (!this.isNoPublicIpAlreadyLogged) {
                LOGGER.warning("Cannot fetch the public IPs of ECS Tasks. You won't be able to use Hazelcast Smart Client from outside of this VPC.");
                this.isNoPublicIpAlreadyLogged = true;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            privateAddresses.forEach(k -> {
                String cfr_ignored_0 = map.put((String)k, (String)null);
            });
            return map;
        }
    }

    @Override
    public String getAvailabilityZone() {
        return this.awsMetadataApi.availabilityZoneEcs();
    }
}

