/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.StoreAdapter;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.spi.impl.operationexecutor.impl.PartitionOperationThread;

public class RecordStoreAdapter
implements StoreAdapter<Record> {
    private final RecordStore recordStore;

    public RecordStoreAdapter(RecordStore recordStore) {
        this.recordStore = recordStore;
    }

    @Override
    public boolean evictIfExpired(Data key, Record record, long now, boolean backup) {
        RecordStoreAdapter.ensureCallingFromPartitionOperationThread();
        record = this.recordStore.getOrNullIfExpired(key, record, now, backup);
        if (record != null) {
            return false;
        }
        this.recordStore.disposeDeferredBlocks();
        return true;
    }

    @Override
    public boolean isTtlOrMaxIdleDefined(Record record) {
        RecordStoreAdapter.ensureCallingFromPartitionOperationThread();
        return this.recordStore.isTtlOrMaxIdleDefined(record);
    }

    @Override
    public boolean isExpirable() {
        return this.recordStore.isExpirable();
    }

    private static void ensureCallingFromPartitionOperationThread() {
        if (Thread.currentThread().getClass() != PartitionOperationThread.class) {
            throw new IllegalThreadStateException(Thread.currentThread() + " cannot access data!");
        }
    }
}

