/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.Socket;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.h2.engine.SessionInterface;
import org.h2.message.DbException;
import org.h2.message.TraceSystem;
import org.h2.store.Data;
import org.h2.store.DataReader;
import org.h2.tools.SimpleResultSet;
import org.h2.util.DateTimeUtils;
import org.h2.util.IOUtils;
import org.h2.util.NetUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringFixed;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

public class Transfer {
    private static final int BUFFER_SIZE = 16384;
    private static final int LOB_MAGIC = 4660;
    private Socket socket;
    private DataInputStream in;
    private DataOutputStream out;
    private SessionInterface session;
    private boolean ssl;
    private int version;

    public Transfer(SessionInterface sessionInterface) {
        this.session = sessionInterface;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public void init() throws IOException {
        this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), 16384));
        this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream(), 16384));
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public Transfer writeBoolean(boolean bl) throws IOException {
        this.out.writeByte((byte)(bl ? 1 : 0));
        return this;
    }

    public boolean readBoolean() throws IOException {
        return this.in.readByte() == 1;
    }

    private Transfer writeByte(byte by) throws IOException {
        this.out.writeByte(by);
        return this;
    }

    private byte readByte() throws IOException {
        return this.in.readByte();
    }

    public Transfer writeInt(int n) throws IOException {
        this.out.writeInt(n);
        return this;
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public Transfer writeLong(long l) throws IOException {
        this.out.writeLong(l);
        return this;
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    private Transfer writeDouble(double d) throws IOException {
        this.out.writeDouble(d);
        return this;
    }

    private Transfer writeFloat(float f) throws IOException {
        this.out.writeFloat(f);
        return this;
    }

    private double readDouble() throws IOException {
        return this.in.readDouble();
    }

    private float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public Transfer writeString(String string) throws IOException {
        if (string == null) {
            this.out.writeInt(-1);
        } else {
            int n = string.length();
            this.out.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.out.writeChar(string.charAt(i));
            }
        }
        return this;
    }

    public String readString() throws IOException {
        int n = this.in.readInt();
        if (n == -1) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.in.readChar());
        }
        String string = stringBuilder.toString();
        string = StringUtils.cache(string);
        return string;
    }

    public Transfer writeBytes(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(byArray.length);
            this.out.write(byArray);
        }
        return this;
    }

    public byte[] readBytes() throws IOException {
        int n = this.readInt();
        if (n == -1) {
            return null;
        }
        byte[] byArray = Utils.newBytes(n);
        this.in.readFully(byArray);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.socket != null) {
            try {
                this.out.flush();
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException iOException) {
                TraceSystem.traceThrowable(iOException);
            }
            finally {
                this.socket = null;
            }
        }
    }

    public void writeValue(Value value) throws IOException {
        int n = value.getType();
        this.writeInt(n);
        switch (n) {
            case 0: {
                break;
            }
            case 12: 
            case 19: {
                this.writeBytes(value.getBytesNoCopy());
                break;
            }
            case 20: {
                ValueUuid valueUuid = (ValueUuid)value;
                this.writeLong(valueUuid.getHigh());
                this.writeLong(valueUuid.getLow());
                break;
            }
            case 1: {
                this.writeBoolean(value.getBoolean());
                break;
            }
            case 2: {
                this.writeByte(value.getByte());
                break;
            }
            case 9: {
                if (this.version >= 7) {
                    this.writeLong(DateTimeUtils.getTimeLocal(value.getTimeNoCopy()));
                    break;
                }
                this.writeLong(value.getTimeNoCopy().getTime());
                break;
            }
            case 10: {
                if (this.version >= 7) {
                    this.writeLong(DateTimeUtils.getTimeLocal(value.getDateNoCopy()));
                    break;
                }
                this.writeLong(value.getDateNoCopy().getTime());
                break;
            }
            case 11: {
                Timestamp timestamp = value.getTimestampNoCopy();
                if (this.version >= 7) {
                    this.writeLong(DateTimeUtils.getTimeLocal(timestamp));
                } else {
                    this.writeLong(timestamp.getTime());
                }
                this.writeInt(timestamp.getNanos());
                break;
            }
            case 6: {
                this.writeString(value.getString());
                break;
            }
            case 7: {
                this.writeDouble(value.getDouble());
                break;
            }
            case 8: {
                this.writeFloat(value.getFloat());
                break;
            }
            case 4: {
                this.writeInt(value.getInt());
                break;
            }
            case 5: {
                this.writeLong(value.getLong());
                break;
            }
            case 3: {
                this.writeInt(value.getShort());
                break;
            }
            case 13: 
            case 14: 
            case 21: {
                this.writeString(value.getString());
                break;
            }
            case 15: {
                long l = value.getPrecision();
                if (l < 0L) {
                    throw DbException.get(90067, "length=" + l);
                }
                this.writeLong(l);
                long l2 = IOUtils.copyAndCloseInput(value.getInputStream(), this.out);
                if (l2 != l) {
                    throw DbException.get(90067, "length:" + l + " written:" + l2);
                }
                this.writeInt(4660);
                break;
            }
            case 16: {
                long l = value.getPrecision();
                if (l < 0L) {
                    throw DbException.get(90067, "length=" + l);
                }
                this.writeLong(l);
                Reader reader = value.getReader();
                Data.copyString(reader, this.out);
                this.writeInt(4660);
                break;
            }
            case 17: {
                ValueArray valueArray = (ValueArray)value;
                Value[] valueArray2 = valueArray.getList();
                int n2 = valueArray2.length;
                Class<?> clazz = valueArray.getComponentType();
                if (clazz == Object.class) {
                    this.writeInt(n2);
                } else {
                    this.writeInt(-(n2 + 1));
                    this.writeString(clazz.getName());
                }
                for (Value value2 : valueArray2) {
                    this.writeValue(value2);
                }
                break;
            }
            case 18: {
                try {
                    int n3;
                    ResultSet resultSet = ((ValueResultSet)value).getResultSet();
                    resultSet.beforeFirst();
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n4 = resultSetMetaData.getColumnCount();
                    this.writeInt(n4);
                    for (n3 = 0; n3 < n4; ++n3) {
                        this.writeString(resultSetMetaData.getColumnName(n3 + 1));
                        this.writeInt(resultSetMetaData.getColumnType(n3 + 1));
                        this.writeInt(resultSetMetaData.getPrecision(n3 + 1));
                        this.writeInt(resultSetMetaData.getScale(n3 + 1));
                    }
                    while (resultSet.next()) {
                        this.writeBoolean(true);
                        for (n3 = 0; n3 < n4; ++n3) {
                            int n5 = DataType.convertSQLTypeToValueType(resultSetMetaData.getColumnType(n3 + 1));
                            Value value3 = DataType.readValue(this.session, resultSet, n3 + 1, n5);
                            this.writeValue(value3);
                        }
                    }
                    this.writeBoolean(false);
                    resultSet.beforeFirst();
                    break;
                }
                catch (SQLException sQLException) {
                    throw DbException.convertToIOException(sQLException);
                }
            }
            default: {
                throw DbException.get(90067, "type=" + n);
            }
        }
    }

    public Value readValue() throws IOException {
        int n = this.readInt();
        switch (n) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 12: {
                return ValueBytes.getNoCopy(this.readBytes());
            }
            case 20: {
                return ValueUuid.get(this.readLong(), this.readLong());
            }
            case 19: {
                return ValueJavaObject.getNoCopy(this.readBytes());
            }
            case 1: {
                return ValueBoolean.get(this.readBoolean());
            }
            case 2: {
                return ValueByte.get(this.readByte());
            }
            case 10: {
                if (this.version >= 7) {
                    return ValueDate.getNoCopy(new Date(DateTimeUtils.getTimeGMT(this.readLong())));
                }
                return ValueDate.getNoCopy(new Date(this.readLong()));
            }
            case 9: {
                if (this.version >= 7) {
                    return ValueTime.getNoCopy(new Time(DateTimeUtils.getTimeGMT(this.readLong())));
                }
                return ValueTime.getNoCopy(new Time(this.readLong()));
            }
            case 11: {
                if (this.version >= 7) {
                    Timestamp timestamp = new Timestamp(DateTimeUtils.getTimeGMT(this.readLong()));
                    timestamp.setNanos(this.readInt());
                    return ValueTimestamp.getNoCopy(timestamp);
                }
                Timestamp timestamp = new Timestamp(this.readLong());
                timestamp.setNanos(this.readInt());
                return ValueTimestamp.getNoCopy(timestamp);
            }
            case 6: {
                return ValueDecimal.get(new BigDecimal(this.readString()));
            }
            case 7: {
                return ValueDouble.get(this.readDouble());
            }
            case 8: {
                return ValueFloat.get(this.readFloat());
            }
            case 4: {
                return ValueInt.get(this.readInt());
            }
            case 5: {
                return ValueLong.get(this.readLong());
            }
            case 3: {
                return ValueShort.get((short)this.readInt());
            }
            case 13: {
                return ValueString.get(this.readString());
            }
            case 14: {
                return ValueStringIgnoreCase.get(this.readString());
            }
            case 21: {
                return ValueStringFixed.get(this.readString());
            }
            case 15: {
                long l = this.readLong();
                Value value = this.session.getDataHandler().getLobStorage().createBlob(this.in, l);
                int n2 = this.readInt();
                if (n2 != 4660) {
                    throw DbException.get(90067, "magic=" + n2);
                }
                return value;
            }
            case 16: {
                long l = this.readLong();
                Value value = this.session.getDataHandler().getLobStorage().createClob(new DataReader(this.in), l);
                int n3 = this.readInt();
                if (n3 != 4660) {
                    throw DbException.get(90067, "magic=" + n3);
                }
                return value;
            }
            case 17: {
                int n4 = this.readInt();
                Class clazz = Object.class;
                if (n4 < 0) {
                    n4 = -(n4 + 1);
                    clazz = Utils.loadUserClass(this.readString());
                }
                Value[] valueArray = new Value[n4];
                for (int i = 0; i < n4; ++i) {
                    valueArray[i] = this.readValue();
                }
                return ValueArray.get(clazz, valueArray);
            }
            case 18: {
                SimpleResultSet simpleResultSet = new SimpleResultSet();
                int n5 = this.readInt();
                for (int i = 0; i < n5; ++i) {
                    simpleResultSet.addColumn(this.readString(), this.readInt(), this.readInt(), this.readInt());
                }
                while (this.readBoolean()) {
                    Object[] objectArray = new Object[n5];
                    for (int i = 0; i < n5; ++i) {
                        objectArray[i] = this.readValue().getObject();
                    }
                    simpleResultSet.addRow(objectArray);
                }
                return ValueResultSet.get(simpleResultSet);
            }
        }
        throw DbException.get(90067, "type=" + n);
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSession(SessionInterface sessionInterface) {
        this.session = sessionInterface;
    }

    public void setSSL(boolean bl) {
        this.ssl = bl;
    }

    public Transfer openNewConnection() throws IOException {
        InetAddress inetAddress = this.socket.getInetAddress();
        int n = this.socket.getPort();
        Socket socket = NetUtils.createSocket(inetAddress, n, this.ssl);
        Transfer transfer = new Transfer(null);
        transfer.setSocket(socket);
        transfer.setSSL(this.ssl);
        return transfer;
    }

    public void setVersion(int n) {
        this.version = n;
    }
}

