/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import org.h2.message.DbException;
import org.h2.store.PageStore;

public class InDoubtTransaction {
    public static final int IN_DOUBT = 0;
    public static final int COMMIT = 1;
    public static final int ROLLBACK = 2;
    private final PageStore store;
    private final int sessionId;
    private final int pos;
    private final String transaction;
    private int state;

    public InDoubtTransaction(PageStore pageStore, int n, int n2, String string) {
        this.store = pageStore;
        this.sessionId = n;
        this.pos = n2;
        this.transaction = string;
        this.state = 0;
    }

    public void setState(int n) {
        switch (n) {
            case 1: {
                this.store.setInDoubtTransactionState(this.sessionId, this.pos, true);
                break;
            }
            case 2: {
                this.store.setInDoubtTransactionState(this.sessionId, this.pos, false);
                break;
            }
            default: {
                DbException.throwInternalError("state=" + n);
            }
        }
        this.state = n;
    }

    public String getState() {
        switch (this.state) {
            case 0: {
                return "IN_DOUBT";
            }
            case 1: {
                return "COMMIT";
            }
            case 2: {
                return "ROLLBACK";
            }
        }
        throw DbException.throwInternalError("state=" + this.state);
    }

    public String getTransaction() {
        return this.transaction;
    }
}

