/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value.object.model;

import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.util.ClassUtil;
import proguard.evaluation.MethodResult;
import proguard.evaluation.ValueCalculator;
import proguard.evaluation.executor.MethodExecutionInfo;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.object.model.reflective.ModelHelper;
import proguard.evaluation.value.object.model.reflective.ModeledInstanceMethod;
import proguard.evaluation.value.object.model.reflective.ModeledStaticMethod;
import proguard.evaluation.value.object.model.reflective.ReflectiveModel;

public class ClassModel
implements ReflectiveModel<ClassModel> {
    private final Clazz clazz;

    private ClassModel() {
        this.clazz = null;
    }

    public ClassModel(Clazz clazz) {
        this.clazz = clazz;
    }

    public Clazz getClazz() {
        return this.clazz;
    }

    @Override
    @NotNull
    public String getType() {
        return "Ljava/lang/Class;";
    }

    @Override
    public MethodResult init(MethodExecutionInfo methodExecutionInfo, ValueCalculator valueCalculator) {
        throw new UnsupportedOperationException("Constructors invocation is not supported in ClassModel");
    }

    @ModeledInstanceMethod(name="getName", descriptor="()Ljava/lang/String;")
    MethodResult getName(ModelHelper.MethodExecutionContext context) {
        if (this.clazz == null) {
            return MethodResult.invalidResult();
        }
        return ModelHelper.createDefaultReturnResult(context, this.clazz.getName());
    }

    @ModeledInstanceMethod(name="getSimpleName", descriptor="()Ljava/lang/String;")
    MethodResult getSimpleName(ModelHelper.MethodExecutionContext context) {
        if (this.clazz == null) {
            return MethodResult.invalidResult();
        }
        return ModelHelper.createDefaultReturnResult(context, ClassUtil.internalSimpleClassName(this.clazz.getName()));
    }

    @ModeledInstanceMethod(name="getCanonicalName", descriptor="()Ljava/lang/String;")
    MethodResult getCanonicalName(ModelHelper.MethodExecutionContext context) {
        if (this.clazz == null) {
            return MethodResult.invalidResult();
        }
        return ModelHelper.createDefaultReturnResult(context, ClassUtil.canonicalClassName(this.clazz.getName()));
    }

    @ModeledInstanceMethod(name="getPackageName", descriptor="()Ljava/lang/String;")
    MethodResult getPackageName(ModelHelper.MethodExecutionContext context) {
        if (this.clazz == null) {
            return MethodResult.invalidResult();
        }
        return ModelHelper.createDefaultReturnResult(context, ClassUtil.externalPackageName(ClassUtil.externalClassName(this.clazz.getName())));
    }

    @ModeledInstanceMethod(name="getTypeName", descriptor="()Ljava/lang/String;")
    MethodResult getTypeName(ModelHelper.MethodExecutionContext context) {
        if (this.clazz == null) {
            return MethodResult.invalidResult();
        }
        return ModelHelper.createDefaultReturnResult(context, ClassUtil.externalClassName(this.clazz.getName()));
    }

    @ModeledInstanceMethod(name="getSuperclass", descriptor="()Ljava/lang/Class;")
    private MethodResult getSuperclass(ModelHelper.MethodExecutionContext context) {
        if (this.clazz == null) {
            return MethodResult.invalidResult();
        }
        Clazz superClass = this.clazz.getSuperClass();
        if (superClass == null) {
            return MethodResult.invalidResult();
        }
        return ModelHelper.createDefaultReturnResult(context, new ClassModel(this.clazz.getSuperClass()));
    }

    @ModeledStaticMethod(name="forName", descriptor="(Ljava/lang/String;)Ljava/lang/Class;")
    MethodResult forName(ModelHelper.MethodExecutionContext context, Value classNameValue) {
        if (!classNameValue.isParticular()) {
            return MethodResult.invalidResult();
        }
        Optional<Clazz> clazz = this.findReferencedClazz((String)classNameValue.referenceValue().getValue().getPreciseValue(), context.getExecutionInfo().getProgramClassPool(), context.getExecutionInfo().getLibraryClassPool());
        if (clazz.isPresent()) {
            return ModelHelper.createDefaultReturnResult(context, new ClassModel(clazz.get()));
        }
        return MethodResult.invalidResult();
    }

    @ModeledStaticMethod(name="forName", descriptor="(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;")
    MethodResult forName(ModelHelper.MethodExecutionContext context, Value classNameValue, Value initializeValue, Value classLoaderValue) {
        if (!classNameValue.isParticular()) {
            return MethodResult.invalidResult();
        }
        Optional<Clazz> clazz = this.findReferencedClazz((String)classNameValue.referenceValue().getValue().getPreciseValue(), context.getExecutionInfo().getProgramClassPool(), context.getExecutionInfo().getLibraryClassPool());
        if (clazz.isPresent()) {
            return ModelHelper.createDefaultReturnResult(context, new ClassModel(clazz.get()));
        }
        return MethodResult.invalidResult();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassModel that = (ClassModel)o;
        return Objects.equals(this.clazz, that.clazz);
    }

    public int hashCode() {
        return Objects.hashCode(this.clazz);
    }

    public String toString() {
        return String.format("ClassModel{%s}", this.clazz.getName());
    }

    private Optional<Clazz> findReferencedClazz(@Nullable String className, ClassPool programClassPool, ClassPool libraryClassPool) {
        if (className == null) {
            return Optional.empty();
        }
        Clazz result = programClassPool.getClass(className = ClassUtil.internalClassName(className));
        return result != null ? Optional.of(result) : Optional.ofNullable(libraryClassPool.getClass(className));
    }
}

