/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value.object;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import proguard.classfile.Clazz;
import proguard.classfile.util.InitializedClassUtil;
import proguard.evaluation.value.object.model.Model;

public interface AnalyzedObject {
    @Nullable
    public String getType();

    public boolean isNull();

    public boolean isModeled();

    public boolean isPrecise();

    default public boolean isOfType(@NotNull String type) {
        return type.equals(this.getType());
    }

    default public boolean isOfTypeAndNotNull(@NotNull String type) {
        return !this.isNull() && this.isOfType(type);
    }

    default public boolean isInstanceOf(Clazz clazz) {
        if (this.isNull() || clazz == null) {
            return false;
        }
        return InitializedClassUtil.isInstanceOf(this.getType(), clazz);
    }

    @Nullable
    default public Object getPreciseValue() {
        throw new UnsupportedOperationException("This is not a precise object");
    }

    default public Model getModeledValue() {
        throw new UnsupportedOperationException("This is not a modeled object");
    }

    @Nullable
    default public Model getModeledOrNullValue() {
        if (this.isNull()) {
            return null;
        }
        return this.getModeledValue();
    }
}

