/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin;

import java.util.List;
import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinAnnotatable;
import proguard.classfile.kotlin.KotlinAnnotation;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinTypeAliasMetadata;
import proguard.classfile.kotlin.KotlinTypeParameterMetadata;
import proguard.classfile.kotlin.KotlinTypeVariance;
import proguard.classfile.kotlin.flags.KotlinCommonFlags;
import proguard.classfile.kotlin.flags.KotlinTypeFlags;
import proguard.classfile.kotlin.visitor.KotlinAnnotationVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeVisitor;
import proguard.util.Processable;
import proguard.util.SimpleProcessable;

public class KotlinTypeMetadata
extends SimpleProcessable
implements Processable,
KotlinAnnotatable {
    public KotlinTypeVariance variance;
    public List<KotlinTypeMetadata> typeArguments;
    public KotlinTypeMetadata abbreviation;
    public String className;
    public Clazz referencedClass;
    public int typeParamID = -1;
    public KotlinTypeParameterMetadata referencedParameter;
    public String aliasName;
    public KotlinTypeAliasMetadata referencedTypeAlias;
    public KotlinTypeMetadata outerClassType;
    public String flexibilityID;
    public List<KotlinTypeMetadata> upperBounds;
    public boolean isRaw = false;
    public List<KotlinAnnotation> annotations;
    public KotlinTypeFlags flags;
    private static final KotlinTypeMetadata STAR_PROJECTION = new KotlinStarProjectionMetadata();

    public KotlinTypeMetadata(KotlinTypeFlags flags) {
        this(flags, null);
    }

    public KotlinTypeMetadata(KotlinTypeFlags flags, KotlinTypeVariance variance) {
        this.variance = variance;
        this.flags = flags;
    }

    public void accept(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinTypeVisitor kotlinTypeVisitor) {
        kotlinTypeVisitor.visitSuperType(clazz, kotlinClassKindMetadata, this);
    }

    public void upperBoundsAccept(Clazz clazz, KotlinTypeVisitor kotlinTypeVisitor) {
        for (KotlinTypeMetadata upperBound : this.upperBounds) {
            upperBound.acceptAsUpperBound(clazz, this, kotlinTypeVisitor);
        }
    }

    public void typeArgumentsAccept(Clazz clazz, KotlinTypeVisitor kotlinTypeVisitor) {
        for (KotlinTypeMetadata typeArgument : this.typeArguments) {
            if (typeArgument.isStarProjection()) {
                kotlinTypeVisitor.visitStarProjection(clazz, this);
                continue;
            }
            kotlinTypeVisitor.visitTypeArgument(clazz, this, typeArgument);
        }
    }

    public void outerClassAccept(Clazz clazz, KotlinTypeVisitor kotlinTypeVisitor) {
        if (this.outerClassType != null) {
            kotlinTypeVisitor.visitOuterClass(clazz, this, this.outerClassType);
        }
    }

    private void acceptAsUpperBound(Clazz clazz, KotlinTypeMetadata boundedType, KotlinTypeVisitor kotlinTypeVisitor) {
        kotlinTypeVisitor.visitTypeUpperBound(clazz, boundedType, this);
    }

    public void abbreviationAccept(Clazz clazz, KotlinTypeVisitor kotlinTypeVisitor) {
        if (this.abbreviation != null) {
            this.abbreviation.acceptAsAbbreviation(clazz, this, kotlinTypeVisitor);
        }
    }

    private void acceptAsAbbreviation(Clazz clazz, KotlinTypeMetadata abbreviatedType, KotlinTypeVisitor kotlinTypeVisitor) {
        kotlinTypeVisitor.visitAbbreviation(clazz, abbreviatedType, this);
    }

    public void accept(Clazz clazz, KotlinTypeParameterMetadata boundedTypeParameter, KotlinTypeVisitor kotlinTypeVisitor) {
        kotlinTypeVisitor.visitParameterUpperBound(clazz, boundedTypeParameter, this);
    }

    @Override
    public void annotationsAccept(Clazz clazz, KotlinAnnotationVisitor kotlinAnnotationVisitor) {
        for (KotlinAnnotation annotation : this.annotations) {
            kotlinAnnotationVisitor.visitTypeAnnotation(clazz, this, annotation);
        }
    }

    public String toString() {
        return "Kotlin type";
    }

    public static KotlinTypeMetadata starProjection() {
        return STAR_PROJECTION;
    }

    public boolean isStarProjection() {
        return false;
    }

    private static class KotlinStarProjectionMetadata
    extends KotlinTypeMetadata {
        KotlinStarProjectionMetadata() {
            super(new KotlinTypeFlags(new KotlinCommonFlags()));
        }

        @Override
        public boolean isStarProjection() {
            return true;
        }
    }
}

