/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.datastructure.callgraph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import proguard.analysis.datastructure.CodeLocation;
import proguard.analysis.datastructure.callgraph.EntryPoint;
import proguard.classfile.MethodSignature;

public class Node {
    public final MethodSignature signature;
    public final Set<Node> predecessors = new HashSet<Node>();
    public final Set<CodeLocation> incomingCallLocations = new HashSet<CodeLocation>();
    public final Set<CodeLocation> outgoingCallLocations = new HashSet<CodeLocation>();
    public final Set<Node> successors = new HashSet<Node>();
    public EntryPoint matchingEntrypoint = null;
    public boolean isTruncated = false;

    public Node(MethodSignature signature) {
        this.signature = signature;
    }

    public boolean successorsContain(MethodSignature signature) {
        if (this.signature.equals(signature)) {
            return true;
        }
        return this.successors.stream().anyMatch(s -> s.successorsContain(signature));
    }

    public boolean predecessorsContain(MethodSignature signature) {
        if (this.signature.equals(signature)) {
            return true;
        }
        return this.successors.stream().anyMatch(s -> s.predecessorsContain(signature));
    }

    public int getSuccessorDepth() {
        if (this.successors.isEmpty()) {
            return 0;
        }
        return this.successors.stream().mapToInt(s -> s.getSuccessorDepth() + 1).max().getAsInt();
    }

    public int getPredecessorDepth() {
        if (this.predecessors.isEmpty()) {
            return 0;
        }
        return this.predecessors.stream().mapToInt(s -> s.getSuccessorDepth() + 1).max().getAsInt();
    }

    public Set<Node> getAllPredecessors() {
        HashSet<Node> predecessors = new HashSet<Node>();
        ArrayList<Node> worklist = new ArrayList<Node>();
        worklist.add(this);
        while (!worklist.isEmpty()) {
            Node curr = (Node)worklist.remove(0);
            predecessors.add(curr);
            worklist.addAll(curr.predecessors);
        }
        return predecessors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node that = (Node)o;
        return Objects.equals(this.signature, that.signature);
    }

    public int hashCode() {
        return Objects.hash(this.signature);
    }
}

