/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.ClassOptimizationInfo;
import proguard.optimize.info.ProgramClassOptimizationInfo;

public class PackageVisibleMemberContainingClassMarker
implements ClassVisitor,
MemberVisitor {
    public void visitAnyClass(Clazz clazz) {
        if ((clazz.getAccessFlags() & 1) == 0) {
            PackageVisibleMemberContainingClassMarker.setPackageVisibleMembers(clazz);
        } else {
            clazz.fieldsAccept((MemberVisitor)this);
            clazz.methodsAccept((MemberVisitor)this);
        }
    }

    public void visitAnyMember(Clazz clazz, Member member) {
        if ((member.getAccessFlags() & 3) == 0) {
            PackageVisibleMemberContainingClassMarker.setPackageVisibleMembers(clazz);
        }
    }

    private static void setPackageVisibleMembers(Clazz clazz) {
        ProgramClassOptimizationInfo.getProgramClassOptimizationInfo(clazz).setContainsPackageVisibleMembers();
    }

    public static boolean containsPackageVisibleMembers(Clazz clazz) {
        return ClassOptimizationInfo.getClassOptimizationInfo(clazz).containsPackageVisibleMembers();
    }
}

