/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.SingleTimeAttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.InstructionSequenceMatcher;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.ImplementedClassFilter;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.InvocationUnit;
import proguard.evaluation.PartialEvaluator;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.TypedReferenceValueFactory;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.gson.GsonRuntimeSettings;
import proguard.optimize.gson.TypeArgumentFinder;

public class GsonBuilderInvocationFinder
implements InstructionVisitor {
    private final InstructionSequenceMatcher setVersionMatcher;
    private final InstructionSequenceMatcher excludeFieldsWithModifiersMatcher;
    private final InstructionSequenceMatcher generateNonExecutableJsonMatcher;
    private final InstructionSequenceMatcher excludeFieldsWithoutExposeAnnotationMatcher;
    private final InstructionSequenceMatcher serializeNullsMatcher;
    private final InstructionSequenceMatcher disableInnerClassSerializationMatcher;
    private final InstructionSequenceMatcher setLongSerializationPolicyMatcher;
    private final InstructionSequenceMatcher setFieldNamingPolicyMatcher;
    private final InstructionSequenceMatcher setFieldNamingStrategyMatcher;
    private final InstructionSequenceMatcher setExclusionStrategiesMatcher;
    private final InstructionSequenceMatcher addSerializationExclusionStrategyMatcher;
    private final InstructionSequenceMatcher addDeserializationExclusionStrategyMatcher;
    private final InstructionSequenceMatcher registerTypeAdapterMatcher;
    private final InstructionSequenceMatcher registerTypeHierachyAdapterMatcher;
    private final InstructionSequenceMatcher registerTypeAdapterFactoryMatcher;
    private final InstructionSequenceMatcher serializeSpecialFloatingPointValuesMatcher;
    private final TypedReferenceValueFactory valueFactory = new TypedReferenceValueFactory();
    private final PartialEvaluator partialEvaluator = PartialEvaluator.Builder.create().setValueFactory((ValueFactory)this.valueFactory).setInvocationUnit((InvocationUnit)new BasicInvocationUnit((ValueFactory)this.valueFactory)).setEvaluateAllCode(true).build();
    private final AttributeVisitor lazyPartialEvaluator = new AttributeNameFilter("Code", (AttributeVisitor)new SingleTimeAttributeVisitor((AttributeVisitor)this.partialEvaluator));
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final GsonRuntimeSettings gsonRuntimeSettings;
    private final ClassVisitor instanceCreatorClassVisitor;
    private final ClassVisitor typeAdapterClassVisitor;

    public GsonBuilderInvocationFinder(ClassPool programClassPool, ClassPool libraryClassPool, GsonRuntimeSettings gsonRuntimeSettings, ClassVisitor instanceCreatorClassVisitor, ClassVisitor typeAdapterClassVisitor) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.gsonRuntimeSettings = gsonRuntimeSettings;
        this.instanceCreatorClassVisitor = instanceCreatorClassVisitor;
        this.typeAdapterClassVisitor = typeAdapterClassVisitor;
        InstructionSequenceBuilder builder = new InstructionSequenceBuilder();
        Instruction[] setVersionInstructions = builder.invokevirtual("com/google/gson/GsonBuilder", "setVersion", "(D)Lcom/google/gson/GsonBuilder;").instructions();
        Instruction[] excludeFieldsWithModifiersInstructions = builder.invokevirtual("com/google/gson/GsonBuilder", "excludeFieldsWithModifiers", "([I)Lcom/google/gson/GsonBuilder;").instructions();
        Instruction[] generateNonExecutableJsonInstructions = builder.invokevirtual("com/google/gson/GsonBuilder", "generateNonExecutableJson", "()Lcom/google/gson/GsonBuilder;").instructions();
        Instruction[] excludeFieldsWithoutExposeAnnotationInstructions = builder.invokevirtual("com/google/gson/GsonBuilder", "excludeFieldsWithoutExposeAnnotation", "()Lcom/google/gson/GsonBuilder;").instructions();
        Instruction[] serializeNullsInstructions = builder.invokevirtual("com/google/gson/GsonBuilder", "serializeNulls", "()Lcom/google/gson/GsonBuilder;").instructions();
        Instruction[] enableComplexMapKeySerializationInstructions = builder.invokevirtual("com/google/gson/GsonBuilder", "enableComplexMapKeySerialization", "()Lcom/google/gson/GsonBuilder;").instructions();
        Instruction[] disableInnerClassSerializationInstructions = builder.invokevirtual("com/google/gson/GsonBuilder", "disableInnerClassSerialization", "()Lcom/google/gson/GsonBuilder;").instructions();
        Instruction[] setLongSerializationPolicyInstructions = builder.invokevirtual("com/google/gson/GsonBuilder", "setLongSerializationPolicy", "(Lcom/google/gson/LongSerializationPolicy;)Lcom/google/gson/GsonBuilder;").instructions();
        Instruction[] setFieldNamingStrategyInstructions = builder.invokevirtual("com/google/gson/GsonBuilder", "setFieldNamingStrategy", "(Lcom/google/gson/FieldNamingStrategy;)Lcom/google/gson/GsonBuilder;").instructions();
        Instruction[] setFieldNamingPolicyInstructions = builder.invokevirtual("com/google/gson/GsonBuilder", "setFieldNamingPolicy", "(Lcom/google/gson/FieldNamingPolicy;)Lcom/google/gson/GsonBuilder;").instructions();
        Instruction[] setExclusionStrategiesInstructions = builder.invokevirtual("com/google/gson/GsonBuilder", "setExclusionStrategies", "([Lcom/google/gson/ExclusionStrategy;)Lcom/google/gson/GsonBuilder;").instructions();
        Instruction[] addSerializationExclusionStrategyInstructions = builder.invokevirtual("com/google/gson/GsonBuilder", "addSerializationExclusionStrategy", "(Lcom/google/gson/ExclusionStrategy;)Lcom/google/gson/GsonBuilder;").instructions();
        Instruction[] addDeserializationExclusionStrategyInstructions = builder.invokevirtual("com/google/gson/GsonBuilder", "addDeserializationExclusionStrategy", "(Lcom/google/gson/ExclusionStrategy;)Lcom/google/gson/GsonBuilder;").instructions();
        Instruction[] registerTypeAdapterInstructions = builder.invokevirtual("com/google/gson/GsonBuilder", "registerTypeAdapter", "(Ljava/lang/reflect/Type;Ljava/lang/Object;)Lcom/google/gson/GsonBuilder;").instructions();
        Instruction[] registerTypeHierarchyAdapterInstructions = builder.invokevirtual("com/google/gson/GsonBuilder", "registerTypeHierarchyAdapter", "(Ljava/lang/Class;Ljava/lang/Object;)Lcom/google/gson/GsonBuilder;").instructions();
        Instruction[] registerTypeAdapterFactoryInstructions = builder.invokevirtual("com/google/gson/GsonBuilder", "registerTypeAdapterFactory", "(Lcom/google/gson/TypeAdapterFactory;)Lcom/google/gson/GsonBuilder;").instructions();
        Instruction[] serializeSpecialFloatingPointValuesInstructions = builder.invokevirtual("com/google/gson/GsonBuilder", "serializeSpecialFloatingPointValues", "()Lcom/google/gson/GsonBuilder;").instructions();
        Constant[] constants = builder.constants();
        this.setVersionMatcher = new InstructionSequenceMatcher(constants, setVersionInstructions);
        this.excludeFieldsWithModifiersMatcher = new InstructionSequenceMatcher(constants, excludeFieldsWithModifiersInstructions);
        this.generateNonExecutableJsonMatcher = new InstructionSequenceMatcher(constants, generateNonExecutableJsonInstructions);
        this.excludeFieldsWithoutExposeAnnotationMatcher = new InstructionSequenceMatcher(constants, excludeFieldsWithoutExposeAnnotationInstructions);
        this.serializeNullsMatcher = new InstructionSequenceMatcher(constants, serializeNullsInstructions);
        this.disableInnerClassSerializationMatcher = new InstructionSequenceMatcher(constants, disableInnerClassSerializationInstructions);
        this.setLongSerializationPolicyMatcher = new InstructionSequenceMatcher(constants, setLongSerializationPolicyInstructions);
        this.setFieldNamingPolicyMatcher = new InstructionSequenceMatcher(constants, setFieldNamingPolicyInstructions);
        this.setFieldNamingStrategyMatcher = new InstructionSequenceMatcher(constants, setFieldNamingStrategyInstructions);
        this.setExclusionStrategiesMatcher = new InstructionSequenceMatcher(constants, setExclusionStrategiesInstructions);
        this.addSerializationExclusionStrategyMatcher = new InstructionSequenceMatcher(constants, addSerializationExclusionStrategyInstructions);
        this.addDeserializationExclusionStrategyMatcher = new InstructionSequenceMatcher(constants, addDeserializationExclusionStrategyInstructions);
        this.registerTypeAdapterMatcher = new InstructionSequenceMatcher(constants, registerTypeAdapterInstructions);
        this.registerTypeHierachyAdapterMatcher = new InstructionSequenceMatcher(constants, registerTypeHierarchyAdapterInstructions);
        this.registerTypeAdapterFactoryMatcher = new InstructionSequenceMatcher(constants, registerTypeAdapterFactoryInstructions);
        this.serializeSpecialFloatingPointValuesMatcher = new InstructionSequenceMatcher(constants, serializeSpecialFloatingPointValuesInstructions);
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        if (!this.gsonRuntimeSettings.setVersion) {
            instruction.accept(clazz, method, codeAttribute, offset, (InstructionVisitor)this.setVersionMatcher);
            this.gsonRuntimeSettings.setVersion = this.setVersionMatcher.isMatching();
        }
        if (!this.gsonRuntimeSettings.excludeFieldsWithModifiers) {
            instruction.accept(clazz, method, codeAttribute, offset, (InstructionVisitor)this.excludeFieldsWithModifiersMatcher);
            this.gsonRuntimeSettings.excludeFieldsWithModifiers = this.excludeFieldsWithModifiersMatcher.isMatching();
        }
        if (!this.gsonRuntimeSettings.generateNonExecutableJson) {
            instruction.accept(clazz, method, codeAttribute, offset, (InstructionVisitor)this.generateNonExecutableJsonMatcher);
            this.gsonRuntimeSettings.generateNonExecutableJson = this.generateNonExecutableJsonMatcher.isMatching();
        }
        if (!this.gsonRuntimeSettings.excludeFieldsWithoutExposeAnnotation) {
            instruction.accept(clazz, method, codeAttribute, offset, (InstructionVisitor)this.excludeFieldsWithoutExposeAnnotationMatcher);
            this.gsonRuntimeSettings.excludeFieldsWithoutExposeAnnotation = this.excludeFieldsWithoutExposeAnnotationMatcher.isMatching();
        }
        if (!this.gsonRuntimeSettings.serializeNulls) {
            instruction.accept(clazz, method, codeAttribute, offset, (InstructionVisitor)this.serializeNullsMatcher);
            this.gsonRuntimeSettings.serializeNulls = this.serializeNullsMatcher.isMatching();
        }
        if (!this.gsonRuntimeSettings.disableInnerClassSerialization) {
            instruction.accept(clazz, method, codeAttribute, offset, (InstructionVisitor)this.disableInnerClassSerializationMatcher);
            this.gsonRuntimeSettings.disableInnerClassSerialization = this.disableInnerClassSerializationMatcher.isMatching();
        }
        if (!this.gsonRuntimeSettings.setLongSerializationPolicy) {
            instruction.accept(clazz, method, codeAttribute, offset, (InstructionVisitor)this.setLongSerializationPolicyMatcher);
            this.gsonRuntimeSettings.setLongSerializationPolicy = this.setLongSerializationPolicyMatcher.isMatching();
        }
        if (!this.gsonRuntimeSettings.setFieldNamingPolicy) {
            instruction.accept(clazz, method, codeAttribute, offset, (InstructionVisitor)this.setFieldNamingPolicyMatcher);
            this.gsonRuntimeSettings.setFieldNamingPolicy = this.setFieldNamingPolicyMatcher.isMatching();
        }
        if (!this.gsonRuntimeSettings.setFieldNamingStrategy) {
            instruction.accept(clazz, method, codeAttribute, offset, (InstructionVisitor)this.setFieldNamingStrategyMatcher);
            this.gsonRuntimeSettings.setFieldNamingStrategy = this.setFieldNamingStrategyMatcher.isMatching();
        }
        if (!this.gsonRuntimeSettings.setExclusionStrategies) {
            instruction.accept(clazz, method, codeAttribute, offset, (InstructionVisitor)this.setExclusionStrategiesMatcher);
            this.gsonRuntimeSettings.setExclusionStrategies = this.setExclusionStrategiesMatcher.isMatching();
        }
        if (!this.gsonRuntimeSettings.addSerializationExclusionStrategy) {
            instruction.accept(clazz, method, codeAttribute, offset, (InstructionVisitor)this.addSerializationExclusionStrategyMatcher);
            this.gsonRuntimeSettings.addSerializationExclusionStrategy = this.addSerializationExclusionStrategyMatcher.isMatching();
        }
        if (!this.gsonRuntimeSettings.addDeserializationExclusionStrategy) {
            instruction.accept(clazz, method, codeAttribute, offset, (InstructionVisitor)this.addDeserializationExclusionStrategyMatcher);
            this.gsonRuntimeSettings.addDeserializationExclusionStrategy = this.addDeserializationExclusionStrategyMatcher.isMatching();
        }
        if (!this.gsonRuntimeSettings.serializeSpecialFloatingPointValues) {
            instruction.accept(clazz, method, codeAttribute, offset, (InstructionVisitor)this.serializeSpecialFloatingPointValuesMatcher);
            this.gsonRuntimeSettings.serializeSpecialFloatingPointValues = this.serializeSpecialFloatingPointValuesMatcher.isMatching();
        }
        if (!this.gsonRuntimeSettings.registerTypeAdapterFactory) {
            instruction.accept(clazz, method, codeAttribute, offset, (InstructionVisitor)this.registerTypeAdapterFactoryMatcher);
            this.gsonRuntimeSettings.registerTypeAdapterFactory = this.registerTypeAdapterFactoryMatcher.isMatching();
        }
        if (this.instanceCreatorClassVisitor != null && this.typeAdapterClassVisitor != null) {
            instruction.accept(clazz, method, codeAttribute, offset, (InstructionVisitor)this.registerTypeAdapterMatcher);
            instruction.accept(clazz, method, codeAttribute, offset, (InstructionVisitor)this.registerTypeHierachyAdapterMatcher);
            if (this.registerTypeAdapterMatcher.isMatching() || this.registerTypeHierachyAdapterMatcher.isMatching()) {
                this.lazyPartialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
                InstructionOffsetValue typeProducer = this.partialEvaluator.getStackBefore(offset).getTopActualProducerValue(1).instructionOffsetValue();
                TypeArgumentFinder typeArgumentFinder = new TypeArgumentFinder(this.programClassPool, this.libraryClassPool, this.partialEvaluator);
                for (int i = 0; i < typeProducer.instructionOffsetCount(); ++i) {
                    codeAttribute.instructionAccept(clazz, method, typeProducer.instructionOffset(i), (InstructionVisitor)typeArgumentFinder);
                }
                if (typeArgumentFinder.typeArgumentClasses != null && typeArgumentFinder.typeArgumentClasses.length == 1) {
                    String typeArgumentClass = typeArgumentFinder.typeArgumentClasses[0];
                    Clazz type = this.programClassPool.getClass(typeArgumentClass);
                    if (type == null) {
                        type = this.libraryClassPool.getClass(typeArgumentClass);
                    }
                    if (type != null) {
                        InstructionOffsetValue typeAdapterProducer = this.partialEvaluator.getStackBefore(offset).getTopActualProducerValue(0).instructionOffsetValue();
                        TypeArgumentFinder typeAdapterArgumentFinder = new TypeArgumentFinder(this.programClassPool, this.libraryClassPool, this.partialEvaluator);
                        for (int i = 0; i < typeAdapterProducer.instructionOffsetCount(); ++i) {
                            codeAttribute.instructionAccept(clazz, method, typeAdapterProducer.instructionOffset(i), (InstructionVisitor)typeAdapterArgumentFinder);
                        }
                        if (typeAdapterArgumentFinder.typeArgumentClasses != null && typeAdapterArgumentFinder.typeArgumentClasses.length == 1) {
                            String typeAdapterArgumentClass = typeAdapterArgumentFinder.typeArgumentClasses[0];
                            Clazz instanceCreator = this.programClassPool.getClass("com/google/gson/InstanceCreator");
                            ImplementedClassFilter implementsInstanceCreatorFilter = new ImplementedClassFilter(instanceCreator, false, (ClassVisitor)new ClassVisitorPropagator(type, this.instanceCreatorClassVisitor), (ClassVisitor)new ClassVisitorPropagator(type, this.typeAdapterClassVisitor));
                            this.programClassPool.classAccept(typeAdapterArgumentClass, (ClassVisitor)implementsInstanceCreatorFilter);
                            this.libraryClassPool.classAccept(typeAdapterArgumentClass, (ClassVisitor)implementsInstanceCreatorFilter);
                        }
                    }
                }
            }
        }
    }

    private static class ClassVisitorPropagator
    implements ClassVisitor {
        private final Clazz clazz;
        private final ClassVisitor classVisitor;

        private ClassVisitorPropagator(Clazz clazz, ClassVisitor classVisitor) {
            this.clazz = clazz;
            this.classVisitor = classVisitor;
        }

        public void visitAnyClass(Clazz clazz) {
        }

        public void visitProgramClass(ProgramClass programClass) {
            this.clazz.accept(this.classVisitor);
        }
    }
}

