/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import java.util.List;
import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinConstructorMetadata;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinMultiFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinMultiFilePartKindMetadata;
import proguard.classfile.kotlin.KotlinPropertyMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.KotlinTypeAliasMetadata;
import proguard.classfile.kotlin.KotlinTypeMetadata;
import proguard.classfile.kotlin.KotlinTypeParameterMetadata;
import proguard.classfile.kotlin.KotlinValueParameterMetadata;
import proguard.classfile.kotlin.KotlinVersionRequirementMetadata;
import proguard.classfile.kotlin.visitor.AllTypeVisitor;
import proguard.classfile.kotlin.visitor.KotlinConstructorVisitor;
import proguard.classfile.kotlin.visitor.KotlinContractVisitor;
import proguard.classfile.kotlin.visitor.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.KotlinPropertyVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeAliasVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeParameterVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeVisitor;
import proguard.classfile.kotlin.visitor.KotlinValueParameterVisitor;
import proguard.classfile.kotlin.visitor.KotlinVersionRequirementVisitor;
import proguard.classfile.visitor.MemberAccessFlagCleaner;
import proguard.classfile.visitor.MemberAccessSetter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.shrink.SimpleUsageMarker;
import proguard.util.Processable;

public class KotlinShrinker
implements KotlinMetadataVisitor,
KotlinPropertyVisitor,
KotlinFunctionVisitor,
KotlinTypeAliasVisitor,
KotlinTypeVisitor,
KotlinConstructorVisitor,
KotlinTypeParameterVisitor,
KotlinValueParameterVisitor,
KotlinVersionRequirementVisitor {
    private final SimpleUsageMarker usageMarker;

    KotlinShrinker(SimpleUsageMarker usageMarker) {
        this.usageMarker = usageMarker;
    }

    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
    }

    public void visitKotlinDeclarationContainerMetadata(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata) {
        this.shrinkMetadataArray(kotlinDeclarationContainerMetadata.properties);
        this.shrinkMetadataArray(kotlinDeclarationContainerMetadata.functions);
        this.shrinkMetadataArray(kotlinDeclarationContainerMetadata.typeAliases);
        this.shrinkMetadataArray(kotlinDeclarationContainerMetadata.localDelegatedProperties);
        kotlinDeclarationContainerMetadata.propertiesAccept(clazz, (KotlinPropertyVisitor)this);
        kotlinDeclarationContainerMetadata.functionsAccept(clazz, (KotlinFunctionVisitor)this);
        kotlinDeclarationContainerMetadata.typeAliasesAccept(clazz, (KotlinTypeAliasVisitor)this);
        kotlinDeclarationContainerMetadata.delegatedPropertiesAccept(clazz, (KotlinPropertyVisitor)this);
    }

    public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
        if (this.shouldShrinkMetadata(kotlinClassKindMetadata.companionObjectName, (Processable)kotlinClassKindMetadata.referencedCompanionClass)) {
            kotlinClassKindMetadata.companionObjectName = null;
            kotlinClassKindMetadata.referencedCompanionClass = null;
        }
        this.shrinkMetadataArray(kotlinClassKindMetadata.constructors);
        this.shrinkArray(kotlinClassKindMetadata.enumEntryNames, kotlinClassKindMetadata.referencedEnumEntries);
        this.shrinkArray(kotlinClassKindMetadata.nestedClassNames, kotlinClassKindMetadata.referencedNestedClasses);
        this.shrinkArray(kotlinClassKindMetadata.sealedSubclassNames, kotlinClassKindMetadata.referencedSealedSubClasses);
        this.visitKotlinDeclarationContainerMetadata(clazz, (KotlinDeclarationContainerMetadata)kotlinClassKindMetadata);
        kotlinClassKindMetadata.superTypesAccept(clazz, (KotlinTypeVisitor)this);
        kotlinClassKindMetadata.typeParametersAccept(clazz, (KotlinTypeParameterVisitor)this);
        kotlinClassKindMetadata.versionRequirementAccept(clazz, (KotlinVersionRequirementVisitor)this);
        kotlinClassKindMetadata.constructorsAccept(clazz, (KotlinConstructorVisitor)this);
        kotlinClassKindMetadata.inlineClassUnderlyingPropertyTypeAccept(clazz, (KotlinTypeVisitor)this);
    }

    public void visitKotlinFileFacadeMetadata(Clazz clazz, KotlinFileFacadeKindMetadata kotlinFileFacadeKindMetadata) {
        this.visitKotlinDeclarationContainerMetadata(clazz, (KotlinDeclarationContainerMetadata)kotlinFileFacadeKindMetadata);
    }

    public void visitKotlinSyntheticClassMetadata(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata) {
        this.shrinkMetadataArray(kotlinSyntheticClassKindMetadata.functions);
        kotlinSyntheticClassKindMetadata.functionsAccept(clazz, (KotlinFunctionVisitor)this);
    }

    public void visitKotlinMultiFileFacadeMetadata(Clazz clazz, KotlinMultiFileFacadeKindMetadata kotlinMultiFileFacadeKindMetadata) {
        this.shrinkArray(kotlinMultiFileFacadeKindMetadata.partClassNames, kotlinMultiFileFacadeKindMetadata.referencedPartClasses);
    }

    public void visitKotlinMultiFilePartMetadata(Clazz clazz, KotlinMultiFilePartKindMetadata kotlinMultiFilePartKindMetadata) {
        this.visitKotlinDeclarationContainerMetadata(clazz, (KotlinDeclarationContainerMetadata)kotlinMultiFilePartKindMetadata);
    }

    public void visitAnyProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
        kotlinPropertyMetadata.versionRequirementAccept(clazz, kotlinDeclarationContainerMetadata, (KotlinVersionRequirementVisitor)this);
        kotlinPropertyMetadata.typeAccept(clazz, kotlinDeclarationContainerMetadata, (KotlinTypeVisitor)this);
        kotlinPropertyMetadata.setterParametersAccept(clazz, kotlinDeclarationContainerMetadata, (KotlinValueParameterVisitor)this);
        kotlinPropertyMetadata.receiverTypeAccept(clazz, kotlinDeclarationContainerMetadata, (KotlinTypeVisitor)this);
        kotlinPropertyMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, (KotlinTypeParameterVisitor)this);
        if (this.shouldShrinkMetadata(kotlinPropertyMetadata.backingFieldSignature, (Processable)kotlinPropertyMetadata.referencedBackingField)) {
            kotlinPropertyMetadata.backingFieldSignature = null;
            kotlinPropertyMetadata.referencedBackingField = null;
        }
        if (this.shouldShrinkMetadata(kotlinPropertyMetadata.getterSignature, (Processable)kotlinPropertyMetadata.referencedGetterMethod)) {
            kotlinPropertyMetadata.getterSignature = null;
            kotlinPropertyMetadata.referencedGetterMethod = null;
            kotlinPropertyMetadata.flags.hasGetter = false;
        }
        if (this.shouldShrinkMetadata(kotlinPropertyMetadata.setterSignature, (Processable)kotlinPropertyMetadata.referencedSetterMethod)) {
            kotlinPropertyMetadata.setterSignature = null;
            kotlinPropertyMetadata.referencedSetterMethod = null;
            kotlinPropertyMetadata.flags.hasSetter = false;
            kotlinPropertyMetadata.setterParameters.clear();
        }
        kotlinPropertyMetadata.versionRequirementAccept(clazz, kotlinDeclarationContainerMetadata, (KotlinVersionRequirementVisitor)this);
        if (kotlinPropertyMetadata.syntheticMethodForAnnotations != null && !this.usageMarker.isUsed((Processable)kotlinPropertyMetadata.referencedSyntheticMethodForAnnotations)) {
            kotlinPropertyMetadata.syntheticMethodForAnnotations = null;
            kotlinPropertyMetadata.referencedSyntheticMethodForAnnotations = null;
            kotlinPropertyMetadata.referencedSyntheticMethodClass = null;
            kotlinPropertyMetadata.flags.common.hasAnnotations = false;
        }
        if (kotlinPropertyMetadata.syntheticMethodForDelegate != null && !this.usageMarker.isUsed((Processable)kotlinPropertyMetadata.referencedSyntheticMethodForDelegateMethod)) {
            kotlinPropertyMetadata.syntheticMethodForDelegate = null;
            kotlinPropertyMetadata.referencedSyntheticMethodForDelegateClass = null;
            kotlinPropertyMetadata.referencedSyntheticMethodForDelegateMethod = null;
        }
        if (kotlinPropertyMetadata.referencedBackingField != null && kotlinPropertyMetadata.getterSignature == null && kotlinPropertyMetadata.setterSignature == null && (kotlinPropertyMetadata.referencedBackingField.getAccessFlags() & 2) != 0 && !kotlinPropertyMetadata.flags.visibility.isPrivate) {
            int visibility = kotlinPropertyMetadata.flags.visibility.isProtected ? 4 : 1;
            kotlinPropertyMetadata.referencedBackingField.accept(kotlinPropertyMetadata.referencedBackingFieldClass, (MemberVisitor)new MultiMemberVisitor(new MemberVisitor[]{new MemberAccessFlagCleaner(2), new MemberAccessSetter(visibility)}));
        }
    }

    public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        if (kotlinFunctionMetadata.referencedLambdaClassOrigin != null && this.shouldShrinkMetadata(kotlinFunctionMetadata.lambdaClassOriginName, (Processable)kotlinFunctionMetadata.referencedLambdaClassOrigin)) {
            kotlinFunctionMetadata.lambdaClassOriginName = null;
            kotlinFunctionMetadata.referencedLambdaClassOrigin = null;
        }
        kotlinFunctionMetadata.receiverTypeAccept(clazz, kotlinMetadata, (KotlinTypeVisitor)this);
        kotlinFunctionMetadata.typeParametersAccept(clazz, kotlinMetadata, (KotlinTypeParameterVisitor)this);
        kotlinFunctionMetadata.valueParametersAccept(clazz, kotlinMetadata, (KotlinValueParameterVisitor)this);
        kotlinFunctionMetadata.returnTypeAccept(clazz, kotlinMetadata, (KotlinTypeVisitor)this);
        kotlinFunctionMetadata.contractsAccept(clazz, kotlinMetadata, (KotlinContractVisitor)new AllTypeVisitor((KotlinTypeVisitor)this));
        if (kotlinFunctionMetadata.referencedDefaultMethod != null && !this.usageMarker.isUsed((Processable)kotlinFunctionMetadata.referencedDefaultMethod)) {
            kotlinFunctionMetadata.referencedDefaultMethod = null;
            kotlinFunctionMetadata.referencedDefaultMethodClass = null;
        }
        if (kotlinFunctionMetadata.referencedDefaultImplementationMethod != null && !this.usageMarker.isUsed((Processable)kotlinFunctionMetadata.referencedDefaultImplementationMethod)) {
            kotlinFunctionMetadata.referencedDefaultImplementationMethod = null;
            kotlinFunctionMetadata.referencedDefaultImplementationMethodClass = null;
        }
        if (!kotlinFunctionMetadata.flags.modality.isAbstract && kotlinMetadata.k == 1 && ((KotlinClassKindMetadata)kotlinMetadata).flags.isInterface && kotlinFunctionMetadata.referencedDefaultImplementationMethod == null) {
            kotlinFunctionMetadata.flags.modality.isAbstract = true;
        }
    }

    public void visitConstructor(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinConstructorMetadata kotlinConstructorMetadata) {
        kotlinConstructorMetadata.valueParametersAccept(clazz, kotlinClassKindMetadata, (KotlinValueParameterVisitor)this);
        kotlinConstructorMetadata.versionRequirementAccept(clazz, (KotlinMetadata)kotlinClassKindMetadata, (KotlinVersionRequirementVisitor)this);
    }

    public void visitTypeAlias(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata) {
        kotlinTypeAliasMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, (KotlinTypeParameterVisitor)this);
        kotlinTypeAliasMetadata.underlyingTypeAccept(clazz, kotlinDeclarationContainerMetadata, (KotlinTypeVisitor)this);
        kotlinTypeAliasMetadata.expandedTypeAccept(clazz, kotlinDeclarationContainerMetadata, (KotlinTypeVisitor)this);
        kotlinTypeAliasMetadata.versionRequirementAccept(clazz, (KotlinMetadata)kotlinDeclarationContainerMetadata, (KotlinVersionRequirementVisitor)this);
        this.shrinkMetadataArray(kotlinTypeAliasMetadata.annotations);
    }

    public void visitAnyType(Clazz clazz, KotlinTypeMetadata kotlinTypeMetadata) {
        kotlinTypeMetadata.typeArgumentsAccept(clazz, (KotlinTypeVisitor)this);
        kotlinTypeMetadata.upperBoundsAccept(clazz, (KotlinTypeVisitor)this);
        kotlinTypeMetadata.abbreviationAccept(clazz, (KotlinTypeVisitor)this);
        this.shrinkMetadataArray(kotlinTypeMetadata.annotations);
    }

    public void visitAnyTypeParameter(Clazz clazz, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
        kotlinTypeParameterMetadata.upperBoundsAccept(clazz, (KotlinTypeVisitor)this);
        this.shrinkMetadataArray(kotlinTypeParameterMetadata.annotations);
    }

    public void visitAnyValueParameter(Clazz clazz, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
    }

    public void visitFunctionValParameter(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
        kotlinValueParameterMetadata.typeAccept(clazz, kotlinMetadata, kotlinFunctionMetadata, (KotlinTypeVisitor)this);
        if (kotlinValueParameterMetadata.flags.hasDefaultValue && !this.usageMarker.isUsed((Processable)kotlinFunctionMetadata.referencedDefaultMethod)) {
            kotlinValueParameterMetadata.flags.hasDefaultValue = false;
        }
    }

    public void visitConstructorValParameter(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinConstructorMetadata kotlinConstructorMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
        kotlinValueParameterMetadata.typeAccept(clazz, kotlinClassKindMetadata, kotlinConstructorMetadata, (KotlinTypeVisitor)this);
    }

    public void visitPropertyValParameter(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
        kotlinValueParameterMetadata.typeAccept(clazz, kotlinDeclarationContainerMetadata, kotlinPropertyMetadata, (KotlinTypeVisitor)this);
    }

    public void visitAnyVersionRequirement(Clazz clazz, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
    }

    private boolean shouldShrinkMetadata(Object metadataElement, Processable jvmElement) {
        return metadataElement != null && !this.usageMarker.isUsed(jvmElement);
    }

    private void shrinkArray(List<?> elements, List<? extends Processable> referencedJavaElements) {
        KotlinShrinker.shrinkArray(this.usageMarker, elements, referencedJavaElements);
    }

    static void shrinkArray(SimpleUsageMarker usageMarker, List<?> elements, List<? extends Processable> referencedJavaElements) {
        for (int k = elements.size() - 1; k >= 0; --k) {
            if (usageMarker.isUsed(referencedJavaElements.get(k))) continue;
            elements.remove(k);
            referencedJavaElements.remove(k);
        }
    }

    private void shrinkMetadataArray(List<? extends Processable> elements) {
        for (int k = elements.size() - 1; k >= 0; --k) {
            if (this.usageMarker.isUsed(elements.get(k))) continue;
            elements.remove(k);
        }
    }
}

