/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate.kotlin;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.visitor.KotlinClassToDefaultImplsClassVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.ProgramClassFilter;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.MemberObfuscator;

public class KotlinSyntheticClassFixer
implements KotlinMetadataVisitor {
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
    }

    public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
        if (kotlinClassKindMetadata.referencedDefaultImplsClass != null) {
            String className = ClassObfuscator.newClassName(kotlinClassKindMetadata.referencedClass);
            String defaultImplsClassName = className.endsWith("$DefaultImpls") ? className : className + "$DefaultImpls";
            kotlinClassKindMetadata.accept(clazz, (KotlinMetadataVisitor)new KotlinClassToDefaultImplsClassVisitor((ClassVisitor)new ProgramClassFilter(_clazz -> ClassObfuscator.setNewClassName(_clazz, defaultImplsClassName))));
        }
    }

    public void visitKotlinSyntheticClassMetadata(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata) {
        if (kotlinSyntheticClassKindMetadata.flavor == KotlinSyntheticClassKindMetadata.Flavor.WHEN_MAPPINGS) {
            String originalName = ClassObfuscator.newClassName(clazz);
            if (!originalName.endsWith("$WhenMappings")) {
                ClassObfuscator.setNewClassName(clazz, originalName + "$WhenMappings");
            }
        } else if (kotlinSyntheticClassKindMetadata.flavor == KotlinSyntheticClassKindMetadata.Flavor.LAMBDA) {
            clazz.accept((ClassVisitor)new AllFieldVisitor((MemberVisitor)new MemberNameFilter("$*", new MemberVisitor(){

                public void visitProgramField(ProgramClass programClass, ProgramField programField) {
                    MemberObfuscator.setNewMemberName((Member)programField, "$" + MemberObfuscator.newMemberName((Member)programField));
                }

                public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
                }

                public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
                }

                public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
                }
            })));
        }
    }
}

