/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.json;

import com.graphhopper.json.MinMax;

public class Statement {
    private final Keyword keyword;
    private final String condition;
    private final Op operation;
    private final String value;

    private Statement(Keyword keyword, String condition, Op operation, String value) {
        this.keyword = keyword;
        this.condition = condition;
        this.value = value;
        this.operation = operation;
    }

    public Keyword getKeyword() {
        return this.keyword;
    }

    public String getCondition() {
        return this.condition;
    }

    public Op getOperation() {
        return this.operation;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "{" + this.str(this.keyword.getName()) + ": " + this.str(this.condition) + ", " + this.str(this.operation.getName()) + ": " + this.value + "}";
    }

    private String str(String str) {
        return "\"" + str + "\"";
    }

    public static Statement If(String expression, Op op, String value) {
        return new Statement(Keyword.IF, expression, op, value);
    }

    public static Statement ElseIf(String expression, Op op, String value) {
        return new Statement(Keyword.ELSEIF, expression, op, value);
    }

    public static Statement Else(Op op, String value) {
        return new Statement(Keyword.ELSE, null, op, value);
    }

    public static enum Op {
        MULTIPLY("multiply_by"),
        LIMIT("limit_to");

        String name;

        private Op(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String build(String value) {
            switch (this) {
                case MULTIPLY: {
                    return "value *= " + value;
                }
                case LIMIT: {
                    return "value = Math.min(value," + value + ")";
                }
            }
            throw new IllegalArgumentException();
        }

        public MinMax apply(MinMax minMax1, MinMax minMax2) {
            switch (this) {
                case MULTIPLY: {
                    return new MinMax(minMax1.min * minMax2.min, minMax1.max * minMax2.max);
                }
                case LIMIT: {
                    return new MinMax(Math.min(minMax1.min, minMax2.min), Math.min(minMax1.max, minMax2.max));
                }
            }
            throw new IllegalArgumentException();
        }
    }

    public static enum Keyword {
        IF("if"),
        ELSEIF("else_if"),
        ELSE("else");

        String name;

        private Keyword(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

