/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage.index;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntHashSet;
import com.graphhopper.geohash.SpatialKeyAlgo;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.index.InMemConstructionIndex;
import com.graphhopper.storage.index.IndexStructureInfo;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.shapes.BBox;
import java.util.function.IntConsumer;

public class LineIntIndex {
    static final int START_POINTER = 1;
    final DataAccess dataAccess;
    private final BBox bounds;
    private int minResolutionInMeter = 300;
    private int size;
    private int leafs;
    private int checksum;
    private IndexStructureInfo indexStructureInfo;
    private int[] entries;
    private byte[] shifts;
    private boolean initialized = false;
    private SpatialKeyAlgo keyAlgo;

    public LineIntIndex(BBox bBox, Directory dir, String name) {
        this.bounds = bBox;
        this.dataAccess = dir.create(name, dir.getDefaultType(name, true));
    }

    public boolean loadExisting() {
        if (this.initialized) {
            throw new IllegalStateException("Call loadExisting only once");
        }
        if (!this.dataAccess.loadExisting()) {
            return false;
        }
        GHUtility.checkDAVersion("location_index", 5, this.dataAccess.getHeader(0));
        this.checksum = this.dataAccess.getHeader(4);
        this.minResolutionInMeter = this.dataAccess.getHeader(8);
        this.indexStructureInfo = IndexStructureInfo.create(this.bounds, this.minResolutionInMeter);
        this.keyAlgo = this.indexStructureInfo.getKeyAlgo();
        this.entries = this.indexStructureInfo.getEntries();
        this.shifts = this.indexStructureInfo.getShifts();
        this.initialized = true;
        return true;
    }

    public void store(InMemConstructionIndex inMem) {
        this.indexStructureInfo = IndexStructureInfo.create(this.bounds, this.minResolutionInMeter);
        this.keyAlgo = this.indexStructureInfo.getKeyAlgo();
        this.entries = this.indexStructureInfo.getEntries();
        this.shifts = this.indexStructureInfo.getShifts();
        this.dataAccess.create(65536L);
        try {
            this.store(inMem.root, 1);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Problem while storing location index. " + Helper.getMemInfo(), ex);
        }
        this.initialized = true;
    }

    private int store(InMemConstructionIndex.InMemEntry entry, int intPointer) {
        long pointer = (long)intPointer * 4L;
        if (entry.isLeaf()) {
            InMemConstructionIndex.InMemLeafEntry leaf = (InMemConstructionIndex.InMemLeafEntry)entry;
            IntArrayList entries = leaf.getResults();
            int len = entries.size();
            if (len == 0) {
                return intPointer;
            }
            this.size += len;
            ++this.leafs;
            this.dataAccess.ensureCapacity((long)(++intPointer + len + 1) * 4L);
            if (len == 1) {
                this.dataAccess.setInt(pointer, -entries.get(0) - 1);
            } else {
                int index = 0;
                while (index < len) {
                    this.dataAccess.setInt((long)intPointer * 4L, entries.get(index));
                    ++index;
                    ++intPointer;
                }
                this.dataAccess.setInt(pointer, intPointer);
            }
        } else {
            InMemConstructionIndex.InMemTreeEntry treeEntry = (InMemConstructionIndex.InMemTreeEntry)entry;
            int len = treeEntry.subEntries.length;
            intPointer += len;
            int subCounter = 0;
            while (subCounter < len) {
                InMemConstructionIndex.InMemEntry subEntry = treeEntry.subEntries[subCounter];
                if (subEntry != null) {
                    this.dataAccess.ensureCapacity((long)(intPointer + 1) * 4L);
                    int prevIntPointer = intPointer;
                    intPointer = this.store(subEntry, prevIntPointer);
                    if (intPointer == prevIntPointer) {
                        this.dataAccess.setInt(pointer, 0);
                    } else {
                        this.dataAccess.setInt(pointer, prevIntPointer);
                    }
                }
                ++subCounter;
                pointer += 4L;
            }
        }
        return intPointer;
    }

    private void fillIDs(long keyPart, IntConsumer consumer) {
        int intPointer = 1;
        for (int depth = 0; depth < this.entries.length; ++depth) {
            int offset = (int)(keyPart >>> 64 - this.shifts[depth]);
            int nextIntPointer = this.dataAccess.getInt((long)(intPointer + offset) * 4L);
            if (nextIntPointer <= 0) {
                return;
            }
            keyPart <<= this.shifts[depth];
            intPointer = nextIntPointer;
        }
        int data = this.dataAccess.getInt((long)intPointer * 4L);
        if (data < 0) {
            int edgeId = -(data + 1);
            consumer.accept(edgeId);
        } else {
            for (int leafIndex = intPointer + 1; leafIndex < data; ++leafIndex) {
                int edgeId = this.dataAccess.getInt((long)leafIndex * 4L);
                consumer.accept(edgeId);
            }
        }
    }

    public void query(BBox queryShape, final LocationIndex.Visitor function) {
        final IntHashSet set = new IntHashSet();
        this.query(1, queryShape, this.bounds.minLat, this.bounds.minLon, this.bounds.maxLat - this.bounds.minLat, this.bounds.maxLon - this.bounds.minLon, new LocationIndex.Visitor(){

            @Override
            public boolean isTileInfo() {
                return function.isTileInfo();
            }

            @Override
            public void onTile(BBox bbox, int width) {
                function.onTile(bbox, width);
            }

            @Override
            public void onEdge(int edgeId) {
                if (set.add(edgeId)) {
                    function.onEdge(edgeId);
                }
            }
        }, 0);
    }

    private void query(int intPointer, BBox queryBBox, double minLat, double minLon, double deltaLatPerDepth, double deltaLonPerDepth, LocationIndex.Visitor function, int depth) {
        long pointer = (long)intPointer * 4L;
        if (depth == this.entries.length) {
            int nextIntPointer = this.dataAccess.getInt(pointer);
            if (nextIntPointer < 0) {
                function.onEdge(-(nextIntPointer + 1));
            } else {
                long maxPointer = (long)nextIntPointer * 4L;
                for (long leafPointer = pointer + 4L; leafPointer < maxPointer; leafPointer += 4L) {
                    function.onEdge(this.dataAccess.getInt(leafPointer));
                }
            }
            return;
        }
        int max = 1 << this.shifts[depth];
        int factor = max == 4 ? 2 : 4;
        deltaLonPerDepth /= (double)factor;
        deltaLatPerDepth /= (double)factor;
        for (int cellIndex = 0; cellIndex < max; ++cellIndex) {
            BBox bbox;
            int nextIntPointer = this.dataAccess.getInt(pointer + (long)(cellIndex * 4));
            if (nextIntPointer <= 0) continue;
            int[] pixelXY = this.keyAlgo.decode(cellIndex);
            double tmpMinLon = minLon + deltaLonPerDepth * (double)pixelXY[0];
            double tmpMinLat = minLat + deltaLatPerDepth * (double)pixelXY[1];
            BBox bBox = bbox = queryBBox != null || function.isTileInfo() ? new BBox(tmpMinLon, tmpMinLon + deltaLonPerDepth, tmpMinLat, tmpMinLat + deltaLatPerDepth) : null;
            if (function.isTileInfo()) {
                function.onTile(bbox, depth);
            }
            if (queryBBox == null || queryBBox.contains(bbox)) {
                this.query(nextIntPointer, null, tmpMinLat, tmpMinLon, deltaLatPerDepth, deltaLonPerDepth, function, depth + 1);
                continue;
            }
            if (!queryBBox.intersects(bbox)) continue;
            this.query(nextIntPointer, queryBBox, tmpMinLat, tmpMinLon, deltaLatPerDepth, deltaLonPerDepth, function, depth + 1);
        }
    }

    public void findEdgeIdsInNeighborhood(double queryLat, double queryLon, int iteration, IntConsumer foundEntries) {
        long keyPart;
        int x = this.keyAlgo.x(queryLon);
        int y = this.keyAlgo.y(queryLat);
        for (int yreg = -iteration; yreg <= iteration; ++yreg) {
            int subqueryY = y + yreg;
            int subqueryXA = x - iteration;
            int subqueryXB = x + iteration;
            if (subqueryXA >= 0 && subqueryY >= 0 && subqueryXA < this.indexStructureInfo.getParts() && subqueryY < this.indexStructureInfo.getParts()) {
                keyPart = this.keyAlgo.encode(subqueryXA, subqueryY) << 64 - this.keyAlgo.getBits();
                this.fillIDs(keyPart, foundEntries);
            }
            if (iteration <= 0 || subqueryXB < 0 || subqueryY < 0 || subqueryXB >= this.indexStructureInfo.getParts() || subqueryY >= this.indexStructureInfo.getParts()) continue;
            keyPart = this.keyAlgo.encode(subqueryXB, subqueryY) << 64 - this.keyAlgo.getBits();
            this.fillIDs(keyPart, foundEntries);
        }
        for (int xreg = -iteration + 1; xreg <= iteration - 1; ++xreg) {
            int subqueryX = x + xreg;
            int subqueryYA = y - iteration;
            int subqueryYB = y + iteration;
            if (subqueryX >= 0 && subqueryYA >= 0 && subqueryX < this.indexStructureInfo.getParts() && subqueryYA < this.indexStructureInfo.getParts()) {
                keyPart = this.keyAlgo.encode(subqueryX, subqueryYA) << 64 - this.keyAlgo.getBits();
                this.fillIDs(keyPart, foundEntries);
            }
            if (subqueryX < 0 || subqueryYB < 0 || subqueryX >= this.indexStructureInfo.getParts() || subqueryYB >= this.indexStructureInfo.getParts()) continue;
            keyPart = this.keyAlgo.encode(subqueryX, subqueryYB) << 64 - this.keyAlgo.getBits();
            this.fillIDs(keyPart, foundEntries);
        }
    }

    public int getChecksum() {
        return this.checksum;
    }

    public int getMinResolutionInMeter() {
        return this.minResolutionInMeter;
    }

    public void setMinResolutionInMeter(int minResolutionInMeter) {
        this.minResolutionInMeter = minResolutionInMeter;
    }

    public void flush() {
        this.dataAccess.setHeader(0, 5);
        this.dataAccess.setHeader(4, this.checksum);
        this.dataAccess.setHeader(8, this.minResolutionInMeter);
        this.dataAccess.flush();
    }

    public void close() {
        this.dataAccess.close();
    }

    public boolean isClosed() {
        return this.dataAccess.isClosed();
    }

    public long getCapacity() {
        return this.dataAccess.getCapacity();
    }

    public void setChecksum(int checksum) {
        this.checksum = checksum;
    }

    public int getSize() {
        return this.size;
    }

    public int getLeafs() {
        return this.leafs;
    }
}

