/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.JsonFeature;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.Polygon;
import java.util.Map;

public class CustomWeightingHelper {
    protected DecimalEncodedValue avg_speed_enc;
    protected DecimalEncodedValue priority_enc;

    protected CustomWeightingHelper() {
    }

    public void init(EncodedValueLookup lookup, DecimalEncodedValue avgSpeedEnc, DecimalEncodedValue priorityEnc, Map<String, JsonFeature> areas) {
        this.avg_speed_enc = avgSpeedEnc;
        this.priority_enc = priorityEnc;
    }

    public double getPriority(EdgeIteratorState edge, boolean reverse) {
        return 1.0;
    }

    public double getSpeed(EdgeIteratorState edge, boolean reverse) {
        return this.getRawSpeed(edge, reverse);
    }

    protected final double getRawSpeed(EdgeIteratorState edge, boolean reverse) {
        double speed;
        double d = speed = reverse ? edge.getReverse(this.avg_speed_enc) : edge.get(this.avg_speed_enc);
        if (Double.isInfinite(speed) || Double.isNaN(speed) || speed < 0.0) {
            throw new IllegalStateException("Invalid estimated speed " + speed);
        }
        return speed;
    }

    protected final double getRawPriority(EdgeIteratorState edge, boolean reverse) {
        double priority;
        if (this.priority_enc == null) {
            return 1.0;
        }
        double d = priority = reverse ? edge.getReverse(this.priority_enc) : edge.get(this.priority_enc);
        if (Double.isInfinite(priority) || Double.isNaN(priority) || priority < 0.0) {
            throw new IllegalStateException("Invalid priority " + priority);
        }
        return priority;
    }

    protected double getMaxPriority() {
        return 1.0;
    }

    protected double getMaxSpeed() {
        return 1.0;
    }

    public static boolean in(Polygon p, EdgeIteratorState edge) {
        BBox bbox = GHUtility.createBBox(edge);
        if (!p.getBounds().intersects(bbox)) {
            return false;
        }
        if (p.isRectangle()) {
            return true;
        }
        return p.intersects(edge.fetchWayGeometry(FetchMode.ALL).makeImmutable());
    }
}

