/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.osm.OSMTurnRestriction;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.util.AccessFilter;
import com.graphhopper.routing.util.parsers.TurnCostParser;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import java.util.List;

public class OSMTurnRestrictionParser
implements TurnCostParser {
    private final BooleanEncodedValue accessEnc;
    private final DecimalEncodedValue turnCostEnc;
    private final List<String> restrictions;
    private EdgeExplorer cachedOutExplorer;
    private EdgeExplorer cachedInExplorer;

    public OSMTurnRestrictionParser(BooleanEncodedValue accessEnc, DecimalEncodedValue turnCostEnc, List<String> restrictions) {
        if (restrictions.isEmpty()) {
            throw new IllegalArgumentException("restrictions cannot be empty");
        }
        this.accessEnc = accessEnc;
        this.turnCostEnc = turnCostEnc;
        this.restrictions = restrictions;
    }

    @Override
    public void handleTurnRestrictionTags(OSMTurnRestriction turnRestriction, TurnCostParser.ExternalInternalMap map, Graph graph) {
        if (!turnRestriction.isVehicleTypeConcernedByTurnRestriction(this.restrictions)) {
            return;
        }
        this.addRelationToTCStorage(turnRestriction, map, graph);
    }

    private EdgeExplorer getInExplorer(Graph graph) {
        return this.cachedInExplorer == null ? (this.cachedInExplorer = graph.createEdgeExplorer(AccessFilter.inEdges(this.accessEnc))) : this.cachedInExplorer;
    }

    private EdgeExplorer getOutExplorer(Graph graph) {
        return this.cachedOutExplorer == null ? (this.cachedOutExplorer = graph.createEdgeExplorer(AccessFilter.outEdges(this.accessEnc))) : this.cachedOutExplorer;
    }

    void addRelationToTCStorage(OSMTurnRestriction osmTurnRestriction, TurnCostParser.ExternalInternalMap map, Graph graph) {
        TurnCostStorage tcs = graph.getTurnCostStorage();
        int viaNode = map.getInternalNodeIdOfOsmNode(osmTurnRestriction.getViaOsmNodeId());
        EdgeExplorer edgeOutExplorer = this.getOutExplorer(graph);
        EdgeExplorer edgeInExplorer = this.getInExplorer(graph);
        try {
            int edgeIdFrom = -1;
            EdgeIterator iter = edgeInExplorer.setBaseNode(viaNode);
            while (iter.next()) {
                if (map.getOsmIdOfInternalEdge(iter.getEdge()) != osmTurnRestriction.getOsmIdFrom()) continue;
                edgeIdFrom = iter.getEdge();
                break;
            }
            if (!EdgeIterator.Edge.isValid(edgeIdFrom)) {
                return;
            }
            iter = edgeOutExplorer.setBaseNode(viaNode);
            while (iter.next()) {
                int edgeId = iter.getEdge();
                long wayId = map.getOsmIdOfInternalEdge(edgeId);
                if ((edgeId == edgeIdFrom || osmTurnRestriction.getRestriction() != OSMTurnRestriction.RestrictionType.ONLY || wayId == osmTurnRestriction.getOsmIdTo()) && (osmTurnRestriction.getRestriction() != OSMTurnRestriction.RestrictionType.NOT || wayId != osmTurnRestriction.getOsmIdTo() || wayId < 0L)) continue;
                tcs.set(this.turnCostEnc, edgeIdFrom, viaNode, iter.getEdge(), Double.POSITIVE_INFINITY);
                if (osmTurnRestriction.getRestriction() != OSMTurnRestriction.RestrictionType.NOT) continue;
                break;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not built turn table entry for relation of node with osmId:" + osmTurnRestriction.getViaOsmNodeId(), e);
        }
    }

    @Override
    public String getName() {
        return this.turnCostEnc.getName();
    }

    public String toString() {
        return this.getName();
    }
}

