/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;

public class OSMMtbRatingParser
implements TagParser {
    private final IntEncodedValue mtbRatingEnc;

    public OSMMtbRatingParser(IntEncodedValue mtbRatingEnc) {
        this.mtbRatingEnc = mtbRatingEnc;
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay readerWay, IntsRef relationFlags) {
        String scale = readerWay.getTag("mtb:scale");
        int rating = 0;
        if (scale != null) {
            if (scale.length() == 2 && (scale.charAt(1) == '+' || scale.charAt(1) == '-')) {
                scale = scale.substring(0, 1);
            }
            try {
                int scaleAsInt = Integer.parseInt(scale);
                rating = scaleAsInt + 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (rating > 0 && rating < 8) {
            this.mtbRatingEnc.setInt(false, edgeFlags, rating);
        }
        return edgeFlags;
    }
}

