/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.parsers.RelationTagParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.Helper;

public class OSMBikeNetworkTagParser
implements RelationTagParser {
    private final EnumEncodedValue<RouteNetwork> bikeRouteEnc;
    private final EnumEncodedValue<RouteNetwork> transformerRouteRelEnc = new EnumEncodedValue<RouteNetwork>(EncodingManager.getKey("bike", "route_relation"), RouteNetwork.class);

    public OSMBikeNetworkTagParser(EnumEncodedValue<RouteNetwork> bikeRouteEnc, EncodedValue.InitializerConfig relConfig) {
        this.bikeRouteEnc = bikeRouteEnc;
        this.transformerRouteRelEnc.init(relConfig);
    }

    @Override
    public IntsRef handleRelationTags(IntsRef relFlags, ReaderRelation relation) {
        RouteNetwork oldBikeNetwork = this.transformerRouteRelEnc.getEnum(false, relFlags);
        if (relation.hasTag("route", (Object)"bicycle")) {
            String tag = Helper.toLowerCase((String)relation.getTag("network", ""));
            RouteNetwork newBikeNetwork = RouteNetwork.LOCAL;
            if ("lcn".equals(tag)) {
                newBikeNetwork = RouteNetwork.LOCAL;
            } else if ("rcn".equals(tag)) {
                newBikeNetwork = RouteNetwork.REGIONAL;
            } else if ("ncn".equals(tag)) {
                newBikeNetwork = RouteNetwork.NATIONAL;
            } else if ("icn".equals(tag)) {
                newBikeNetwork = RouteNetwork.INTERNATIONAL;
            }
            if (oldBikeNetwork == RouteNetwork.MISSING || oldBikeNetwork.ordinal() > newBikeNetwork.ordinal()) {
                this.transformerRouteRelEnc.setEnum(false, relFlags, newBikeNetwork);
            }
        }
        return relFlags;
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, IntsRef relationFlags) {
        RouteNetwork routeNetwork = this.transformerRouteRelEnc.getEnum(false, relationFlags);
        this.bikeRouteEnc.setEnum(false, edgeFlags, routeNetwork);
        return edgeFlags;
    }
}

