/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.routing.ev.Country;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.Hazmat;
import com.graphhopper.routing.ev.HazmatTunnel;
import com.graphhopper.routing.ev.HazmatWater;
import com.graphhopper.routing.ev.Hgv;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.routing.ev.Smoothness;
import com.graphhopper.routing.ev.Surface;
import com.graphhopper.routing.ev.Toll;
import com.graphhopper.routing.ev.TrackType;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.parsers.CountryParser;
import com.graphhopper.routing.util.parsers.OSMHazmatParser;
import com.graphhopper.routing.util.parsers.OSMHazmatTunnelParser;
import com.graphhopper.routing.util.parsers.OSMHazmatWaterParser;
import com.graphhopper.routing.util.parsers.OSMHgvParser;
import com.graphhopper.routing.util.parsers.OSMHikeRatingParser;
import com.graphhopper.routing.util.parsers.OSMHorseRatingParser;
import com.graphhopper.routing.util.parsers.OSMLanesParser;
import com.graphhopper.routing.util.parsers.OSMMaxAxleLoadParser;
import com.graphhopper.routing.util.parsers.OSMMaxHeightParser;
import com.graphhopper.routing.util.parsers.OSMMaxLengthParser;
import com.graphhopper.routing.util.parsers.OSMMaxSpeedParser;
import com.graphhopper.routing.util.parsers.OSMMaxWeightParser;
import com.graphhopper.routing.util.parsers.OSMMaxWidthParser;
import com.graphhopper.routing.util.parsers.OSMMtbRatingParser;
import com.graphhopper.routing.util.parsers.OSMRoadAccessParser;
import com.graphhopper.routing.util.parsers.OSMRoadClassLinkParser;
import com.graphhopper.routing.util.parsers.OSMRoadClassParser;
import com.graphhopper.routing.util.parsers.OSMRoadEnvironmentParser;
import com.graphhopper.routing.util.parsers.OSMRoundaboutParser;
import com.graphhopper.routing.util.parsers.OSMSmoothnessParser;
import com.graphhopper.routing.util.parsers.OSMSurfaceParser;
import com.graphhopper.routing.util.parsers.OSMTollParser;
import com.graphhopper.routing.util.parsers.OSMTrackTypeParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.parsers.TagParserFactory;
import com.graphhopper.util.Helper;

public class DefaultTagParserFactory
implements TagParserFactory {
    @Override
    public TagParser create(EncodedValueLookup lookup, String name) {
        if (!(name = name.trim()).equals(Helper.toLowerCase((String)name))) {
            throw new IllegalArgumentException("Use lower case for TagParsers: " + name);
        }
        if ("roundabout".equals(name)) {
            return new OSMRoundaboutParser(lookup.getBooleanEncodedValue("roundabout"));
        }
        if (name.equals("road_class")) {
            return new OSMRoadClassParser(lookup.getEnumEncodedValue("road_class", RoadClass.class));
        }
        if (name.equals("road_class_link")) {
            return new OSMRoadClassLinkParser(lookup.getBooleanEncodedValue("road_class_link"));
        }
        if (name.equals("road_environment")) {
            return new OSMRoadEnvironmentParser(lookup.getEnumEncodedValue("road_environment", RoadEnvironment.class));
        }
        if (name.equals("road_access")) {
            return new OSMRoadAccessParser(lookup.getEnumEncodedValue("road_access", RoadAccess.class), OSMRoadAccessParser.toOSMRestrictions(TransportationMode.CAR));
        }
        if (name.equals("max_speed")) {
            return new OSMMaxSpeedParser(lookup.getDecimalEncodedValue("max_speed"));
        }
        if (name.equals("max_weight")) {
            return new OSMMaxWeightParser(lookup.getDecimalEncodedValue("max_weight"));
        }
        if (name.equals("max_height")) {
            return new OSMMaxHeightParser(lookup.getDecimalEncodedValue("max_height"));
        }
        if (name.equals("max_width")) {
            return new OSMMaxWidthParser(lookup.getDecimalEncodedValue("max_width"));
        }
        if (name.equals("max_axle_load")) {
            return new OSMMaxAxleLoadParser(lookup.getDecimalEncodedValue("max_axle_load"));
        }
        if (name.equals("max_length")) {
            return new OSMMaxLengthParser(lookup.getDecimalEncodedValue("max_length"));
        }
        if (name.equals("surface")) {
            return new OSMSurfaceParser(lookup.getEnumEncodedValue("surface", Surface.class));
        }
        if (name.equals("smoothness")) {
            return new OSMSmoothnessParser(lookup.getEnumEncodedValue("smoothness", Smoothness.class));
        }
        if (name.equals("toll")) {
            return new OSMTollParser(lookup.getEnumEncodedValue("toll", Toll.class));
        }
        if (name.equals("track_type")) {
            return new OSMTrackTypeParser(lookup.getEnumEncodedValue("track_type", TrackType.class));
        }
        if (name.equals("hgv")) {
            return new OSMHgvParser(lookup.getEnumEncodedValue("hgv", Hgv.class));
        }
        if (name.equals("hazmat")) {
            return new OSMHazmatParser(lookup.getEnumEncodedValue("hazmat", Hazmat.class));
        }
        if (name.equals("hazmat_tunnel")) {
            return new OSMHazmatTunnelParser(lookup.getEnumEncodedValue("hazmat_tunnel", HazmatTunnel.class));
        }
        if (name.equals("hazmat_water")) {
            return new OSMHazmatWaterParser(lookup.getEnumEncodedValue("hazmat_water", HazmatWater.class));
        }
        if (name.equals("lanes")) {
            return new OSMLanesParser(lookup.getIntEncodedValue("lanes"));
        }
        if (name.equals("mtb_rating")) {
            return new OSMMtbRatingParser(lookup.getIntEncodedValue("mtb_rating"));
        }
        if (name.equals("hike_rating")) {
            return new OSMHikeRatingParser(lookup.getIntEncodedValue("hike_rating"));
        }
        if (name.equals("horse_rating")) {
            return new OSMHorseRatingParser(lookup.getIntEncodedValue("horse_rating"));
        }
        if (name.equals("country")) {
            return new CountryParser(lookup.getEnumEncodedValue("country", Country.class));
        }
        return null;
    }
}

