/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.countryrules;

import com.graphhopper.routing.ev.Country;
import com.graphhopper.routing.util.countryrules.CountryRule;
import com.graphhopper.routing.util.countryrules.europe.AlbaniaCountryRule;
import com.graphhopper.routing.util.countryrules.europe.AndorraCountryRule;
import com.graphhopper.routing.util.countryrules.europe.AustriaCountryRule;
import com.graphhopper.routing.util.countryrules.europe.BelarusCountryRule;
import com.graphhopper.routing.util.countryrules.europe.BelgiumCountryRule;
import com.graphhopper.routing.util.countryrules.europe.BosniaHerzegovinaCountryRule;
import com.graphhopper.routing.util.countryrules.europe.BulgariaCountryRule;
import com.graphhopper.routing.util.countryrules.europe.CroatiaCountryRule;
import com.graphhopper.routing.util.countryrules.europe.CzechiaCountryRule;
import com.graphhopper.routing.util.countryrules.europe.DenmarkCountryRule;
import com.graphhopper.routing.util.countryrules.europe.EstoniaCountryRule;
import com.graphhopper.routing.util.countryrules.europe.FaroeIslandsCountryRule;
import com.graphhopper.routing.util.countryrules.europe.FinlandCountryRule;
import com.graphhopper.routing.util.countryrules.europe.FranceCountryRule;
import com.graphhopper.routing.util.countryrules.europe.GermanyCountryRule;
import com.graphhopper.routing.util.countryrules.europe.GibraltarCountryRule;
import com.graphhopper.routing.util.countryrules.europe.GreeceCountryRule;
import com.graphhopper.routing.util.countryrules.europe.GuernseyCountryRule;
import com.graphhopper.routing.util.countryrules.europe.HungaryCountryRule;
import com.graphhopper.routing.util.countryrules.europe.IcelandCountryRule;
import com.graphhopper.routing.util.countryrules.europe.IrelandCountryRule;
import com.graphhopper.routing.util.countryrules.europe.IsleOfManCountryRule;
import com.graphhopper.routing.util.countryrules.europe.ItalyCountryRule;
import com.graphhopper.routing.util.countryrules.europe.JerseyCountryRule;
import com.graphhopper.routing.util.countryrules.europe.LatviaCountryRule;
import com.graphhopper.routing.util.countryrules.europe.LiechtensteinCountryRule;
import com.graphhopper.routing.util.countryrules.europe.LithuaniaCountryRule;
import com.graphhopper.routing.util.countryrules.europe.LuxembourgCountryRule;
import com.graphhopper.routing.util.countryrules.europe.MaltaCountryRule;
import com.graphhopper.routing.util.countryrules.europe.MoldovaCountryRule;
import com.graphhopper.routing.util.countryrules.europe.MonacoCountryRule;
import com.graphhopper.routing.util.countryrules.europe.MontenegroCountryRule;
import com.graphhopper.routing.util.countryrules.europe.NetherlandsCountryRule;
import com.graphhopper.routing.util.countryrules.europe.NorthMacedoniaCountryRule;
import com.graphhopper.routing.util.countryrules.europe.NorwayCountryRule;
import com.graphhopper.routing.util.countryrules.europe.PolandCountryRule;
import com.graphhopper.routing.util.countryrules.europe.PortugalCountryRule;
import com.graphhopper.routing.util.countryrules.europe.RomaniaCountryRule;
import com.graphhopper.routing.util.countryrules.europe.RussiaCountryRule;
import com.graphhopper.routing.util.countryrules.europe.SanMarinoCountryRule;
import com.graphhopper.routing.util.countryrules.europe.SerbiaCountryRule;
import com.graphhopper.routing.util.countryrules.europe.SlovakiaCountryRule;
import com.graphhopper.routing.util.countryrules.europe.SloveniaCountryRule;
import com.graphhopper.routing.util.countryrules.europe.SpainCountryRule;
import com.graphhopper.routing.util.countryrules.europe.SwedenCountryRule;
import com.graphhopper.routing.util.countryrules.europe.SwitzerlandCountryRule;
import com.graphhopper.routing.util.countryrules.europe.UkraineCountryRule;
import com.graphhopper.routing.util.countryrules.europe.UnitedKingdomCountryRule;
import com.graphhopper.routing.util.countryrules.europe.VaticanCityCountryRule;
import java.util.EnumMap;
import java.util.Map;

public class CountryRuleFactory {
    private final Map<Country, CountryRule> rules = new EnumMap<Country, CountryRule>(Country.class);

    public CountryRuleFactory() {
        this.rules.put(Country.ALB, new AlbaniaCountryRule());
        this.rules.put(Country.AND, new AndorraCountryRule());
        this.rules.put(Country.AUT, new AustriaCountryRule());
        this.rules.put(Country.BEL, new BelgiumCountryRule());
        this.rules.put(Country.BGR, new BulgariaCountryRule());
        this.rules.put(Country.BIH, new BosniaHerzegovinaCountryRule());
        this.rules.put(Country.BLR, new BelarusCountryRule());
        this.rules.put(Country.CHE, new SwitzerlandCountryRule());
        this.rules.put(Country.CZE, new CzechiaCountryRule());
        this.rules.put(Country.DEU, new GermanyCountryRule());
        this.rules.put(Country.DNK, new DenmarkCountryRule());
        this.rules.put(Country.ESP, new SpainCountryRule());
        this.rules.put(Country.EST, new EstoniaCountryRule());
        this.rules.put(Country.FIN, new FinlandCountryRule());
        this.rules.put(Country.FRA, new FranceCountryRule());
        this.rules.put(Country.FRO, new FaroeIslandsCountryRule());
        this.rules.put(Country.GGY, new GuernseyCountryRule());
        this.rules.put(Country.GIB, new GibraltarCountryRule());
        this.rules.put(Country.GBR, new UnitedKingdomCountryRule());
        this.rules.put(Country.GRC, new GreeceCountryRule());
        this.rules.put(Country.HRV, new CroatiaCountryRule());
        this.rules.put(Country.HUN, new HungaryCountryRule());
        this.rules.put(Country.IMN, new IsleOfManCountryRule());
        this.rules.put(Country.IRL, new IrelandCountryRule());
        this.rules.put(Country.ISL, new IcelandCountryRule());
        this.rules.put(Country.ITA, new ItalyCountryRule());
        this.rules.put(Country.JEY, new JerseyCountryRule());
        this.rules.put(Country.LIE, new LiechtensteinCountryRule());
        this.rules.put(Country.LTU, new LithuaniaCountryRule());
        this.rules.put(Country.LUX, new LuxembourgCountryRule());
        this.rules.put(Country.LVA, new LatviaCountryRule());
        this.rules.put(Country.MCO, new MonacoCountryRule());
        this.rules.put(Country.MDA, new MoldovaCountryRule());
        this.rules.put(Country.MKD, new NorthMacedoniaCountryRule());
        this.rules.put(Country.MLT, new MaltaCountryRule());
        this.rules.put(Country.MNE, new MontenegroCountryRule());
        this.rules.put(Country.NLD, new NetherlandsCountryRule());
        this.rules.put(Country.NOR, new NorwayCountryRule());
        this.rules.put(Country.POL, new PolandCountryRule());
        this.rules.put(Country.PRT, new PortugalCountryRule());
        this.rules.put(Country.ROU, new RomaniaCountryRule());
        this.rules.put(Country.RUS, new RussiaCountryRule());
        this.rules.put(Country.SMR, new SanMarinoCountryRule());
        this.rules.put(Country.SRB, new SerbiaCountryRule());
        this.rules.put(Country.SVK, new SlovakiaCountryRule());
        this.rules.put(Country.SVN, new SloveniaCountryRule());
        this.rules.put(Country.SWE, new SwedenCountryRule());
        this.rules.put(Country.UKR, new UkraineCountryRule());
        this.rules.put(Country.VAT, new VaticanCityCountryRule());
    }

    public CountryRule getCountryRule(Country country) {
        return this.rules.get((Object)country);
    }

    public Map<Country, CountryRule> getCountryToRuleMap() {
        return this.rules;
    }
}

