/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.PointList;

public class SlopeCalculator
implements TagParser {
    private final DecimalEncodedValue maxSlopeEnc;
    private final DecimalEncodedValue averageSlopeEnc;
    private static final double MIN_LENGTH = 8.0;

    public SlopeCalculator(DecimalEncodedValue max, DecimalEncodedValue averageEnc) {
        this.maxSlopeEnc = max;
        this.averageSlopeEnc = averageEnc;
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, IntsRef relationFlags) {
        PointList pointList = way.getTag("point_list", null);
        if (pointList != null) {
            if (pointList.isEmpty() || !pointList.is3D()) {
                this.averageSlopeEnc.setDecimal(false, edgeFlags, 0.0);
                return edgeFlags;
            }
            double distance2D = DistanceCalcEarth.calcDistance(pointList, false);
            if (distance2D < 8.0) {
                this.averageSlopeEnc.setDecimal(false, edgeFlags, 0.0);
                return edgeFlags;
            }
            double towerNodeSlope = SlopeCalculator.calcSlope(pointList.getEle(pointList.size() - 1) - pointList.getEle(0), distance2D);
            if (Double.isNaN(towerNodeSlope)) {
                throw new IllegalArgumentException("average_slope was NaN for OSM way ID " + way.getId());
            }
            if (towerNodeSlope >= 0.0) {
                this.averageSlopeEnc.setDecimal(false, edgeFlags, Math.min(towerNodeSlope, this.averageSlopeEnc.getMaxStorableDecimal()));
            } else {
                this.averageSlopeEnc.setDecimal(true, edgeFlags, Math.min(Math.abs(towerNodeSlope), this.averageSlopeEnc.getMaxStorableDecimal()));
            }
            double maxSlope = 0.0;
            double prevDist = 0.0;
            double prevLat = pointList.getLat(0);
            double prevLon = pointList.getLon(0);
            for (int i = 1; i < pointList.size(); ++i) {
                double pillarDistance2D = DistanceCalcEarth.DIST_EARTH.calcDist(prevLat, prevLon, pointList.getLat(i), pointList.getLon(i));
                if (i > 1 && prevDist > 8.0) {
                    double averagedPrevEle = (pointList.getEle(i - 1) + pointList.getEle(i - 2)) / 2.0;
                    double tmpSlope = SlopeCalculator.calcSlope(pointList.getEle(i) - averagedPrevEle, pillarDistance2D + prevDist / 2.0);
                    maxSlope = Math.max(maxSlope, Math.abs(tmpSlope));
                }
                prevDist = pillarDistance2D;
                prevLat = pointList.getLat(i);
                prevLon = pointList.getLon(i);
            }
            maxSlope = way.hasTag("tunnel", (Object)"yes") || way.hasTag("bridge", (Object)"yes") || way.hasTag("highway", (Object)"steps") ? Math.abs(towerNodeSlope) : Math.max(Math.abs(towerNodeSlope), maxSlope);
            if (Double.isNaN(maxSlope)) {
                throw new IllegalArgumentException("max_slope was NaN for OSM way ID " + way.getId());
            }
            this.maxSlopeEnc.setDecimal(false, edgeFlags, Math.min(maxSlope, this.maxSlopeEnc.getMaxStorableDecimal()));
        }
        return edgeFlags;
    }

    static double calcSlope(double eleDelta, double distance2D) {
        return eleDelta * 100.0 / distance2D;
    }
}

