/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.VehicleTagParser;
import com.graphhopper.routing.util.WayAccess;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.PMap;

public class RoadsTagParser
extends VehicleTagParser {
    public static final double ROADS_MAX_SPEED = 254.0;

    public RoadsTagParser(EncodedValueLookup lookup, PMap properties) {
        super(lookup.getBooleanEncodedValue(VehicleAccess.key("roads")), lookup.getDecimalEncodedValue(VehicleSpeed.key("roads")), "roads", lookup.getBooleanEncodedValue("roundabout"), lookup.hasEncodedValue(TurnCost.key("roads")) ? lookup.getDecimalEncodedValue(TurnCost.key("roads")) : null, TransportationMode.valueOf(properties.getString("transportation_mode", "VEHICLE")), lookup.getDecimalEncodedValue(VehicleSpeed.key("roads")).getNextStorableValue(254.0));
    }

    public RoadsTagParser(BooleanEncodedValue accessEnc, DecimalEncodedValue speedEnc, DecimalEncodedValue turnCostEnc) {
        super(accessEnc, speedEnc, "roads", null, turnCostEnc, TransportationMode.VEHICLE, speedEnc.getNextStorableValue(254.0));
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way) {
        double speed = this.maxPossibleSpeed;
        this.accessEnc.setBool(true, edgeFlags, true);
        this.accessEnc.setBool(false, edgeFlags, true);
        this.setSpeed(false, edgeFlags, speed);
        if (this.avgSpeedEnc.isStoreTwoDirections()) {
            this.setSpeed(true, edgeFlags, speed);
        }
        return edgeFlags;
    }

    @Override
    public WayAccess getAccess(ReaderWay way) {
        if (way.getTag("highway", "").isEmpty()) {
            return WayAccess.CAN_SKIP;
        }
        return WayAccess.WAY;
    }

    @Override
    public boolean isBarrier(ReaderNode node) {
        return false;
    }
}

