/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.reader.osm.OSMTurnRestriction;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.util.VehicleTagParser;
import com.graphhopper.routing.util.WayAccess;
import com.graphhopper.routing.util.parsers.OSMTurnRestrictionParser;
import com.graphhopper.routing.util.parsers.RelationTagParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.parsers.TurnCostParser;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.IntsRef;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class OSMParsers {
    private final List<TagParser> wayTagParsers;
    private final List<VehicleTagParser> vehicleTagParsers;
    private final List<RelationTagParser> relationTagParsers;
    private final List<TurnCostParser> turnCostParsers;
    private final EncodedValue.InitializerConfig relConfig = new EncodedValue.InitializerConfig();

    public OSMParsers() {
        this(new ArrayList<TagParser>(), new ArrayList<VehicleTagParser>(), new ArrayList<RelationTagParser>(), new ArrayList<TurnCostParser>());
    }

    public OSMParsers(List<TagParser> wayTagParsers, List<VehicleTagParser> vehicleTagParsers, List<RelationTagParser> relationTagParsers, List<TurnCostParser> turnCostParsers) {
        this.wayTagParsers = wayTagParsers;
        this.vehicleTagParsers = vehicleTagParsers;
        this.relationTagParsers = relationTagParsers;
        this.turnCostParsers = turnCostParsers;
    }

    public OSMParsers addWayTagParser(TagParser tagParser) {
        this.wayTagParsers.add(tagParser);
        return this;
    }

    public OSMParsers addVehicleTagParser(VehicleTagParser vehicleTagParser) {
        this.vehicleTagParsers.add(vehicleTagParser);
        if (vehicleTagParser.supportsTurnCosts()) {
            this.turnCostParsers.add(new OSMTurnRestrictionParser(vehicleTagParser.getAccessEnc(), vehicleTagParser.getTurnCostEnc(), vehicleTagParser.getRestrictions()));
        }
        return this;
    }

    public OSMParsers addRelationTagParser(Function<EncodedValue.InitializerConfig, RelationTagParser> createRelationTagParser) {
        this.relationTagParsers.add(createRelationTagParser.apply(this.relConfig));
        return this;
    }

    public OSMParsers addTurnCostTagParser(TurnCostParser turnCostParser) {
        this.turnCostParsers.add(turnCostParser);
        return this;
    }

    public boolean acceptWay(ReaderWay way) {
        return this.vehicleTagParsers.stream().anyMatch(v -> !v.getAccess(way).equals((Object)WayAccess.CAN_SKIP));
    }

    public IntsRef handleRelationTags(ReaderRelation relation, IntsRef relFlags) {
        for (RelationTagParser relParser : this.relationTagParsers) {
            relParser.handleRelationTags(relFlags, relation);
        }
        return relFlags;
    }

    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, IntsRef relationFlags) {
        for (RelationTagParser relParser : this.relationTagParsers) {
            relParser.handleWayTags(edgeFlags, way, relationFlags);
        }
        for (TagParser parser : this.wayTagParsers) {
            parser.handleWayTags(edgeFlags, way, relationFlags);
        }
        for (VehicleTagParser vehicleTagParser : this.vehicleTagParsers) {
            vehicleTagParser.handleWayTags(edgeFlags, way, relationFlags);
        }
        return edgeFlags;
    }

    public void handleTurnRestrictionTags(OSMTurnRestriction turnRestriction, TurnCostParser.ExternalInternalMap map, Graph graph) {
        this.turnCostParsers.forEach(t -> t.handleTurnRestrictionTags(turnRestriction, map, graph));
    }

    public IntsRef createRelationFlags() {
        int requiredInts = this.relConfig.getRequiredInts();
        if (requiredInts > 2) {
            throw new IllegalStateException("More than two ints are needed for relation flags, but OSMReader does not allow this");
        }
        return new IntsRef(2);
    }

    public List<VehicleTagParser> getVehicleTagParsers() {
        return this.vehicleTagParsers;
    }
}

