/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.FootNetwork;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehiclePriority;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.FootTagParser;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PointList;
import java.util.Collection;
import java.util.TreeMap;

public class HikeTagParser
extends FootTagParser {
    public HikeTagParser(EncodedValueLookup lookup, PMap properties) {
        this(lookup.getBooleanEncodedValue(VehicleAccess.key(properties.getString("name", "hike"))), lookup.getDecimalEncodedValue(VehicleSpeed.key(properties.getString("name", "hike"))), lookup.getDecimalEncodedValue(VehiclePriority.key(properties.getString("name", "hike"))), lookup.getEnumEncodedValue(FootNetwork.KEY, RouteNetwork.class), properties.getString("name", "hike"));
        this.blockPrivate(properties.getBool("block_private", true));
        this.blockFords(properties.getBool("block_fords", false));
    }

    protected HikeTagParser(BooleanEncodedValue accessEnc, DecimalEncodedValue speedEnc, DecimalEncodedValue priorityEnc, EnumEncodedValue<RouteNetwork> footRouteEnc, String name) {
        super(accessEnc, speedEnc, priorityEnc, footRouteEnc, name);
        this.routeMap.put(RouteNetwork.INTERNATIONAL, PriorityCode.BEST.getValue());
        this.routeMap.put(RouteNetwork.NATIONAL, PriorityCode.BEST.getValue());
        this.routeMap.put(RouteNetwork.REGIONAL, PriorityCode.VERY_NICE.getValue());
        this.routeMap.put(RouteNetwork.LOCAL, PriorityCode.VERY_NICE.getValue());
        this.allowedSacScale.add("alpine_hiking");
        this.allowedSacScale.add("demanding_alpine_hiking");
        this.allowedSacScale.add("difficult_alpine_hiking");
    }

    @Override
    void collect(ReaderWay way, TreeMap<Double, Integer> weightToPrioMap) {
        String highway = way.getTag("highway");
        if (way.hasTag("foot", (Object)"designated")) {
            weightToPrioMap.put(100.0, PriorityCode.PREFER.getValue());
        }
        double maxSpeed = HikeTagParser.getMaxSpeed(way);
        if (this.safeHighwayTags.contains(highway) || HikeTagParser.isValidSpeed(maxSpeed) && maxSpeed <= 20.0) {
            weightToPrioMap.put(40.0, PriorityCode.PREFER.getValue());
            if (way.hasTag("tunnel", (Collection<String>)this.intendedValues)) {
                if (way.hasTag("sidewalk", (Collection<String>)this.sidewalksNoValues)) {
                    weightToPrioMap.put(40.0, PriorityCode.AVOID.getValue());
                } else {
                    weightToPrioMap.put(40.0, PriorityCode.UNCHANGED.getValue());
                }
            }
        } else if (HikeTagParser.isValidSpeed(maxSpeed) && maxSpeed > 50.0 || this.avoidHighwayTags.contains(highway)) {
            if (way.hasTag("sidewalk", (Collection<String>)this.sidewalksNoValues)) {
                weightToPrioMap.put(45.0, PriorityCode.BAD.getValue());
            } else {
                weightToPrioMap.put(45.0, PriorityCode.AVOID.getValue());
            }
        }
        if (way.hasTag("bicycle", (Object)"official") || way.hasTag("bicycle", (Object)"designated")) {
            weightToPrioMap.put(44.0, PriorityCode.SLIGHT_AVOID.getValue());
        }
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way) {
        edgeFlags = super.handleWayTags(edgeFlags, way);
        return this.applyWayTags(way, edgeFlags);
    }

    public IntsRef applyWayTags(ReaderWay way, IntsRef edgeFlags) {
        PointList pl = way.getTag("point_list", null);
        if (pl == null) {
            throw new IllegalArgumentException("The artificial point_list tag is missing");
        }
        if (!pl.is3D()) {
            return edgeFlags;
        }
        if (way.hasTag("tunnel", (Object)"yes") || way.hasTag("bridge", (Object)"yes") || way.hasTag("highway", (Object)"steps")) {
            return edgeFlags;
        }
        double prevEle = pl.getEle(0);
        if (!way.hasTag("edge_distance", new String[0])) {
            throw new IllegalArgumentException("The artificial edge_distance tag is missing");
        }
        double fullDistance = way.getTag("edge_distance", 0.0);
        if (fullDistance < 2.0) {
            return edgeFlags;
        }
        double eleDelta = Math.abs(pl.getEle(pl.size() - 1) - prevEle);
        double slope = eleDelta / fullDistance;
        if ((this.accessEnc.getBool(false, edgeFlags) || this.accessEnc.getBool(true, edgeFlags)) && slope > 0.005) {
            double newSpeed = Math.sqrt(1.0 + slope * slope) / (slope + 0.18518518518518517);
            this.avgSpeedEnc.setDecimal(false, edgeFlags, Helper.keepIn((double)newSpeed, (double)1.0, (double)5.0));
        }
        return edgeFlags;
    }
}

