/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;

public class FerrySpeedCalculator {
    private final double unknownSpeed;
    private final double minSpeed;
    private final double maxSpeed;

    public FerrySpeedCalculator(double minSpeed, double maxSpeed, double unknownSpeed) {
        this.minSpeed = minSpeed;
        this.maxSpeed = maxSpeed;
        this.unknownSpeed = unknownSpeed;
    }

    public double getSpeed(ReaderWay way) {
        double speedInKmPerHour = way.getTag("speed_from_duration", Double.NaN);
        if (!Double.isNaN(speedInKmPerHour)) {
            double speedWithWaitingTime = speedInKmPerHour / 1.4;
            return Math.round(Math.max(this.minSpeed, Math.min(speedWithWaitingTime, this.maxSpeed)));
        }
        double wayDistance = way.getTag("edge_distance", Double.NaN);
        if (Double.isNaN(wayDistance)) {
            throw new IllegalStateException("No 'edge_distance' set for edge created for way: " + way.getId());
        }
        if (wayDistance < 500.0) {
            return this.minSpeed;
        }
        return this.unknownSpeed;
    }
}

