/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.util.BikeTagParser;
import com.graphhopper.routing.util.CarTagParser;
import com.graphhopper.routing.util.FootTagParser;
import com.graphhopper.routing.util.HikeTagParser;
import com.graphhopper.routing.util.MotorcycleTagParser;
import com.graphhopper.routing.util.MountainBikeTagParser;
import com.graphhopper.routing.util.RacingBikeTagParser;
import com.graphhopper.routing.util.RoadsTagParser;
import com.graphhopper.routing.util.VehicleTagParser;
import com.graphhopper.routing.util.VehicleTagParserFactory;
import com.graphhopper.routing.util.WheelchairTagParser;
import com.graphhopper.util.PMap;

public class DefaultVehicleTagParserFactory
implements VehicleTagParserFactory {
    @Override
    public VehicleTagParser createParser(EncodedValueLookup lookup, String name, PMap configuration) {
        if (name.equals("roads")) {
            return new RoadsTagParser(lookup, configuration);
        }
        if (name.equals("car")) {
            return new CarTagParser(lookup, configuration);
        }
        if (name.equals("bike")) {
            return new BikeTagParser(lookup, configuration);
        }
        if (name.equals("racingbike")) {
            return new RacingBikeTagParser(lookup, configuration);
        }
        if (name.equals("mtb")) {
            return new MountainBikeTagParser(lookup, configuration);
        }
        if (name.equals("foot")) {
            return new FootTagParser(lookup, configuration);
        }
        if (name.equals("hike")) {
            return new HikeTagParser(lookup, configuration);
        }
        if (name.equals("motorcycle")) {
            return new MotorcycleTagParser(lookup, configuration);
        }
        if (name.equals("wheelchair")) {
            return new WheelchairTagParser(lookup, configuration);
        }
        throw new IllegalArgumentException("Unknown name for vehicle tag parser: " + name);
    }
}

