/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.subnetwork;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.BitSetIterator;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.subnetwork.EdgeBasedTarjanSCC;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.StopWatch;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareRoutingSubnetworks {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BaseGraph graph;
    private final List<PrepareJob> prepareJobs;
    private int minNetworkSize = 200;

    public PrepareRoutingSubnetworks(BaseGraph graph, List<PrepareJob> prepareJobs) {
        this.graph = graph;
        this.prepareJobs = prepareJobs;
    }

    public PrepareRoutingSubnetworks setMinNetworkSize(int minNetworkSize) {
        this.minNetworkSize = minNetworkSize;
        return this;
    }

    public int doWork() {
        if (this.minNetworkSize <= 0) {
            this.logger.info("Skipping subnetwork search: prepare.min_network_size: " + this.minNetworkSize);
            return 0;
        }
        StopWatch sw = new StopWatch().start();
        this.logger.info("Start marking subnetworks, prepare.min_network_size: " + this.minNetworkSize + ", nodes: " + Helper.nf((long)this.graph.getNodes()) + ", edges: " + Helper.nf((long)this.graph.getEdges()) + ", jobs: " + this.prepareJobs + ", " + Helper.getMemInfo());
        int total = 0;
        for (PrepareJob job : this.prepareJobs) {
            total += this.setSubnetworks(job.weighting, job.subnetworkEnc);
        }
        this.logger.info("Finished finding and marking subnetworks for " + this.prepareJobs.size() + " jobs, took: " + sw.stop().getSeconds() + "s, " + Helper.getMemInfo());
        return total;
    }

    private int setSubnetworks(Weighting weighting, BooleanEncodedValue subnetworkEnc) {
        int allowedMarked;
        StopWatch sw = new StopWatch().start();
        EdgeBasedTarjanSCC.ConnectedComponents ccs = EdgeBasedTarjanSCC.findComponents(this.graph, (prev, edge) -> Double.isFinite(GHUtility.calcWeightWithTurnWeightWithAccess(weighting, edge, false, prev)), false);
        List<IntArrayList> components = ccs.getComponents();
        BitSet singleEdgeComponents = ccs.getSingleEdgeComponents();
        long numSingleEdgeComponents = singleEdgeComponents.cardinality();
        this.logger.info(subnetworkEnc.getName().replaceAll("_subnetwork", "") + " - Found " + ccs.getTotalComponents() + " subnetworks (" + numSingleEdgeComponents + " single edges and " + components.size() + " components with more than one edge, total nodes: " + ccs.getEdgeKeys() + "), took: " + sw.stop().getSeconds() + "s");
        int minNetworkSizeEdgeKeys = 2 * this.minNetworkSize;
        sw = new StopWatch().start();
        int subnetworks = 0;
        int markedEdges = 0;
        int smallestNonSubnetwork = ccs.getBiggestComponent().size();
        int biggestSubnetwork = 0;
        for (IntArrayList component : components) {
            if (component == ccs.getBiggestComponent()) continue;
            if (component.size() < minNetworkSizeEdgeKeys) {
                for (IntCursor cursor : component) {
                    markedEdges += this.setSubnetworkEdge(cursor.value, weighting, subnetworkEnc);
                }
                ++subnetworks;
                biggestSubnetwork = Math.max(biggestSubnetwork, component.size());
                continue;
            }
            smallestNonSubnetwork = Math.min(smallestNonSubnetwork, component.size());
        }
        if (minNetworkSizeEdgeKeys > 0) {
            BitSetIterator iter = singleEdgeComponents.iterator();
            int edgeKey = iter.nextSetBit();
            while (edgeKey >= 0) {
                markedEdges += this.setSubnetworkEdge(edgeKey, weighting, subnetworkEnc);
                ++subnetworks;
                biggestSubnetwork = Math.max(biggestSubnetwork, 1);
                edgeKey = iter.nextSetBit();
            }
        } else if (numSingleEdgeComponents > 0L) {
            smallestNonSubnetwork = Math.min(smallestNonSubnetwork, 1);
        }
        if (markedEdges / 2 > (allowedMarked = this.graph.getEdges() / 2)) {
            throw new IllegalStateException("Too many total (directed) edges were marked as subnetwork edges: " + markedEdges + " out of " + 2 * this.graph.getEdges() + "\nThe maximum number of subnetwork edges is: " + 2 * allowedMarked);
        }
        this.logger.info(subnetworkEnc.getName().replaceAll("_subnetwork", "") + " - Marked " + subnetworks + " subnetworks (biggest: " + biggestSubnetwork + " edges) -> " + (ccs.getTotalComponents() - subnetworks) + " components(s) remain (smallest: " + smallestNonSubnetwork + ", biggest: " + ccs.getBiggestComponent().size() + " edges), total marked edges: " + markedEdges + ", took: " + sw.stop().getSeconds() + "s");
        return markedEdges;
    }

    private int setSubnetworkEdge(int edgeKey, Weighting weighting, BooleanEncodedValue subnetworkEnc) {
        if (!Double.isFinite(weighting.calcEdgeWeightWithAccess(this.graph.getEdgeIteratorStateForKey(edgeKey), false))) {
            return 0;
        }
        EdgeIteratorState edgeState = this.graph.getEdgeIteratorState(GHUtility.getEdgeFromEdgeKey(edgeKey), Integer.MIN_VALUE);
        if (!edgeState.get(subnetworkEnc)) {
            edgeState.set(subnetworkEnc, true);
            return 1;
        }
        return 0;
    }

    public static class PrepareJob {
        private final BooleanEncodedValue subnetworkEnc;
        private final Weighting weighting;

        public PrepareJob(BooleanEncodedValue subnetworkEnc, Weighting weighting) {
            this.weighting = weighting;
            this.subnetworkEnc = subnetworkEnc;
        }

        public String toString() {
            return this.subnetworkEnc.getName() + "|" + this.weighting;
        }
    }
}

