/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

public enum RoadClass {
    OTHER("other"),
    MOTORWAY("motorway"),
    TRUNK("trunk"),
    PRIMARY("primary"),
    SECONDARY("secondary"),
    TERTIARY("tertiary"),
    RESIDENTIAL("residential"),
    UNCLASSIFIED("unclassified"),
    SERVICE("service"),
    ROAD("road"),
    TRACK("track"),
    BRIDLEWAY("bridleway"),
    STEPS("steps"),
    CYCLEWAY("cycleway"),
    PATH("path"),
    LIVING_STREET("living_street"),
    FOOTWAY("footway"),
    PEDESTRIAN("pedestrian"),
    PLATFORM("platform"),
    CORRIDOR("corridor");

    public static final String KEY = "road_class";
    private final String name;

    private RoadClass(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static RoadClass find(String name) {
        if (name == null || name.isEmpty()) {
            return OTHER;
        }
        for (RoadClass roadClass : RoadClass.values()) {
            if (!roadClass.name().equalsIgnoreCase(name)) continue;
            return roadClass;
        }
        return OTHER;
    }
}

