/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.util.Helper;

public enum RoadAccess {
    YES("yes"),
    DESTINATION("destination"),
    CUSTOMERS("customers"),
    DELIVERY("delivery"),
    FORESTRY("forestry"),
    AGRICULTURAL("agricultural"),
    PRIVATE("private"),
    OTHER("other"),
    NO("no");

    public static final String KEY = "road_access";
    private final String name;

    private RoadAccess(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static RoadAccess find(String name) {
        if (name == null) {
            return YES;
        }
        try {
            return RoadAccess.valueOf(Helper.toUpperCase((String)name));
        }
        catch (IllegalArgumentException ex) {
            return YES;
        }
    }
}

