/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.IntObjectScatterMap;
import com.graphhopper.routing.ch.CHPreparationGraph;
import com.graphhopper.routing.ch.PrepareCHEntry;
import com.graphhopper.routing.ch.PrepareGraphEdgeExplorer;
import com.graphhopper.routing.ch.PrepareGraphEdgeIterator;
import com.graphhopper.routing.ch.PrepareGraphOrigEdgeExplorer;
import com.graphhopper.routing.ch.PrepareGraphOrigEdgeIterator;
import java.util.PriorityQueue;

public class BridgePathFinder {
    private final CHPreparationGraph graph;
    private final PrepareGraphEdgeExplorer outExplorer;
    private final PrepareGraphOrigEdgeExplorer origOutExplorer;
    private final PriorityQueue<PrepareCHEntry> queue;
    private final IntObjectMap<PrepareCHEntry> map;

    public BridgePathFinder(CHPreparationGraph graph) {
        this.graph = graph;
        this.outExplorer = graph.createOutEdgeExplorer();
        this.origOutExplorer = graph.createOutOrigEdgeExplorer();
        this.queue = new PriorityQueue();
        this.map = new IntObjectScatterMap();
    }

    public IntObjectMap<BridePathEntry> find(int startInEdgeKey, int startNode, int centerNode) {
        this.queue.clear();
        this.map.clear();
        IntObjectHashMap result = new IntObjectHashMap(16, 0.5, HashOrderMixing.constant((long)123L));
        PrepareCHEntry startEntry = new PrepareCHEntry(-1, startInEdgeKey, startInEdgeKey, startNode, 0.0, 0);
        this.map.put(startInEdgeKey, (Object)startEntry);
        this.queue.add(startEntry);
        while (!this.queue.isEmpty()) {
            PrepareCHEntry currEntry = this.queue.poll();
            PrepareGraphEdgeIterator iter = this.outExplorer.setBaseNode(currEntry.adjNode);
            while (iter.next()) {
                double weight;
                if (iter.getAdjNode() == centerNode) {
                    weight = currEntry.weight + this.graph.getTurnWeight(currEntry.incEdgeKey, currEntry.adjNode, iter.getOrigEdgeKeyFirst()) + iter.getWeight();
                    if (Double.isInfinite(weight)) continue;
                    PrepareCHEntry entry = (PrepareCHEntry)this.map.get(iter.getOrigEdgeKeyLast());
                    if (entry == null) {
                        entry = new PrepareCHEntry(iter.getPrepareEdge(), iter.getOrigEdgeKeyFirst(), iter.getOrigEdgeKeyLast(), iter.getAdjNode(), weight, currEntry.origEdges + iter.getOrigEdgeCount());
                        entry.parent = currEntry;
                        this.map.put(iter.getOrigEdgeKeyLast(), (Object)entry);
                        this.queue.add(entry);
                        continue;
                    }
                    if (!(weight < entry.weight)) continue;
                    this.queue.remove(entry);
                    entry.prepareEdge = iter.getPrepareEdge();
                    entry.origEdges = currEntry.origEdges + iter.getOrigEdgeCount();
                    entry.firstEdgeKey = iter.getOrigEdgeKeyFirst();
                    entry.weight = weight;
                    entry.parent = currEntry;
                    this.queue.add(entry);
                    continue;
                }
                if (currEntry.adjNode != centerNode || Double.isInfinite(weight = currEntry.weight + this.graph.getTurnWeight(currEntry.incEdgeKey, currEntry.adjNode, iter.getOrigEdgeKeyFirst()) + iter.getWeight())) continue;
                PrepareGraphOrigEdgeIterator origOutIter = this.origOutExplorer.setBaseNode(iter.getAdjNode());
                while (origOutIter.next()) {
                    double totalWeight = weight + this.graph.getTurnWeight(iter.getOrigEdgeKeyLast(), iter.getAdjNode(), origOutIter.getOrigEdgeKeyFirst());
                    if (Double.isInfinite(totalWeight)) continue;
                    BridePathEntry resEntry = (BridePathEntry)result.get(origOutIter.getOrigEdgeKeyFirst());
                    if (resEntry == null) {
                        PrepareCHEntry chEntry = new PrepareCHEntry(iter.getPrepareEdge(), iter.getOrigEdgeKeyFirst(), iter.getOrigEdgeKeyLast(), iter.getAdjNode(), weight, currEntry.origEdges + iter.getOrigEdgeCount());
                        chEntry.parent = currEntry;
                        resEntry = new BridePathEntry(totalWeight, chEntry);
                        result.put(origOutIter.getOrigEdgeKeyFirst(), (Object)resEntry);
                        continue;
                    }
                    if (!(totalWeight < resEntry.weight)) continue;
                    resEntry.weight = totalWeight;
                    resEntry.chEntry.prepareEdge = iter.getPrepareEdge();
                    resEntry.chEntry.firstEdgeKey = iter.getOrigEdgeKeyFirst();
                    resEntry.chEntry.origEdges = currEntry.origEdges + iter.getOrigEdgeCount();
                    resEntry.chEntry.incEdgeKey = iter.getOrigEdgeKeyLast();
                    resEntry.chEntry.weight = weight;
                    resEntry.chEntry.parent = currEntry;
                }
            }
        }
        return result;
    }

    public static class BridePathEntry {
        double weight;
        PrepareCHEntry chEntry;

        public BridePathEntry(double weight, PrepareCHEntry chEntry) {
            this.weight = weight;
            this.chEntry = chEntry;
        }

        public String toString() {
            return "weight: " + this.weight + ", chEntry: " + this.chEntry;
        }
    }
}

