/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import com.carrotsearch.hppc.IntLongMap;
import com.carrotsearch.hppc.LongArrayList;
import com.graphhopper.coll.GHIntLongHashMap;
import com.graphhopper.coll.GHLongHashSet;
import com.graphhopper.coll.GHLongLongHashMap;
import com.graphhopper.reader.ReaderElement;
import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.reader.dem.EdgeElevationSmoothing;
import com.graphhopper.reader.dem.EdgeSampling;
import com.graphhopper.reader.dem.ElevationProvider;
import com.graphhopper.reader.osm.OSMReaderUtility;
import com.graphhopper.reader.osm.OSMTurnRestriction;
import com.graphhopper.reader.osm.WaySegmentParser;
import com.graphhopper.routing.OSMReaderConfig;
import com.graphhopper.routing.ev.Country;
import com.graphhopper.routing.util.AreaIndex;
import com.graphhopper.routing.util.CustomArea;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.OSMParsers;
import com.graphhopper.routing.util.countryrules.CountryRule;
import com.graphhopper.routing.util.countryrules.CountryRuleFactory;
import com.graphhopper.routing.util.parsers.TurnCostParser;
import com.graphhopper.search.EdgeKVStorage;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;
import com.graphhopper.util.RamerDouglasPeucker;
import com.graphhopper.util.shapes.GHPoint;
import com.graphhopper.util.shapes.GHPoint3D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.LongToIntFunction;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSMReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(OSMReader.class);
    private static final Pattern WAY_NAME_PATTERN = Pattern.compile("; *");
    private final OSMReaderConfig config;
    private final BaseGraph baseGraph;
    private final NodeAccess nodeAccess;
    private final TurnCostStorage turnCostStorage;
    private final EncodingManager encodingManager;
    private final OSMParsers osmParsers;
    private final DistanceCalc distCalc = DistanceCalcEarth.DIST_EARTH;
    private ElevationProvider eleProvider = ElevationProvider.NOOP;
    private AreaIndex<CustomArea> areaIndex;
    private CountryRuleFactory countryRuleFactory = null;
    private File osmFile;
    private final RamerDouglasPeucker simplifyAlgo = new RamerDouglasPeucker();
    private final IntsRef tempRelFlags;
    private Date osmDataDate;
    private long zeroCounter = 0L;
    private GHLongLongHashMap osmWayIdToRelationFlagsMap = new GHLongLongHashMap(200, 0.5);
    private GHLongHashSet osmWayIdSet = new GHLongHashSet();
    private IntLongMap edgeIdToOsmWayIdMap;

    public OSMReader(BaseGraph baseGraph, EncodingManager encodingManager, OSMParsers osmParsers, OSMReaderConfig config) {
        this.baseGraph = baseGraph;
        this.encodingManager = encodingManager;
        this.config = config;
        this.nodeAccess = baseGraph.getNodeAccess();
        this.osmParsers = osmParsers;
        this.simplifyAlgo.setMaxDistance(config.getMaxWayPointDistance());
        this.simplifyAlgo.setElevationMaxDistance(config.getElevationMaxWayPointDistance());
        this.turnCostStorage = baseGraph.getTurnCostStorage();
        this.tempRelFlags = osmParsers.createRelationFlags();
        if (this.tempRelFlags.length != 2) {
            throw new IllegalArgumentException("OSMReader cannot use relation flags with != 2 integers");
        }
    }

    public OSMReader setFile(File osmFile) {
        this.osmFile = osmFile;
        return this;
    }

    public OSMReader setAreaIndex(AreaIndex<CustomArea> areaIndex) {
        this.areaIndex = areaIndex;
        return this;
    }

    public OSMReader setElevationProvider(ElevationProvider eleProvider) {
        if (eleProvider == null) {
            throw new IllegalStateException("Use the NOOP elevation provider instead of null or don't call setElevationProvider");
        }
        if (!this.nodeAccess.is3D() && ElevationProvider.NOOP != eleProvider) {
            throw new IllegalStateException("Make sure you graph accepts 3D data");
        }
        this.eleProvider = eleProvider;
        return this;
    }

    public OSMReader setCountryRuleFactory(CountryRuleFactory countryRuleFactory) {
        this.countryRuleFactory = countryRuleFactory;
        return this;
    }

    public void readGraph() throws IOException {
        if (this.osmParsers == null) {
            throw new IllegalStateException("Tag parsers were not set.");
        }
        if (this.osmFile == null) {
            throw new IllegalStateException("No OSM file specified");
        }
        if (!this.osmFile.exists()) {
            throw new IllegalStateException("Your specified OSM file does not exist:" + this.osmFile.getAbsolutePath());
        }
        if (!this.baseGraph.isInitialized()) {
            throw new IllegalStateException("BaseGraph must be initialize before we can read OSM");
        }
        WaySegmentParser waySegmentParser = new WaySegmentParser.Builder(this.baseGraph.getNodeAccess()).setDirectory(this.baseGraph.getDirectory()).setElevationProvider(this.eleProvider).setWayFilter(this::acceptWay).setSplitNodeFilter(this::isBarrierNode).setWayPreprocessor(this::preprocessWay).setRelationPreprocessor(this::preprocessRelations).setRelationProcessor(this::processRelation).setEdgeHandler(this::addEdge).setWorkerThreads(this.config.getWorkerThreads()).build();
        waySegmentParser.readOSM(this.osmFile);
        this.osmDataDate = waySegmentParser.getTimeStamp();
        if (this.baseGraph.getNodes() == 0) {
            throw new RuntimeException("Graph after reading OSM must not be empty");
        }
        LOGGER.info("Finished reading OSM file: {}, nodes: {}, edges: {}, zero distance edges: {}", new Object[]{this.osmFile.getAbsolutePath(), Helper.nf((long)this.baseGraph.getNodes()), Helper.nf((long)this.baseGraph.getEdges()), Helper.nf((long)this.zeroCounter)});
        this.finishedReading();
    }

    public Date getDataDate() {
        return this.osmDataDate;
    }

    protected boolean acceptWay(ReaderWay way) {
        if (way.getNodes().size() < 2) {
            return false;
        }
        if (!way.hasTags()) {
            return false;
        }
        return this.osmParsers.acceptWay(way);
    }

    protected boolean isBarrierNode(ReaderNode node) {
        return node.hasTag("barrier", new String[0]) || node.hasTag("ford", new String[0]);
    }

    protected boolean isCalculateWayDistance(ReaderWay way) {
        return this.isFerry(way);
    }

    private boolean isFerry(ReaderWay way) {
        return way.hasTag("route", "ferry", "shuttle_train");
    }

    protected void setArtificialWayTags(PointList pointList, ReaderWay way, double distance, Map<String, Object> nodeTags) {
        CountryRule countryRule;
        List<Object> customAreas;
        way.setTag("node_tags", nodeTags);
        way.setTag("edge_distance", distance);
        way.setTag("point_list", pointList);
        way.removeTag("country");
        way.removeTag("country_rule");
        way.removeTag("custom_areas");
        if (this.areaIndex != null) {
            double middleLon;
            double middleLat;
            if (pointList.size() > 2) {
                middleLat = pointList.getLat(pointList.size() / 2);
                middleLon = pointList.getLon(pointList.size() / 2);
            } else {
                double firstLat = pointList.getLat(0);
                double firstLon = pointList.getLon(0);
                double lastLat = pointList.getLat(pointList.size() - 1);
                double lastLon = pointList.getLon(pointList.size() - 1);
                middleLat = (firstLat + lastLat) / 2.0;
                middleLon = (firstLon + lastLon) / 2.0;
            }
            customAreas = this.areaIndex.query(middleLat, middleLon);
        } else {
            customAreas = Collections.emptyList();
        }
        Country country = Country.MISSING;
        CustomArea prevCustomArea = null;
        for (CustomArea customArea : customAreas) {
            Object alpha3 = customArea.getProperties().get("ISO3166-1:alpha3");
            if (alpha3 == null) continue;
            if (prevCustomArea != null && prevCustomArea.getArea() < customArea.getArea()) break;
            prevCustomArea = customArea;
            country = Country.valueOf((String)alpha3);
        }
        way.setTag("country", (Object)country);
        if (this.countryRuleFactory != null && (countryRule = this.countryRuleFactory.getCountryRule(country)) != null) {
            way.setTag("country_rule", countryRule);
        }
        way.setTag("custom_areas", customAreas);
    }

    protected void addEdge(int fromIndex, int toIndex, PointList pointList, ReaderWay way, Map<String, Object> nodeTags) {
        double distance;
        if (fromIndex < 0 || toIndex < 0) {
            throw new AssertionError((Object)("to or from index is invalid for this edge " + fromIndex + "->" + toIndex + ", points:" + pointList));
        }
        if (pointList.getDimension() != this.nodeAccess.getDimension()) {
            throw new AssertionError((Object)("Dimension does not match for pointList vs. nodeAccess " + pointList.getDimension() + " <-> " + this.nodeAccess.getDimension()));
        }
        if (pointList.is3D()) {
            if (this.config.getLongEdgeSamplingDistance() < Double.MAX_VALUE) {
                pointList = EdgeSampling.sample(pointList, this.config.getLongEdgeSamplingDistance(), this.distCalc, this.eleProvider);
            }
            if (this.config.getElevationSmoothing().equals("ramer")) {
                EdgeElevationSmoothing.smoothRamer(pointList, this.config.getElevationSmoothingRamerMax());
            } else if (this.config.getElevationSmoothing().equals("moving_average")) {
                EdgeElevationSmoothing.smoothMovingAverage(pointList);
            }
        }
        if (this.config.getMaxWayPointDistance() > 0.0 && pointList.size() > 2) {
            this.simplifyAlgo.simplify(pointList);
        }
        if ((distance = this.distCalc.calcDistance(pointList)) < 0.001) {
            ++this.zeroCounter;
            distance = 0.001;
        }
        double maxDistance = 2147483.646;
        if (Double.isNaN(distance)) {
            LOGGER.warn("Bug in OSM or GraphHopper. Illegal tower node distance " + distance + " reset to 1m, osm way " + way.getId());
            distance = 1.0;
        }
        if (Double.isInfinite(distance) || distance > maxDistance) {
            LOGGER.warn("Bug in OSM or GraphHopper. Too big tower node distance " + distance + " reset to large value, osm way " + way.getId());
            distance = maxDistance;
        }
        this.setArtificialWayTags(pointList, way, distance, nodeTags);
        IntsRef relationFlags = this.getRelFlagsMap(way.getId());
        IntsRef edgeFlags = this.encodingManager.createEdgeFlags();
        edgeFlags = this.osmParsers.handleWayTags(edgeFlags, way, relationFlags);
        if (edgeFlags.isEmpty()) {
            return;
        }
        EdgeIteratorState edge = this.baseGraph.edge(fromIndex, toIndex).setDistance(distance).setFlags(edgeFlags);
        List<EdgeKVStorage.KeyValue> list = way.getTag("key_values", Collections.emptyList());
        if (!list.isEmpty()) {
            edge.setKeyValues(list);
        }
        if (pointList.size() > 2) {
            this.checkCoordinates(fromIndex, (GHPoint)pointList.get(0));
            this.checkCoordinates(toIndex, (GHPoint)pointList.get(pointList.size() - 1));
            edge.setWayGeometry(pointList.shallowCopy(1, pointList.size() - 1, false));
        }
        this.checkDistance(edge);
        if (this.osmWayIdSet.contains(way.getId())) {
            this.getEdgeIdToOsmWayIdMap().put(edge.getEdge(), way.getId());
        }
    }

    private void checkCoordinates(int nodeIndex, GHPoint point) {
        double tolerance = 1.0E-6;
        if (Math.abs(this.nodeAccess.getLat(nodeIndex) - point.getLat()) > 1.0E-6 || Math.abs(this.nodeAccess.getLon(nodeIndex) - point.getLon()) > 1.0E-6) {
            throw new IllegalStateException("Suspicious coordinates for node " + nodeIndex + ": (" + this.nodeAccess.getLat(nodeIndex) + "," + this.nodeAccess.getLon(nodeIndex) + ") vs. (" + point + ")");
        }
    }

    private void checkDistance(EdgeIteratorState edge) {
        double tolerance = 1.0;
        double edgeDistance = edge.getDistance();
        double geometryDistance = this.distCalc.calcDistance(edge.fetchWayGeometry(FetchMode.ALL));
        if (Double.isInfinite(edgeDistance)) {
            throw new IllegalStateException("Infinite edge distance should never occur, as we are supposed to limit each distance to the maximum distance we can store, #435");
        }
        if (edgeDistance > 2000000.0) {
            LOGGER.warn("Very long edge detected: " + edge + " dist: " + edgeDistance);
        } else if (Math.abs(edgeDistance - geometryDistance) > 1.0) {
            throw new IllegalStateException("Suspicious distance for edge: " + edge + " " + edgeDistance + " vs. " + geometryDistance + ", difference: " + (edgeDistance - geometryDistance));
        }
    }

    protected void preprocessWay(ReaderWay way, WaySegmentParser.CoordinateSupplier coordinateSupplier) {
        long durationInSeconds;
        ArrayList<EdgeKVStorage.KeyValue> list = new ArrayList<EdgeKVStorage.KeyValue>();
        if (this.config.isParseWayNames()) {
            String refName;
            String name = "";
            if (!this.config.getPreferredLanguage().isEmpty()) {
                name = OSMReader.fixWayName(way.getTag("name:" + this.config.getPreferredLanguage()));
            }
            if (name.isEmpty()) {
                name = OSMReader.fixWayName(way.getTag("name"));
            }
            if (!name.isEmpty()) {
                list.add(new EdgeKVStorage.KeyValue("street_name", name));
            }
            if (!(refName = OSMReader.fixWayName(way.getTag("ref"))).isEmpty()) {
                list.add(new EdgeKVStorage.KeyValue("street_ref", refName));
            }
            if (way.hasTag("destination:ref", new String[0])) {
                list.add(new EdgeKVStorage.KeyValue("street_destination_ref", OSMReader.fixWayName(way.getTag("destination:ref"))));
            } else {
                if (way.hasTag("destination:ref:forward", new String[0])) {
                    list.add(new EdgeKVStorage.KeyValue("street_destination_ref", OSMReader.fixWayName(way.getTag("destination:ref:forward")), true, false));
                }
                if (way.hasTag("destination:ref:backward", new String[0])) {
                    list.add(new EdgeKVStorage.KeyValue("street_destination_ref", OSMReader.fixWayName(way.getTag("destination:ref:backward")), false, true));
                }
            }
            if (way.hasTag("destination", new String[0])) {
                list.add(new EdgeKVStorage.KeyValue("street_destination", OSMReader.fixWayName(way.getTag("destination"))));
            } else {
                if (way.hasTag("destination:forward", new String[0])) {
                    list.add(new EdgeKVStorage.KeyValue("street_destination", OSMReader.fixWayName(way.getTag("destination:forward")), true, false));
                }
                if (way.hasTag("destination:backward", new String[0])) {
                    list.add(new EdgeKVStorage.KeyValue("street_destination", OSMReader.fixWayName(way.getTag("destination:backward")), false, true));
                }
            }
        }
        way.setTag("key_values", list);
        if (!this.isCalculateWayDistance(way)) {
            return;
        }
        double distance = this.calcDistance(way, coordinateSupplier);
        if (Double.isNaN(distance)) {
            LOGGER.warn("Could not determine distance for OSM way: " + way.getId());
            return;
        }
        way.setTag("way_distance", distance);
        String durationTag = way.getTag("duration");
        if (durationTag == null) {
            if (this.isFerry(way) && distance > 500000.0) {
                LOGGER.warn("Long ferry OSM way without duration tag: " + way.getId() + ", distance: " + Math.round(distance / 1000.0) + " km");
            }
            return;
        }
        try {
            durationInSeconds = OSMReaderUtility.parseDuration(durationTag);
        }
        catch (Exception e) {
            LOGGER.warn("Could not parse duration tag '" + durationTag + "' in OSM way: " + way.getId());
            return;
        }
        double speedInKmPerHour = distance / 1000.0 / ((double)durationInSeconds / 60.0 / 60.0);
        if (speedInKmPerHour < 0.1) {
            LOGGER.warn("Unrealistic low speed calculated from duration. Maybe the duration is too long, or it is applied to a way that only represents a part of the connection? OSM way: " + way.getId() + ". duration=" + durationTag + " (= " + Math.round((double)durationInSeconds / 60.0) + " minutes), distance=" + distance + " m");
            return;
        }
        way.setTag("speed_from_duration", speedInKmPerHour);
        way.setTag("duration:seconds", durationInSeconds);
    }

    static String fixWayName(String str) {
        if (str == null) {
            return "";
        }
        return EdgeKVStorage.cutString(WAY_NAME_PATTERN.matcher(str).replaceAll(", "));
    }

    private double calcDistance(ReaderWay way, WaySegmentParser.CoordinateSupplier coordinateSupplier) {
        LongArrayList nodes = way.getNodes();
        GHPoint3D prevPoint = coordinateSupplier.getCoordinate(nodes.get(0));
        if (prevPoint == null) {
            return Double.NaN;
        }
        boolean is3D = !Double.isNaN(prevPoint.ele);
        double distance = 0.0;
        for (int i = 1; i < nodes.size(); ++i) {
            GHPoint3D point = coordinateSupplier.getCoordinate(nodes.get(i));
            if (point == null) {
                return Double.NaN;
            }
            if (Double.isNaN(point.ele) == is3D) {
                throw new IllegalStateException("There should be elevation data for either all points or no points at all. OSM way: " + way.getId());
            }
            distance += is3D ? this.distCalc.calcDist3D(prevPoint.lat, prevPoint.lon, prevPoint.ele, point.lat, point.lon, point.ele) : this.distCalc.calcDist(prevPoint.lat, prevPoint.lon, point.lat, point.lon);
            prevPoint = point;
        }
        return distance;
    }

    protected void preprocessRelations(ReaderRelation relation) {
        if (!relation.isMetaRelation() && relation.hasTag("type", (Object)"route")) {
            for (ReaderRelation.Member member : relation.getMembers()) {
                if (member.getType() != ReaderElement.Type.WAY) continue;
                IntsRef oldRelationFlags = this.getRelFlagsMap(member.getRef());
                IntsRef newRelationFlags = this.osmParsers.handleRelationTags(relation, oldRelationFlags);
                this.putRelFlagsMap(member.getRef(), newRelationFlags);
            }
        }
        if (relation.hasTag("type", (Object)"restriction")) {
            List<OSMTurnRestriction> turnRestrictions = OSMReader.createTurnRestrictions(relation);
            for (OSMTurnRestriction turnRestriction : turnRestrictions) {
                this.osmWayIdSet.add(turnRestriction.getOsmIdFrom());
                this.osmWayIdSet.add(turnRestriction.getOsmIdTo());
            }
        }
    }

    protected void processRelation(ReaderRelation relation, final LongToIntFunction getIdForOSMNodeId) {
        if (this.turnCostStorage != null && relation.hasTag("type", (Object)"restriction")) {
            TurnCostParser.ExternalInternalMap map = new TurnCostParser.ExternalInternalMap(){

                @Override
                public int getInternalNodeIdOfOsmNode(long nodeOsmId) {
                    return getIdForOSMNodeId.applyAsInt(nodeOsmId);
                }

                @Override
                public long getOsmIdOfInternalEdge(int edgeId) {
                    return OSMReader.this.getEdgeIdToOsmWayIdMap().get(edgeId);
                }
            };
            for (OSMTurnRestriction turnRestriction : OSMReader.createTurnRestrictions(relation)) {
                int viaNode = map.getInternalNodeIdOfOsmNode(turnRestriction.getViaOsmNodeId());
                if (viaNode < 0) continue;
                this.osmParsers.handleTurnRestrictionTags(turnRestriction, map, this.baseGraph);
            }
        }
    }

    private IntLongMap getEdgeIdToOsmWayIdMap() {
        if (this.edgeIdToOsmWayIdMap == null) {
            this.edgeIdToOsmWayIdMap = new GHIntLongHashMap(this.osmWayIdSet.size(), 0.5);
        }
        return this.edgeIdToOsmWayIdMap;
    }

    static List<OSMTurnRestriction> createTurnRestrictions(ReaderRelation relation) {
        String tagExcept;
        ArrayList<OSMTurnRestriction> osmTurnRestrictions = new ArrayList<OSMTurnRestriction>();
        String vehicleTypeRestricted = "";
        ArrayList<String> vehicleTypesExcept = new ArrayList<String>();
        if (relation.hasTag("except", new String[0]) && !Helper.isEmpty((String)(tagExcept = relation.getTag("except")))) {
            ArrayList<String> vehicleTypes = new ArrayList<String>(Arrays.asList(tagExcept.split(";")));
            for (String vehicleType : vehicleTypes) {
                vehicleTypesExcept.add(vehicleType.trim());
            }
        }
        if (relation.hasTag("restriction", new String[0])) {
            osmTurnRestrictions.addAll(OSMReader.createTurnRestrictions(relation, relation.getTag("restriction"), vehicleTypeRestricted, vehicleTypesExcept));
            return osmTurnRestrictions;
        }
        if (relation.hasTagWithKeyPrefix("restriction:")) {
            List<String> vehicleTypesRestricted = relation.getKeysWithPrefix("restriction:");
            for (String vehicleType : vehicleTypesRestricted) {
                String restrictionType = relation.getTag(vehicleType);
                vehicleTypeRestricted = vehicleType.replace("restriction:", "").trim();
                osmTurnRestrictions.addAll(OSMReader.createTurnRestrictions(relation, restrictionType, vehicleTypeRestricted, vehicleTypesExcept));
            }
        }
        return osmTurnRestrictions;
    }

    static List<OSMTurnRestriction> createTurnRestrictions(ReaderRelation relation, String restrictionType, String vehicleTypeRestricted, List<String> vehicleTypesExcept) {
        OSMTurnRestriction.RestrictionType type = OSMTurnRestriction.RestrictionType.getRestrictionType(restrictionType);
        if (type != OSMTurnRestriction.RestrictionType.UNSUPPORTED) {
            long viaNodeID = -1L;
            long toWayID = -1L;
            for (ReaderRelation.Member member : relation.getMembers()) {
                if (ReaderElement.Type.WAY == member.getType() && "to".equals(member.getRole())) {
                    toWayID = member.getRef();
                    continue;
                }
                if (ReaderElement.Type.NODE != member.getType() || !"via".equals(member.getRole())) continue;
                viaNodeID = member.getRef();
            }
            if (toWayID >= 0L && viaNodeID >= 0L) {
                ArrayList<OSMTurnRestriction> res = new ArrayList<OSMTurnRestriction>(2);
                for (ReaderRelation.Member member : relation.getMembers()) {
                    if (ReaderElement.Type.WAY != member.getType() || !"from".equals(member.getRole())) continue;
                    OSMTurnRestriction osmTurnRestriction = new OSMTurnRestriction(member.getRef(), viaNodeID, toWayID, type);
                    osmTurnRestriction.setVehicleTypeRestricted(vehicleTypeRestricted);
                    osmTurnRestriction.setVehicleTypesExcept(vehicleTypesExcept);
                    res.add(osmTurnRestriction);
                }
                return res;
            }
        }
        return Collections.emptyList();
    }

    private void finishedReading() {
        this.eleProvider.release();
        this.osmWayIdToRelationFlagsMap = null;
        this.osmWayIdSet = null;
        this.edgeIdToOsmWayIdMap = null;
    }

    IntsRef getRelFlagsMap(long osmId) {
        long relFlagsAsLong = this.osmWayIdToRelationFlagsMap.get(osmId);
        this.tempRelFlags.ints[0] = (int)relFlagsAsLong;
        this.tempRelFlags.ints[1] = (int)(relFlagsAsLong >> 32);
        return this.tempRelFlags;
    }

    void putRelFlagsMap(long osmId, IntsRef relFlags) {
        long relFlagsAsLong = (long)relFlags.ints[1] << 32 | (long)relFlags.ints[0] & 0xFFFFFFFFL;
        this.osmWayIdToRelationFlagsMap.put(osmId, relFlagsAsLong);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

