/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import com.graphhopper.reader.ReaderElement;
import com.graphhopper.reader.osm.OSMFileHeader;
import com.graphhopper.reader.osm.OSMInput;
import com.graphhopper.reader.osm.OSMXMLHelper;
import com.graphhopper.reader.osm.pbf.PbfReader;
import com.graphhopper.reader.osm.pbf.Sink;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class OSMInputFile
implements Sink,
OSMInput {
    private static final int MAX_BATCH_SIZE = 1000;
    private final InputStream bis;
    private final BlockingQueue<ReaderElement> itemQueue;
    private final Queue<ReaderElement> itemBatch;
    private boolean eof;
    private XMLStreamReader xmlParser;
    private boolean binary = false;
    private PbfReader pbfReader;
    private Thread pbfReaderThread;
    private boolean hasIncomingData;
    private int workerThreads = -1;
    private OSMFileHeader fileheader;

    public OSMInputFile(File file) throws IOException {
        this.bis = this.decode(file);
        this.itemQueue = new LinkedBlockingQueue<ReaderElement>(50000);
        this.itemBatch = new ArrayDeque<ReaderElement>(1000);
    }

    public OSMInputFile open() throws XMLStreamException {
        if (this.binary) {
            this.openPBFReader(this.bis);
        } else {
            this.openXMLStream(this.bis);
        }
        return this;
    }

    public OSMInputFile setWorkerThreads(int threads) {
        this.workerThreads = threads;
        return this;
    }

    private InputStream decode(File file) throws IOException {
        String name = file.getName();
        BufferedInputStream ips = null;
        try {
            ips = new BufferedInputStream(new FileInputStream(file), 50000);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        ((InputStream)ips).mark(10);
        byte[] header = new byte[6];
        if (((InputStream)ips).read(header) < 0) {
            throw new IllegalArgumentException("Input file is not of valid type " + file.getPath());
        }
        if (header[0] == 31 && header[1] == -117) {
            ((InputStream)ips).reset();
            return new GZIPInputStream((InputStream)ips, 50000);
        }
        if (header[0] == 0 && header[1] == 0 && header[2] == 0 && header[4] == 10 && header[5] == 9 && (header[3] == 13 || header[3] == 14)) {
            ((InputStream)ips).reset();
            this.binary = true;
            return ips;
        }
        if (header[0] == 80 && header[1] == 75) {
            ((InputStream)ips).reset();
            ZipInputStream zip = new ZipInputStream(ips);
            zip.getNextEntry();
            return zip;
        }
        if (name.endsWith(".osm") || name.endsWith(".xml")) {
            ((InputStream)ips).reset();
            return ips;
        }
        if (name.endsWith(".bz2") || name.endsWith(".bzip2")) {
            String clName = "org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream";
            try {
                Class<?> clazz = Class.forName(clName);
                ((InputStream)ips).reset();
                Constructor<?> ctor = clazz.getConstructor(InputStream.class, Boolean.TYPE);
                return (InputStream)ctor.newInstance(ips, true);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot instantiate " + clName, e);
            }
        }
        throw new IllegalArgumentException("Input file is not of valid type " + file.getPath());
    }

    private void openXMLStream(InputStream in) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        this.xmlParser = factory.createXMLStreamReader(in, "UTF-8");
        int event = this.xmlParser.next();
        if (event != 1 || !this.xmlParser.getLocalName().equalsIgnoreCase("osm")) {
            throw new IllegalArgumentException("File is not a valid OSM stream");
        }
        String timestamp = this.xmlParser.getAttributeValue(null, "osmosis_replication_timestamp");
        if (timestamp == null) {
            timestamp = this.xmlParser.getAttributeValue(null, "timestamp");
        }
        if (timestamp != null) {
            try {
                this.fileheader = new OSMFileHeader();
                this.fileheader.setTag("timestamp", timestamp);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.eof = false;
    }

    @Override
    public ReaderElement getNext() throws XMLStreamException {
        if (this.eof) {
            throw new IllegalStateException("EOF reached");
        }
        ReaderElement item = this.binary ? this.getNextPBF() : this.getNextXML();
        if (item != null) {
            return item;
        }
        this.eof = true;
        return null;
    }

    private ReaderElement getNextXML() throws XMLStreamException {
        int event = this.xmlParser.next();
        if (this.fileheader != null) {
            OSMFileHeader copyfileheader = this.fileheader;
            this.fileheader = null;
            return copyfileheader;
        }
        while (event != 8) {
            String idStr;
            if (event == 1 && (idStr = this.xmlParser.getAttributeValue(null, "id")) != null) {
                String name = this.xmlParser.getLocalName();
                long id = 0L;
                switch (name.charAt(0)) {
                    case 'n': {
                        if (!"node".equals(name)) break;
                        id = Long.parseLong(idStr);
                        return OSMXMLHelper.createNode(id, this.xmlParser);
                    }
                    case 'w': {
                        id = Long.parseLong(idStr);
                        return OSMXMLHelper.createWay(id, this.xmlParser);
                    }
                    case 'r': {
                        id = Long.parseLong(idStr);
                        return OSMXMLHelper.createRelation(id, this.xmlParser);
                    }
                }
            }
            event = this.xmlParser.next();
        }
        this.xmlParser.close();
        return null;
    }

    public boolean isEOF() {
        return this.eof;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.binary) {
                this.pbfReader.close();
            } else {
                this.xmlParser.close();
            }
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex);
        }
        finally {
            this.eof = true;
            this.bis.close();
            if (this.pbfReaderThread != null && this.pbfReaderThread.isAlive()) {
                this.pbfReaderThread.interrupt();
            }
        }
    }

    private void openPBFReader(InputStream stream) {
        this.hasIncomingData = true;
        if (this.workerThreads <= 0) {
            this.workerThreads = 1;
        }
        this.pbfReader = new PbfReader(stream, this, this.workerThreads);
        this.pbfReaderThread = new Thread((Runnable)this.pbfReader, "PBF Reader");
        this.pbfReaderThread.start();
    }

    @Override
    public void process(ReaderElement item) {
        try {
            this.itemQueue.put(item);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public int getUnprocessedElements() {
        return this.itemQueue.size() + this.itemBatch.size();
    }

    @Override
    public void complete() {
        this.hasIncomingData = false;
    }

    private ReaderElement getNextPBF() {
        while (this.itemBatch.isEmpty()) {
            if (!this.hasIncomingData && this.itemQueue.isEmpty()) {
                return null;
            }
            if (this.itemQueue.drainTo(this.itemBatch, 1000) != 0) continue;
            try {
                ReaderElement element = this.itemQueue.poll(100L, TimeUnit.MILLISECONDS);
                if (element == null) continue;
                return element;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.itemBatch.poll();
    }
}

